/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.hap.pacs.impaxee.studyshare.task;

import com.agfa.hap.pacs.impaxee.studyshare.IPermissionTask;
import com.agfa.hap.pacs.impaxee.studyshare.IStudyShareConfig;
import com.agfa.hap.pacs.impaxee.studyshare.IStudyShareData;
import com.agfa.hap.pacs.impaxee.studyshare.IStudyShareSettings;
import com.agfa.hap.pacs.impaxee.studyshare.exception.StudiesAlreadySharedException;
import com.agfa.hap.pacs.impaxee.studyshare.exception.StudyShareException;
import com.agfa.hap.pacs.impaxee.studyshare.task.AbstractStudyShareTask;
import com.agfa.hap.pacs.impaxee.studyshare.xml.StudyAccess;
import com.agfa.hap.pacs.impaxee.util.XMLUtils;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.util.Date;
import org.apache.commons.lang3.time.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Node;

abstract class AbstractPermissionTask
extends AbstractStudyShareTask<IStudyShareData>
implements IPermissionTask {
    private static final Logger log = LoggerFactory.getLogger(AbstractPermissionTask.class);
    protected static final String ERROR_NODE_NAME = "error";
    private static final String EMPTY_RESULT_NODE_NAME = "noResult";
    private static final String INSUFFICIENT_STUDY_PERMISSION_ERROR_MESSAGE = "insufficient studypermission for creating webaccess!";
    private final boolean isEmptyResultAllowed;

    AbstractPermissionTask(IStudyShareConfig iStudyShareConfig, boolean bl) {
        super(iStudyShareConfig);
        this.isEmptyResultAllowed = bl;
    }

    @Override
    public IStudyShareConfig getConfig() {
        return this.config;
    }

    long getRoundedUpExpirationDate(IStudyShareSettings iStudyShareSettings) {
        return DateUtils.ceiling((Date)iStudyShareSettings.getExpirationDate(), (int)5).getTime() - 1L;
    }

    @Override
    String getRequestURLPath() {
        return "portal/servlet/ExternalAccessServlet";
    }

    @Override
    IStudyShareData readResponse(HttpURLConnection httpURLConnection) throws IOException, StudyShareException {
        Node node = XMLUtils.createDocumentRoot(httpURLConnection.getInputStream());
        String string = ERROR_NODE_NAME.equalsIgnoreCase(node.getNodeName()) ? XMLUtils.getNodeValue(node) : XMLUtils.findNodeValue(node, ERROR_NODE_NAME);
        if (string != null) {
            if ("External Access already created!".equals(string)) {
                throw new StudiesAlreadySharedException();
            }
            if (INSUFFICIENT_STUDY_PERMISSION_ERROR_MESSAGE.equals(string)) {
                if (this.isEmptyResultAllowed) {
                    return IStudyShareData.NONE;
                }
                if (this.getRetrySettings().isInsufficientStudyPermissionRetryEnabled()) {
                    log.debug("Study permissions not yet set, retrying ...");
                    return null;
                }
            }
            throw new StudyShareException(string);
        }
        IStudyShareData iStudyShareData = this.isEmptyResultAllowed && EMPTY_RESULT_NODE_NAME.equalsIgnoreCase(node.getNodeName()) ? IStudyShareData.NONE : StudyAccess.parseNodes(XMLUtils.findAllNodes(node, "studyaccess"), this.getSessionCookie());
        return iStudyShareData;
    }
}

