/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.hap.pacs.impaxee.studyshare.task;

import com.agfa.hap.pacs.impaxee.studyshare.IStudyShareConfig;
import com.agfa.hap.pacs.impaxee.studyshare.IStudyShareTask;
import com.agfa.hap.pacs.impaxee.studyshare.StudyShareFailureType;
import com.agfa.hap.pacs.impaxee.studyshare.StudyShareParameter;
import com.agfa.hap.pacs.impaxee.studyshare.exception.StudiesAlreadySharedException;
import com.agfa.hap.pacs.impaxee.studyshare.exception.StudyShareAuthenticationException;
import com.agfa.hap.pacs.impaxee.studyshare.exception.StudyShareException;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.URLEncoder;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import java.util.EnumMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AbstractStudyShareTask<R>
implements IStudyShareTask<R> {
    private static final Logger log = LoggerFactory.getLogger(AbstractStudyShareTask.class);
    final IStudyShareConfig config;
    private IStudyShareTask.IStudyShareProgressListener listener;
    private String sessionCookie;
    private R result;
    private StudyShareFailureType failureType;

    AbstractStudyShareTask(IStudyShareConfig iStudyShareConfig) {
        this.config = iStudyShareConfig;
    }

    @Override
    public void setListener(IStudyShareTask.IStudyShareProgressListener iStudyShareProgressListener) {
        this.listener = iStudyShareProgressListener;
    }

    @Override
    public boolean execute() {
        try {
            this.executeTask();
        }
        catch (StudyShareAuthenticationException studyShareAuthenticationException) {
            log.warn("Authentication for Internet study shared failed.");
            this.setFailed(StudyShareFailureType.UserAuthenticationFailed);
            this.result = null;
        }
        catch (StudiesAlreadySharedException studiesAlreadySharedException) {
            log.warn("Studies have already been shared.");
            this.setFailed(StudyShareFailureType.StudiesAlreadyShared);
            this.result = null;
        }
        catch (ConnectException | SocketTimeoutException | UnknownHostException iOException) {
            log.warn("The study share server is unavailable.", (Throwable)iOException);
            this.setFailed(StudyShareFailureType.ServerUnavailable);
            this.result = null;
        }
        catch (Exception exception) {
            log.error("Study share task failed.", (Throwable)exception);
            this.result = null;
        }
        return this.result != null;
    }

    private void executeTask() throws IOException, StudyShareException {
        this.setProgress(0.1);
        URL uRL = new URL(this.getRequestURL());
        if (this.sessionCookie == null) {
            this.sessionCookie = this.createSessionCookie();
        }
        if (this.sessionCookie == null) {
            this.sessionCookie = this.createSessionCookie(uRL);
        }
        if (this.sessionCookie == null) {
            throw new StudyShareAuthenticationException();
        }
        this.setProgress(0.25);
        RetrySettings retrySettings = this.getRetrySettings();
        int n = retrySettings.getRetryCount() + 1;
        double d = 0.75 / (double)n;
        int n2 = 0;
        while (n2 < n) {
            double d2 = 0.3 + d * (double)n2;
            this.setProgress(d2);
            if (this.executeTaskImpl(uRL, d2, d / 4.0)) {
                log.debug("Study share task successfully completed.");
                break;
            }
            if (n2 < n - 1) {
                long l = retrySettings.getRetryDelay();
                if (log.isDebugEnabled()) {
                    StringBuilder stringBuilder = new StringBuilder();
                    stringBuilder.append("Delaying retry #");
                    stringBuilder.append(n2 + 1);
                    stringBuilder.append(" of ");
                    stringBuilder.append(n - 1);
                    stringBuilder.append(" by ");
                    stringBuilder.append(l);
                    stringBuilder.append("ms");
                    log.debug(stringBuilder.toString());
                }
                try {
                    Thread.sleep(l);
                }
                catch (InterruptedException interruptedException) {
                    log.warn("Retry delay interrupted.", (Throwable)interruptedException);
                    Thread.currentThread().interrupt();
                }
            } else {
                log.warn("Aborting after maximum number of retries.");
            }
            ++n2;
        }
        this.setProgress(1.0);
    }

    private boolean executeTaskImpl(URL uRL, double d, double d2) throws IOException, StudyShareException {
        HttpURLConnection httpURLConnection = null;
        try {
            log.trace("Connecting to Internet study share server ...");
            httpURLConnection = this.openConnectionForHttpPost(uRL, this.sessionCookie, new IHttpURLConnectionConfigurator[0]);
            this.setProgress(d + d2);
            log.trace("Sending request to Internet study share server ...");
            this.sendRequest(httpURLConnection, this.getRequestParameters());
            this.setProgress(d + 2.0 * d2);
            int n = httpURLConnection.getResponseCode();
            if (n == 501) {
                log.debug("Received HTTP status code {}, retrying ...", (Object)n);
                return false;
            }
            if (n != 200) {
                throw new IOException("HTTP request failed with status code " + n);
            }
            this.setProgress(d + 3.0 * d2);
            log.trace("Reading response from Internet study share server ...");
            this.result = this.readResponse(httpURLConnection);
            boolean bl = this.result != null;
            return bl;
        }
        finally {
            if (httpURLConnection != null) {
                httpURLConnection.disconnect();
            }
        }
    }

    void setProgress(double d) {
        if (this.listener != null) {
            this.listener.setProgress(d);
        }
    }

    void setFailed(StudyShareFailureType studyShareFailureType) {
        this.failureType = studyShareFailureType;
        if (this.listener != null) {
            this.listener.notifyFailure(this.failureType);
        }
    }

    @Override
    public StudyShareFailureType getFailureType() {
        return this.failureType;
    }

    @Override
    public R getResult() {
        return this.result;
    }

    private String getRequestURL() {
        return this.getInternalURL(this.getRequestURLPath());
    }

    String getInternalURL(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.config.getInternalURL());
        if (stringBuilder.charAt(stringBuilder.length() - 1) != '/') {
            stringBuilder.append('/');
        }
        stringBuilder.append(string);
        return stringBuilder.toString();
    }

    abstract String getRequestURLPath();

    abstract Map<StudyShareParameter, String> getRequestParameters();

    String getSessionCookie() {
        return this.sessionCookie;
    }

    abstract String createSessionCookie();

    private String createSessionCookie(URL uRL) throws IOException {
        log.debug("Creating session cookie ...");
        HttpURLConnection httpURLConnection = null;
        try {
            httpURLConnection = this.openConnectionForHttpPost(uRL, null, new IHttpURLConnectionConfigurator[0]);
            httpURLConnection.setInstanceFollowRedirects(false);
            EnumMap<StudyShareParameter, String> enumMap = new EnumMap<StudyShareParameter, String>(StudyShareParameter.class);
            enumMap.put(StudyShareParameter.ACTION, "empty");
            this.sendRequest(httpURLConnection, enumMap);
            int n = httpURLConnection.getResponseCode();
            if (n != 200) {
                return null;
            }
            if (!httpURLConnection.getContentType().startsWith("text/html")) {
                return null;
            }
            String string = this.getCookie(httpURLConnection);
            if (string == null) {
                return null;
            }
            URL uRL2 = httpURLConnection.getURL();
            httpURLConnection.disconnect();
            httpURLConnection = null;
            String string2 = uRL2.getPath();
            string2 = string2.substring(0, string2.lastIndexOf(47));
            string2 = String.valueOf(string2) + "/j_security_check";
            uRL2 = new URL(uRL2.getProtocol(), uRL2.getHost(), uRL2.getPort(), string2);
            httpURLConnection = this.openConnectionForHttpPost(uRL2, string, new AuthenticationHttpURLConnectionConfigurator());
            httpURLConnection.setInstanceFollowRedirects(false);
            this.sendRequest(httpURLConnection, this.config.getAuthenticationParameters());
            int n2 = httpURLConnection.getResponseCode();
            if (n2 == 302) {
                String string3 = this.getCookie(httpURLConnection);
                if (string3 != null) {
                    string = string3;
                }
                String string4 = string;
                return string4;
            }
        }
        finally {
            if (httpURLConnection != null) {
                httpURLConnection.disconnect();
            }
        }
        return null;
    }

    private String getCookie(HttpURLConnection httpURLConnection) {
        String string = httpURLConnection.getHeaderField("Set-Cookie");
        if (string == null || !string.startsWith("JSESSIONID=")) {
            return null;
        }
        return string.substring(0, string.indexOf(59));
    }

    private HttpURLConnection openConnectionForHttpPost(URL uRL, String string, IHttpURLConnectionConfigurator ... iHttpURLConnectionConfiguratorArray) throws IOException {
        HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
        if (string != null) {
            httpURLConnection.setRequestProperty("Cookie", string);
        }
        httpURLConnection.setRequestMethod("POST");
        httpURLConnection.setDoInput(true);
        httpURLConnection.setDoOutput(true);
        IHttpURLConnectionConfigurator[] iHttpURLConnectionConfiguratorArray2 = iHttpURLConnectionConfiguratorArray;
        int n = iHttpURLConnectionConfiguratorArray.length;
        int n2 = 0;
        while (n2 < n) {
            IHttpURLConnectionConfigurator iHttpURLConnectionConfigurator = iHttpURLConnectionConfiguratorArray2[n2];
            iHttpURLConnectionConfigurator.configureConnection(httpURLConnection);
            ++n2;
        }
        httpURLConnection.connect();
        return httpURLConnection;
    }

    private void sendRequest(HttpURLConnection httpURLConnection, Map<? extends Object, String> map) throws IOException {
        Throwable throwable = null;
        Object var4_5 = null;
        try (OutputStreamWriter outputStreamWriter = new OutputStreamWriter(httpURLConnection.getOutputStream(), StandardCharsets.UTF_8);){
            boolean bl = true;
            for (Map.Entry<? extends Object, String> entry : map.entrySet()) {
                if (bl) {
                    bl = false;
                } else {
                    outputStreamWriter.write(38);
                }
                outputStreamWriter.write(entry.getKey().toString());
                outputStreamWriter.write(61);
                outputStreamWriter.write(URLEncoder.encode(entry.getValue(), StandardCharsets.UTF_8.name()));
            }
            outputStreamWriter.flush();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    abstract RetrySettings getRetrySettings();

    abstract R readResponse(HttpURLConnection var1) throws IOException, StudyShareException;

    private static class AuthenticationHttpURLConnectionConfigurator
    implements IHttpURLConnectionConfigurator {
        private AuthenticationHttpURLConnectionConfigurator() {
        }

        @Override
        public void configureConnection(HttpURLConnection httpURLConnection) {
            httpURLConnection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
            httpURLConnection.setAllowUserInteraction(true);
            httpURLConnection.setUseCaches(false);
        }
    }

    private static interface IHttpURLConnectionConfigurator {
        public void configureConnection(HttpURLConnection var1);
    }

    static class RetrySettings {
        static final RetrySettings DEFAULT = new RetrySettings(2, 500L, false);
        private final int retryCount;
        private final long retryDelay;
        private final boolean isInsufficientStudyPermissionRetryEnabled;

        RetrySettings(int n, long l, boolean bl) {
            this.retryCount = n;
            this.retryDelay = l;
            this.isInsufficientStudyPermissionRetryEnabled = bl;
        }

        boolean isInsufficientStudyPermissionRetryEnabled() {
            return this.isInsufficientStudyPermissionRetryEnabled;
        }

        int getRetryCount() {
            return this.retryCount;
        }

        long getRetryDelay() {
            return this.retryDelay;
        }
    }
}

