/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.hap.pacs.impaxee.studyshare.task;

import com.agfa.hap.pacs.impaxee.studyshare.IPermissionTask;
import com.agfa.hap.pacs.impaxee.studyshare.IStudyShareSettings;
import com.agfa.hap.pacs.impaxee.studyshare.StudyShareParameter;
import com.agfa.hap.pacs.impaxee.studyshare.task.AbstractPermissionModificationTask;
import com.agfa.pacs.auditing.IAuditing;
import com.agfa.pacs.auditing.ReferencedData;
import java.util.EnumMap;
import java.util.Map;
import org.dcm4che3.audit.AuditMessage;
import org.dcm4che3.audit.AuditMessages;
import org.dcm4che3.audit.EventIdentification;
import org.dcm4che3.audit.EventTypeCode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PermissionChangeTask
extends AbstractPermissionModificationTask {
    private static final Logger LOGGER = LoggerFactory.getLogger(PermissionChangeTask.class);
    private static final String ACTION_NAME = "eaModify";
    private final IStudyShareSettings options;
    private final IAuditing auditing;

    public PermissionChangeTask(IPermissionTask iPermissionTask, IStudyShareSettings iStudyShareSettings, IAuditing iAuditing) {
        super(iPermissionTask);
        this.options = iStudyShareSettings;
        this.auditing = iAuditing;
    }

    @Override
    public boolean execute() {
        if (this.getQueryResult() == null) {
            return false;
        }
        boolean bl = super.execute();
        try {
            this.auditPermissionChange(bl);
        }
        catch (Exception exception) {
            LOGGER.error("Auditing permission change failed", (Throwable)exception);
        }
        return bl;
    }

    private void auditPermissionChange(boolean bl) {
        AuditMessage auditMessage = new AuditMessage();
        EventIdentification eventIdentification = AuditMessages.createEventIdentification((AuditMessages.EventID)AuditMessages.EventID.SecurityAlert, (String)"E", null, (String)"0", null, (EventTypeCode[])new EventTypeCode[]{AuditMessages.EventTypeCode.SecurityConfiguration});
        auditMessage.setEventIdentification(eventIdentification);
        ReferencedData referencedData = this.auditing.prepareReferencedData(this.getStudies().forAuditing());
        referencedData.addToMessage(auditMessage);
        this.auditing.logAuditMessage(auditMessage, bl ? "0" : "8");
    }

    @Override
    Map<StudyShareParameter, String> getRequestParameters() {
        EnumMap<StudyShareParameter, String> enumMap = new EnumMap<StudyShareParameter, String>(StudyShareParameter.class);
        enumMap.put(StudyShareParameter.EXPIRATION_DATE, Long.toString(this.getRoundedUpExpirationDate(this.options)));
        enumMap.put(StudyShareParameter.ACTION, ACTION_NAME);
        enumMap.put(StudyShareParameter.PERMISSION, Integer.toString(this.options.getPermission().getCode()));
        enumMap.put(StudyShareParameter.IDS, this.getQueryResult().getInternalIDs());
        return enumMap;
    }
}

