/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.hap.pacs.impaxee.studyshare.task;

import com.agfa.hap.pacs.impaxee.studyshare.ISharedStudies;
import com.agfa.hap.pacs.impaxee.studyshare.IStudyShareConfig;
import com.agfa.hap.pacs.impaxee.studyshare.IStudyShareSettings;
import com.agfa.hap.pacs.impaxee.studyshare.StudyShareParameter;
import com.agfa.hap.pacs.impaxee.studyshare.task.AbstractStudyPermissionTask;
import com.agfa.hap.pacs.impaxee.studyshare.task.AbstractStudyShareTask;
import java.util.EnumMap;
import java.util.Map;

public class PermissionCreationTask
extends AbstractStudyPermissionTask {
    private static final String ACTION_NAME = "eaCreate";
    private final IStudyShareSettings options;
    private final String patientBirthDate;

    public PermissionCreationTask(ISharedStudies iSharedStudies, IStudyShareSettings iStudyShareSettings, IStudyShareConfig iStudyShareConfig) {
        super(iSharedStudies, iStudyShareConfig, false);
        this.options = iStudyShareSettings;
        this.patientBirthDate = StudyShareParameter.formatDate(iSharedStudies.getPatient().getDate(0x100030));
    }

    @Override
    String createSessionCookie() {
        return null;
    }

    @Override
    Map<StudyShareParameter, String> getRequestParameters() {
        EnumMap<StudyShareParameter, String> enumMap = new EnumMap<StudyShareParameter, String>(StudyShareParameter.class);
        enumMap.put(StudyShareParameter.EXPIRATION_DATE, Long.toString(this.getRoundedUpExpirationDate(this.options)));
        enumMap.put(StudyShareParameter.PATIENT_BIRTHDATE, this.patientBirthDate);
        enumMap.put(StudyShareParameter.USER_ID, this.config.getUserId());
        enumMap.put(StudyShareParameter.ACTION, ACTION_NAME);
        enumMap.put(StudyShareParameter.PERMISSION, Integer.toString(this.options.getPermission().getCode()));
        enumMap.put(StudyShareParameter.STUDY_UIDS, this.getStudyUIDs());
        return enumMap;
    }

    @Override
    AbstractStudyShareTask.RetrySettings getRetrySettings() {
        return new AbstractStudyShareTask.RetrySettings(9, 15000L, true);
    }
}

