/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.hap.pacs.impaxee.studyshare.task;

import com.agfa.hap.pacs.impaxee.studyshare.IPermissionTask;
import com.agfa.hap.pacs.impaxee.studyshare.IStudyShareData;
import com.agfa.hap.pacs.impaxee.studyshare.StudyShareParameter;
import com.agfa.hap.pacs.impaxee.studyshare.exception.StudyShareException;
import com.agfa.hap.pacs.impaxee.studyshare.task.AbstractPermissionModificationTask;
import com.agfa.hap.pacs.impaxee.util.XMLUtils;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Node;

public class PermissionRevokeTask
extends AbstractPermissionModificationTask {
    private static final Logger log = LoggerFactory.getLogger(PermissionRevokeTask.class);
    private static final String ACTION_NAME = "eaDelete";
    private static final String DELETED_NODE_NAME = "deleted";

    public PermissionRevokeTask(IPermissionTask iPermissionTask) {
        super(iPermissionTask);
    }

    @Override
    Map<StudyShareParameter, String> getRequestParameters() {
        EnumMap<StudyShareParameter, String> enumMap = new EnumMap<StudyShareParameter, String>(StudyShareParameter.class);
        enumMap.put(StudyShareParameter.USER_ID, this.config.getUserId());
        enumMap.put(StudyShareParameter.ACTION, ACTION_NAME);
        enumMap.put(StudyShareParameter.IDS, this.getQueryResult().getInternalIDs());
        return enumMap;
    }

    @Override
    IStudyShareData readResponse(HttpURLConnection httpURLConnection) throws IOException, StudyShareException {
        Node node = XMLUtils.createDocumentRoot(httpURLConnection.getInputStream());
        String string = node.getNodeName().equalsIgnoreCase("error") ? XMLUtils.getNodeValue(node) : XMLUtils.findNodeValue(node, "error");
        if (string != null) {
            log.error("Failed to revoke study share permissions: {}", (Object)string);
            throw new StudyShareException(string);
        }
        String string2 = this.getQueryResult().getInternalIDs();
        ArrayList<String> arrayList = new ArrayList<String>(Arrays.asList(StringUtils.split((String)string2, (char)',')));
        if (node.getNodeName().equals(DELETED_NODE_NAME)) {
            String[] stringArray;
            String string3 = XMLUtils.getNodeValue(node);
            String[] stringArray2 = stringArray = StringUtils.split((String)string3, (char)',');
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String string4 = stringArray2[n2];
                if (!arrayList.contains(string4)) {
                    throw new StudyShareException("Revoked study permission for a non recorded study");
                }
                arrayList.remove(string4);
                ++n2;
            }
            if (!arrayList.isEmpty()) {
                throw new StudyShareException("Not all studies of the study share have been removed");
            }
        } else {
            throw new StudyShareException("Unknown response while revoking study permissions");
        }
        return IStudyShareData.NONE;
    }
}

