/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.hap.pacs.impaxee.studyshare.xml;

import com.agfa.hap.pacs.impaxee.studyshare.IStudyShareData;
import com.agfa.hap.pacs.impaxee.studyshare.StudySharePermission;
import com.agfa.hap.pacs.impaxee.studyshare.StudyShareSettings;
import com.agfa.hap.pacs.impaxee.util.XMLUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Node;

public class StudyAccess
extends StudyShareSettings
implements IStudyShareData {
    public static final String NODE_NAME = "studyaccess";
    private static final Logger LOGGER = LoggerFactory.getLogger(StudyAccess.class);
    private static final String ACCESS_CODE_ATTRIBUTE_NAME = "access_code";
    private static final String BIRTH_DATE_ATTRIBUTE_NAME = "birthdate";
    private static final String PERMISSION_ATTRIBUTE_NAME = "permission";
    private static final String EXPIRATION_DATE_ATTRIBUTE_NAME = "expiration_time";
    private static final String ID_ATTRIBUTE_NAME = "id";
    private static final String STUDY_UID_ATTRIBUTE_NAME = "study_iuid";
    private static final int ACCESS_CODE_PART_COUNT = 4;
    private static final int ACCESS_CODE_PART_LENGTH = 4;
    private final String sessionCookie;
    private final String accessCode;
    private final String birthDate;
    private final List<String> ids;

    private StudyAccess(Node node, String string) {
        super(StudyAccess.parsePermission(node), StudyAccess.parseExpirationDate(node));
        this.sessionCookie = string;
        this.accessCode = StudyAccess.parseAccessCode(node);
        this.birthDate = StudyAccess.parseBirthDate(node);
        this.ids = new ArrayList<String>();
    }

    public static StudyAccess parseNodes(List<Node> list, String string) {
        if (list == null || list.isEmpty()) {
            LOGGER.warn("No XML nodes given.");
            return null;
        }
        Node node = list.get(0);
        StudyAccess studyAccess = new StudyAccess(node, string);
        if (!studyAccess.isValid()) {
            ArrayList<String> arrayList = new ArrayList<String>(3);
            if (studyAccess.getPatientBirthDate() == null) {
                arrayList.add(BIRTH_DATE_ATTRIBUTE_NAME);
            }
            if (studyAccess.getPermission() == null) {
                arrayList.add(PERMISSION_ATTRIBUTE_NAME);
            }
            if (studyAccess.getExpirationDate() == null) {
                arrayList.add(EXPIRATION_DATE_ATTRIBUTE_NAME);
            }
            if (!arrayList.isEmpty()) {
                LOGGER.warn(StudyAccess.getMissingAttributesWarning(node, arrayList));
            }
            if (studyAccess.getAccessCode() != null && !studyAccess.isAccessCodeValid()) {
                LOGGER.warn("Invalid access code given for {}: {}", (Object)node, (Object)studyAccess.getAccessCode());
            }
            return null;
        }
        for (Node node2 : list) {
            if (studyAccess.add(node2)) continue;
            LOGGER.warn("Inconsistent result node: {}", (Object)node2);
            return null;
        }
        return studyAccess;
    }

    private boolean isValid() {
        return this.birthDate != null && this.getPermission() != null && this.hasExpirationDate() && this.isAccessCodeValid();
    }

    private boolean isAccessCodeValid() {
        return this.accessCode != null && this.accessCode.length() >= 16;
    }

    private boolean add(Node node) {
        return this.checkConsistency(node) && this.addStudyData(node);
    }

    private boolean checkConsistency(Node node) {
        return Objects.equals(this.accessCode, StudyAccess.parseAccessCode(node)) && Objects.equals(this.birthDate, StudyAccess.parseBirthDate(node)) && Objects.equals((Object)this.getPermission(), (Object)StudyAccess.parsePermission(node)) && Objects.equals(this.getExpirationDate(), StudyAccess.parseExpirationDate(node));
    }

    private static String parseAccessCode(Node node) {
        return XMLUtils.getAttribute(node, ACCESS_CODE_ATTRIBUTE_NAME);
    }

    private static String parseBirthDate(Node node) {
        return XMLUtils.getAttribute(node, BIRTH_DATE_ATTRIBUTE_NAME);
    }

    private static StudySharePermission parsePermission(Node node) {
        Integer n = XMLUtils.getIntegerAttribute(node, PERMISSION_ATTRIBUTE_NAME);
        if (n == null) {
            return null;
        }
        return StudySharePermission.getByCode(n);
    }

    private static Date parseExpirationDate(Node node) {
        String string = XMLUtils.getAttribute(node, EXPIRATION_DATE_ATTRIBUTE_NAME);
        try {
            return new Date(Long.parseLong(string));
        }
        catch (Exception exception) {
            return null;
        }
    }

    private boolean addStudyData(Node node) {
        String string = XMLUtils.getAttribute(node, ID_ATTRIBUTE_NAME);
        String string2 = XMLUtils.getAttribute(node, STUDY_UID_ATTRIBUTE_NAME);
        if (string == null || string2 == null) {
            ArrayList<String> arrayList = new ArrayList<String>(2);
            if (string == null) {
                arrayList.add(ID_ATTRIBUTE_NAME);
            }
            if (string2 == null) {
                arrayList.add(STUDY_UID_ATTRIBUTE_NAME);
            }
            LOGGER.warn(StudyAccess.getMissingAttributesWarning(node, arrayList));
            return false;
        }
        this.ids.add(string);
        return true;
    }

    private static String getMissingAttributesWarning(Node node, List<String> list) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Missing required attribute");
        if (list.size() > 1) {
            stringBuilder.append('s');
        }
        stringBuilder.append(" for ");
        stringBuilder.append(node);
        stringBuilder.append(": ");
        boolean bl = true;
        for (String string : list) {
            if (!bl) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(string);
            bl = false;
        }
        return stringBuilder.toString();
    }

    @Override
    public String getSessionCookie() {
        return this.sessionCookie;
    }

    @Override
    public String getPatientBirthDate() {
        return this.birthDate;
    }

    @Override
    public int getStudyCount() {
        return this.ids.size();
    }

    @Override
    public String getInternalIDs() {
        StringBuilder stringBuilder = new StringBuilder();
        for (String string : this.ids) {
            stringBuilder.append(string);
            stringBuilder.append(',');
        }
        if (stringBuilder.length() > 0) {
            stringBuilder.deleteCharAt(stringBuilder.length() - 1);
        }
        return stringBuilder.toString();
    }

    @Override
    public String getAccessCode() {
        StringBuilder stringBuilder = new StringBuilder();
        int n = 0;
        while (n < 4) {
            stringBuilder.append(this.accessCode.substring(4 * n, 4 * (n + 1)));
            stringBuilder.append('-');
            ++n;
        }
        stringBuilder.deleteCharAt(stringBuilder.length() - 1);
        return stringBuilder.toString();
    }
}

