/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.data.hl7;

import java.util.Locale;
import org.dcm4che3.hl7.HL7Message;
import org.dcm4che3.hl7.HL7Segment;

public enum AcknowledgementCode {
    AA("Application Accept"),
    AE("Application Error"),
    AR("Application Reject"),
    CA("Commit Accept"),
    CE("Commit Error"),
    CR("Commit Reject"),
    UNKNOWN("Unknown Error");

    private String description;

    private AcknowledgementCode(String string2) {
        this.description = string2;
    }

    public String getDescription() {
        return this.description;
    }

    public static AcknowledgementCode fromHL7Message(HL7Message hL7Message) {
        HL7Segment hL7Segment = hL7Message.getSegment("MSA");
        if (hL7Segment != null) {
            String string = hL7Segment.getField(1, "");
            try {
                return AcknowledgementCode.valueOf(string.toUpperCase(Locale.ENGLISH));
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
        return UNKNOWN;
    }
}

