/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.data.hl7;

import java.text.SimpleDateFormat;
import java.util.Date;
import org.dcm4che3.data.Keyword;
import org.dcm4che3.data.PersonName;

public class HL7Utilities {
    private static final String ADT_08_TEMPLATE = "MSH|^~\\&|" + PATIENT_TEMPLATE_KEY.SENDING_APP.name() + "||||||ADT^A08|103130|P|2.3.1||||||||\r" + "EVN||" + PATIENT_TEMPLATE_KEY.CURRENT_DATE.name() + "||||" + PATIENT_TEMPLATE_KEY.CURRENT_DATE.name() + "\r" + "PID|||" + PATIENT_TEMPLATE_KEY.PATIENT_ID.name() + "^^^" + PATIENT_TEMPLATE_KEY.ISSUER.name() + "^^" + "||" + PATIENT_TEMPLATE_KEY.PATIENT_NAME.name() + "||" + PATIENT_TEMPLATE_KEY.PATIENT_BIRTHDATE.name() + "|" + PATIENT_TEMPLATE_KEY.PATIENT_SEX.name() + "|||||||||||||||||||||||||||||||\r" + "PV1||I|||||||||||||" + PATIENT_TEMPLATE_KEY.PATIENT_AMBULATORY_STATUS.name() + "|||||||||||||||||||||||||||||||||||||\r";
    private static final String HL7_DATE_FORMAT = "yyyyMMddHHmm";

    public static String createPatientModificationMessage(PersonName personName, String string, String string2, int n, Object object, String string3) throws PatientAttributeModificationUnsupportedException {
        if (!HL7Utilities.isPatientAttributeModificationSupported(n)) {
            throw new PatientAttributeModificationUnsupportedException(n);
        }
        String string4 = ADT_08_TEMPLATE;
        PATIENT_TEMPLATE_KEY[] pATIENT_TEMPLATE_KEYArray = PATIENT_TEMPLATE_KEY.values();
        int n2 = pATIENT_TEMPLATE_KEYArray.length;
        int n3 = 0;
        while (n3 < n2) {
            PATIENT_TEMPLATE_KEY pATIENT_TEMPLATE_KEY = pATIENT_TEMPLATE_KEYArray[n3];
            if (PATIENT_TEMPLATE_KEY.PATIENT_ID == pATIENT_TEMPLATE_KEY) {
                string4 = string4.replaceAll(pATIENT_TEMPLATE_KEY.name(), string);
            } else if (PATIENT_TEMPLATE_KEY.PATIENT_NAME == pATIENT_TEMPLATE_KEY) {
                string4 = string4.replaceAll(pATIENT_TEMPLATE_KEY.name(), personName.toString());
            } else if (PATIENT_TEMPLATE_KEY.ISSUER == pATIENT_TEMPLATE_KEY) {
                string4 = string4.replaceAll(pATIENT_TEMPLATE_KEY.name(), string2 != null ? string2 : "");
            } else if (PATIENT_TEMPLATE_KEY.CURRENT_DATE == pATIENT_TEMPLATE_KEY) {
                string4 = string4.replaceAll(pATIENT_TEMPLATE_KEY.name(), new SimpleDateFormat(HL7_DATE_FORMAT).format(new Date()));
            } else if (PATIENT_TEMPLATE_KEY.SENDING_APP == pATIENT_TEMPLATE_KEY) {
                string4 = string4.replaceFirst(pATIENT_TEMPLATE_KEY.name(), string3);
            } else {
                int n4 = pATIENT_TEMPLATE_KEY.getDicomTag();
                if (n == n4) {
                    String string5 = object.toString();
                    if (string5.length() == 0) {
                        string5 = "\"\"";
                    }
                    string4 = string4.replaceFirst(pATIENT_TEMPLATE_KEY.name(), string5);
                } else {
                    string4 = string4.replaceFirst(pATIENT_TEMPLATE_KEY.name(), "");
                }
            }
            ++n3;
        }
        return string4;
    }

    public static boolean isPatientAttributeModificationSupported(int n) {
        PATIENT_TEMPLATE_KEY[] pATIENT_TEMPLATE_KEYArray = PATIENT_TEMPLATE_KEY.values();
        int n2 = pATIENT_TEMPLATE_KEYArray.length;
        int n3 = 0;
        while (n3 < n2) {
            PATIENT_TEMPLATE_KEY pATIENT_TEMPLATE_KEY = pATIENT_TEMPLATE_KEYArray[n3];
            int n4 = pATIENT_TEMPLATE_KEY.getDicomTag();
            if (n4 > 0 && n == n4) {
                return true;
            }
            ++n3;
        }
        return false;
    }

    private static enum PATIENT_TEMPLATE_KEY {
        SENDING_APP(-1),
        CURRENT_DATE(-1),
        PATIENT_ID(-1),
        PATIENT_NAME(-1),
        ISSUER(-1),
        PATIENT_BIRTHDATE(0x100030),
        PATIENT_SEX(0x100040),
        PATIENT_AMBULATORY_STATUS(3671296);

        private int dicomTag;

        private PATIENT_TEMPLATE_KEY(int n2) {
            this.dicomTag = n2;
        }

        public int getDicomTag() {
            return this.dicomTag;
        }
    }

    public static class PatientAttributeModificationUnsupportedException
    extends Exception {
        PatientAttributeModificationUnsupportedException(int n) {
            super("Modification of patient attribute '" + Keyword.valueOf((int)n) + "' unsupported");
        }
    }
}

