/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.data.hl7;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.Socket;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.UnrecoverableKeyException;
import java.util.Locale;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import org.dcm4che3.hl7.HL7Message;
import org.dcm4che3.hl7.MLLPConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MLLPSender {
    private static final Logger log = LoggerFactory.getLogger(MLLPSender.class);
    private static final String DEFAULT_CHARSET = Locale.getDefault().equals(Locale.US) || Locale.getDefault().equals(Locale.CANADA) || Locale.getDefault().equals(Locale.CANADA_FRENCH) ? "UTF-8" : "ISO-8859-1";
    private String host;
    private int port;
    private Proxy proxy;
    private boolean tlsEnabled = false;
    private KeyManager keyManager;
    private TrustManager trustManager;
    private int connectionTimeout;
    private int requestTimeout;

    public MLLPSender(String string, int n) {
        this.host = string;
        this.port = n;
    }

    public MLLPSender(String string, int n, Proxy proxy) {
        this(string, n);
        this.proxy = proxy;
    }

    public void configureTLS(boolean bl, KeyManager keyManager, TrustManager trustManager) {
        this.tlsEnabled = bl;
        this.keyManager = keyManager;
        this.trustManager = trustManager;
    }

    public void setTimeoutValues(int n, int n2) {
        this.connectionTimeout = n;
        this.requestTimeout = n2;
    }

    public HL7Message sendMessage(String string) throws UnrecoverableKeyException, KeyManagementException, NoSuchAlgorithmException, KeyStoreException, IOException {
        return this.sendMessage(string, DEFAULT_CHARSET);
    }

    public HL7Message sendMessage(String string, String string2) throws IOException, UnrecoverableKeyException, KeyManagementException, NoSuchAlgorithmException, KeyStoreException {
        log.info("Sending HL7 message (remote host: {}, remote port: {})", (Object)this.host, (Object)this.port);
        log.debug("Message sent: {}", (Object)string);
        Socket socket = this.tlsEnabled ? this.createSecureSocket() : this.createSocket();
        MLLPConnection mLLPConnection = new MLLPConnection(socket);
        mLLPConnection.writeMessage(string.getBytes(string2));
        return HL7Message.parse((byte[])mLLPConnection.readMessage(), (String)string2);
    }

    private Socket createSocket() throws IOException {
        Socket socket;
        if (this.proxy != null) {
            socket = new Socket(this.proxy);
            InetSocketAddress inetSocketAddress = new InetSocketAddress(this.host, this.port);
            socket.connect(inetSocketAddress, this.connectionTimeout);
        } else {
            socket = new Socket(this.host, this.port);
        }
        socket.setSoTimeout(this.requestTimeout);
        return socket;
    }

    private Socket createSecureSocket() throws NoSuchAlgorithmException, KeyManagementException, IOException {
        Socket socket;
        SSLContext sSLContext = SSLContext.getInstance("TLS");
        sSLContext.init(new KeyManager[]{this.keyManager}, new TrustManager[]{this.trustManager}, new SecureRandom());
        if (this.proxy != null) {
            Socket socket2 = new Socket(this.proxy);
            InetSocketAddress inetSocketAddress = new InetSocketAddress(this.host, this.port);
            socket2.connect(inetSocketAddress, this.connectionTimeout);
            socket = sSLContext.getSocketFactory().createSocket(socket2, this.host, this.port, true);
        } else {
            socket = sSLContext.getSocketFactory().createSocket(this.host, this.port);
        }
        socket.setSoTimeout(this.requestTimeout);
        return socket;
    }
}

