/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.data.pix;

import com.agfa.pacs.auditing.IAuditing;
import com.agfa.pacs.data.hl7.AcknowledgementCode;
import com.agfa.pacs.data.hl7.MLLPSender;
import com.agfa.pacs.data.pix.IPIXOptions;
import com.agfa.pacs.data.pix.PIXQueryAudit;
import com.agfa.pacs.data.shared.certificate.ICertificateProvider;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.SocketAddress;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.concurrent.atomic.AtomicLong;
import org.dcm4che3.audit.AuditMessage;
import org.dcm4che3.hl7.HL7Message;
import org.dcm4che3.hl7.HL7Segment;
import org.dcm4che3.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PIXQuery {
    private static final Logger log = LoggerFactory.getLogger(PIXQuery.class);
    private static final String DATETIME_FORMAT = "yyyyMMddHHmmss";
    private static AtomicLong msgCtrlid = new AtomicLong(System.currentTimeMillis());
    private static AtomicLong queryTag = new AtomicLong(msgCtrlid.get());
    private AuditMessage pixQueryAuditMessage;
    private IPIXOptions options;
    private IAuditing audit;
    private ICertificateProvider certificateProvider;

    public PIXQuery(IPIXOptions iPIXOptions, IAuditing iAuditing, ICertificateProvider iCertificateProvider) {
        this.options = iPIXOptions;
        this.audit = iAuditing;
        this.certificateProvider = iCertificateProvider;
    }

    public String sendPixQuery(String string, String string2, boolean bl) {
        String string3 = null;
        if (this.options.getHostAddress() != null && this.options.getHostPort() != 0) {
            MLLPSender mLLPSender;
            Object object;
            Object object2;
            if (this.options.getUsePIXProxy()) {
                object2 = new InetSocketAddress(this.options.getProxyAddress(), this.options.getProxyPort());
                object = new Proxy(Proxy.Type.SOCKS, (SocketAddress)object2);
                mLLPSender = new MLLPSender(this.options.getHostAddress(), this.options.getHostPort(), (Proxy)object);
            } else {
                mLLPSender = new MLLPSender(this.options.getHostAddress(), this.options.getHostPort());
            }
            mLLPSender.setTimeoutValues(this.options.getConnectionTimeout(), this.options.getRequestTimeout());
            if (this.options.getUseTLS()) {
                if (this.certificateProvider != null) {
                    mLLPSender.configureTLS(true, this.certificateProvider.getKeyManager(), this.certificateProvider.getTrustManager());
                } else {
                    throw new UnsupportedOperationException("No Certificate Provider has been supplied although TLS was configured for HL7, performing UNSECURE HL7 request!");
                }
            }
            object2 = String.valueOf(this.options.getHostApplication()) + "^" + this.options.getHostFacility();
            object = "IHE PIX Query";
            try {
                String string4 = String.valueOf(string2 != null ? string2 : "") + this.options.getUniversalID();
                String string5 = this.buildQBP_Q23((String)object2, (String)object, string, string4, this.options.getTargetDomain());
                log.debug("PIX query: {}", (Object)string5);
                HL7Message hL7Message = mLLPSender.sendMessage(string5);
                log.debug("PIX response: {}", (Object)hL7Message);
                string3 = this.parseHL7Response(hL7Message, bl);
                this.sendPIXAuditLogMessage(true);
            }
            catch (Exception exception) {
                this.sendPIXAuditLogMessage(false);
                log.error("Failed to send/parse HL7 v2 PIX query", (Throwable)exception);
            }
        } else {
            log.error("PIX not configured!");
        }
        return string3;
    }

    private String parseHL7Response(HL7Message hL7Message, boolean bl) throws PIXException {
        if (hL7Message == null) {
            this.sendPIXAuditLogMessage(false);
            return null;
        }
        String string = null;
        AcknowledgementCode acknowledgementCode = AcknowledgementCode.fromHL7Message(hL7Message);
        if (acknowledgementCode != AcknowledgementCode.AA) {
            log.error("Error during HL7-PIX query.");
            HL7Segment hL7Segment = hL7Message.getSegment("ERR");
            if (hL7Segment != null) {
                log.error("Error response: {} {}", (Object)hL7Segment.getField(3, ""), (Object)hL7Segment.getField(4, ""));
            } else {
                log.error("No ERR segment found!");
            }
            this.sendPIXAuditLogMessage(false);
        } else {
            String[] stringArray;
            HL7Segment hL7Segment = hL7Message.getSegment("PID");
            if (hL7Segment != null && (stringArray = StringUtils.split((String)hL7Segment.getField(3, ""), (char)'~')).length > 0) {
                string = stringArray[0];
                if (bl) {
                    string = PIXQuery.cleanPID(string);
                }
            }
        }
        return string;
    }

    private static String cleanPID(String string) throws PIXException {
        String[] stringArray = StringUtils.split((String)string, (char)'^');
        if (stringArray.length < 4 || stringArray.length > 6) {
            throw new PIXException("Wrong number of segments in PID-3");
        }
        String[] stringArray2 = StringUtils.split((String)stringArray[3], (char)'&');
        if (stringArray2.length != 3) {
            throw new PIXException("Wrong number of parts in assigning authority");
        }
        return String.valueOf(stringArray[0]) + "^^^&" + stringArray2[1] + "&" + stringArray2[2];
    }

    private void sendPIXAuditLogMessage(boolean bl) {
        if (this.pixQueryAuditMessage != null && this.audit != null) {
            log.debug("Sending audit log message for PIXQuery");
            this.audit.logAuditMessage(this.pixQueryAuditMessage, bl ? "0" : "4");
            this.pixQueryAuditMessage = null;
        }
    }

    private String buildQBP_Q23(String string, String string2, String string3, String string4, String string5) {
        String string6 = new SimpleDateFormat(DATETIME_FORMAT).format(new Date());
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.makeMSH(string6, "QBP^Q23^QBP_Q21", null, string, msgCtrlid.incrementAndGet(), "2.5"));
        stringBuilder.append('\r');
        stringBuilder.append(this.makeQPD(string2, queryTag.incrementAndGet(), string3, string4, string5));
        stringBuilder.append("\rRCP|I||||||\r");
        String string7 = stringBuilder.toString();
        log.info("Query PIX Manager {}:\n{}", (Object)string, (Object)string7.replace('\r', '\n'));
        this.pixQueryAuditMessage = null;
        if (this.options.getSendAuditLogForPIXQuery()) {
            this.pixQueryAuditMessage = PIXQueryAudit.createPixQueryAudit(this.options.getHomeApplication(), this.options.getHomeFacility(), this.options.getHostApplication(), this.options.getHostFacility(), this.options.getHostAddress(), string3, string7, Long.toString(msgCtrlid.get()));
        }
        return string7;
    }

    private String makeQPD(String string, long l, String string2, String string3, String string4) {
        StringBuilder stringBuilder = new StringBuilder("QPD|");
        stringBuilder.append(string).append('|');
        stringBuilder.append(l).append('|');
        stringBuilder.append(string2).append("^^^").append(string3);
        if (string4 != null) {
            stringBuilder.append("|^^^").append(string4);
        }
        return stringBuilder.toString();
    }

    private String makeMSH(String string, String string2, String string3, String string4, long l, String string5) {
        int n;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("MSH|^~\\&|");
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)string3)) {
            stringBuilder.append(this.options.getHomeApplication()).append('|');
            stringBuilder.append(this.options.getHomeFacility()).append('|');
        } else {
            n = string3.indexOf(94);
            stringBuilder.append(string3.substring(0, n)).append('|');
            stringBuilder.append(string3.substring(n + 1)).append('|');
        }
        n = string4.indexOf(94);
        stringBuilder.append(string4.substring(0, n)).append('|');
        stringBuilder.append(string4.substring(n + 1)).append('|');
        stringBuilder.append(string).append("||");
        stringBuilder.append(string2).append('|');
        stringBuilder.append(l).append("|P|");
        stringBuilder.append(string5).append("||||||||");
        return stringBuilder.toString();
    }

    public static class PIXException
    extends Exception {
        public PIXException(String string) {
            super(string);
        }
    }
}

