/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.data.dicom.comm;

import com.agfa.pacs.data.dicom.DicomException;
import com.agfa.pacs.data.dicom.ICStoreSCU;
import com.agfa.pacs.data.dicom.comm.DicomSCU;
import com.agfa.pacs.data.shared.data.FileMetaInformationUtils;
import com.agfa.pacs.data.shared.dicom.IDicomNode;
import com.agfa.pacs.data.shared.dicom.UIDMap;
import com.agfa.pacs.data.shared.dicom.UIDUtilities;
import com.agfa.pacs.logging.ALogger;
import java.util.Set;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.ElementDictionary;
import org.dcm4che3.net.DataWriter;
import org.dcm4che3.net.DataWriterAdapter;
import org.dcm4che3.util.TagUtils;

public class DicomCStoreSCU
extends DicomSCU
implements ICStoreSCU {
    private static final ALogger log = ALogger.getLogger(DicomCStoreSCU.class);

    public DicomCStoreSCU(IDicomNode iDicomNode, UIDMap uIDMap) {
        super(iDicomNode);
        this.addTransferCapabilities(uIDMap);
    }

    @Override
    public synchronized void store(Attributes attributes) throws DicomException {
        try {
            String string = attributes.getString(524310);
            String string2 = attributes.getString(524312);
            String string3 = attributes.getString(131088);
            Attributes attributes2 = new Attributes(attributes);
            FileMetaInformationUtils.removeFileMetaInformation((Attributes)attributes2);
            this.store(string, string2, string3, (DataWriter)new DataWriterAdapter(attributes2));
        }
        catch (DicomException dicomException) {
            throw dicomException;
        }
        catch (Exception exception) {
            throw new DicomException(exception);
        }
    }

    public synchronized void store(String string, String string2, String string3, DataWriter dataWriter) throws DicomException {
        try {
            Set set;
            Set set2 = this.association.getTransferSyntaxesFor(string);
            if (set2 == null || set2.isEmpty()) {
                throw new Exception("Class " + string + " not supported -> Store Failed ");
            }
            if (string3 == null) {
                set = UIDUtilities.getDefaultTransferSyntaxUIDs();
                for (String string4 : set2) {
                    if (!set.contains(string4)) continue;
                    string3 = string4;
                    break;
                }
            }
            if (string3 == null) {
                throw new DicomException("No Transfer Syntax UID for Class " + string + " not supported -> Store Failed ");
            }
            if (!set2.contains(string3)) {
                throw new DicomException("Transfer Syntax UID " + string3 + " for Class " + string + " not supported -> Store Failed ");
            }
            set = this.association.cstore(string, string2, 1, dataWriter, string3);
            while (set.next()) {
                String string4;
                string4 = set.getCommand();
                this.handleStatus((Attributes)string4, true);
            }
        }
        catch (DicomException dicomException) {
            throw dicomException;
        }
        catch (Exception exception) {
            throw new DicomException(exception);
        }
    }

    @Override
    protected void handleStatus(Attributes attributes, boolean bl) throws DicomException {
        super.handleStatus(attributes, bl);
        int n = attributes.getInt(2304, 0);
        switch (n) {
            case 0: {
                if (!log.isDebugEnabled()) break;
                log.debug("Status: " + Integer.toHexString(n));
                log.debug("SUCCESS: Sub-operations complete - no failures.");
                break;
            }
            case 42752: {
                log.error("Status: " + Integer.toHexString(n));
                log.error("FAILURE: Refused: Out of Resources.");
                log.error(attributes.getString(2306));
                this.showTags(attributes.getInts(2305));
                throw new DicomException(n, "FAILURE: Refused: Out of Resources.");
            }
            case 43264: {
                log.error("Status: " + Integer.toHexString(n));
                log.error("FAILURE: Data Set Does Not Match SOP Class.");
                log.error(attributes.getString(2306));
                this.showTags(attributes.getInts(2305));
                throw new DicomException(n, "FAILURE: Data Set Does Not Match SOP Class.");
            }
            case 49152: {
                log.error("Status: " + Integer.toHexString(n));
                log.error("FAILURE: Cannot understand.");
                log.error(attributes.getString(2306));
                this.showTags(attributes.getInts(2305));
                throw new DicomException(n, "FAILURE: Cannot understand.");
            }
            default: {
                log.error("Status: " + Integer.toHexString(n));
                if ((n & 0xC000) != 49152) break;
                log.error("FAILURE: Unable to process.");
                log.error("Error Comment: " + attributes.getString(2306));
                this.showTags(attributes.getInts(2305));
                throw new DicomException(n, "FAILURE: Unable to process.");
            }
        }
    }

    private void showTags(int[] nArray) {
        if (nArray == null) {
            return;
        }
        int[] nArray2 = nArray;
        int n = nArray.length;
        int n2 = 0;
        while (n2 < n) {
            int n3 = nArray2[n2];
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Tag: ");
            stringBuilder.append(TagUtils.toString((int)n3));
            stringBuilder.append(" ");
            stringBuilder.append(ElementDictionary.keywordOf((int)n3, null));
            log.info(stringBuilder.toString());
            ++n2;
        }
    }
}

