/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.data.dicom.comm;

import com.agfa.pacs.data.dicom.DicomException;
import com.agfa.pacs.data.dicom.IExtendedCFindSCU;
import com.agfa.pacs.data.dicom.QueryRetrieveLevel;
import com.agfa.pacs.data.dicom.comm.DicomSCU;
import com.agfa.pacs.data.dicom.comm.QueryRetrieveInformationModel;
import com.agfa.pacs.data.dicom.config.DicomConfigurationFactory;
import com.agfa.pacs.data.dicom.transfercapability.ITransferCapabilityProvider;
import com.agfa.pacs.data.shared.dicom.IDicomNode;
import com.agfa.pacs.data.shared.dicom.UIDUtilities;
import com.agfa.pacs.data.shared.profiler.IProfiler;
import com.agfa.pacs.data.shared.profiler.Profiler;
import com.agfa.pacs.logging.ALogger;
import com.agfa.pacs.tools.Pattern;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.ElementDictionary;
import org.dcm4che3.data.Sequence;
import org.dcm4che3.data.VR;
import org.dcm4che3.net.Association;
import org.dcm4che3.net.DimseRSP;
import org.dcm4che3.net.TransferCapability;
import org.dcm4che3.net.pdu.ExtendedNegotiation;
import org.dcm4che3.util.TagUtils;

public class DicomCompositeCFindSCU
extends DicomSCU
implements IExtendedCFindSCU {
    private static final ALogger log = ALogger.getLogger(DicomCompositeCFindSCU.class);
    private static IProfiler profiler = Profiler.getInstance();
    private static final String[] PrivateQueryClassUIDs = new String[]{"1.2.40.0.13.1.5.1.4.1.2.2.1.1", "1.2.40.0.13.1.5.1.4.1.2.2.1"};
    private static final String[] DicomQueryClassUIDs = new String[]{"1.2.840.10008.5.1.4.1.2.2.1", "1.2.840.10008.5.1.4.1.2.1.1", "1.2.840.10008.5.1.4.1.2.3.1"};
    public static final String[] DefaultQueryClassUIDs = new String[]{"1.2.40.0.13.1.5.1.4.1.2.2.1.1", "1.2.40.0.13.1.5.1.4.1.2.2.1", "1.2.840.10008.5.1.4.1.2.2.1", "1.2.840.10008.5.1.4.1.2.1.1"};
    public static final String[] DefaultStandardQueryClassUIDs = new String[]{"1.2.840.10008.5.1.4.1.2.2.1", "1.2.840.10008.5.1.4.1.2.1.1"};
    public static final String[] PatientStudyOnlyQueryClassUIDs = new String[]{"1.2.840.10008.5.1.4.1.2.3.1"};
    private boolean findBlocked;
    private boolean initReturnTags;
    private boolean semanticPNMatchingRequested;
    private boolean patientLevelQueryOnly = false;
    private QueryRetrieveInformationModel queryRetrieveInformationModel;
    private String qrTSUID;
    private String qrSOPClass;
    private String[] originalQueryClassUIDs;
    private byte[] originalExtInfo;
    private boolean cancel;

    public DicomCompositeCFindSCU(IDicomNode iDicomNode, String[] stringArray) {
        this(iDicomNode, stringArray, null, false);
    }

    public DicomCompositeCFindSCU(IDicomNode iDicomNode, String[] stringArray, byte[] byArray, boolean bl) {
        super(iDicomNode, bl);
        this.originalQueryClassUIDs = stringArray;
        this.originalExtInfo = byArray;
        this.initTransferCapabilities(stringArray, byArray);
    }

    private void initTransferCapabilities(String[] stringArray, byte[] byArray) {
        this.transferCapabilities.clear();
        Map<String, TransferCapability> map = DicomConfigurationFactory.getConfiguration().getQRCFindTransferCapabilities();
        String[] stringArray2 = stringArray;
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray2[n2];
            TransferCapability transferCapability = map.get(string);
            if (transferCapability != null) {
                this.addTransferCapability(transferCapability.getSopClass(), transferCapability.getTransferSyntaxes(), byArray);
            }
            ++n2;
        }
    }

    @Override
    protected List<ExtendedNegotiation> getExtendedNegotiations() {
        List<ExtendedNegotiation> list = super.getExtendedNegotiations();
        ArrayList<ExtendedNegotiation> arrayList = new ArrayList<ExtendedNegotiation>(list.size());
        for (ExtendedNegotiation extendedNegotiation : list) {
            arrayList.add(new ExtendedNegotiation(extendedNegotiation.getSOPClassUID(), this.modifyNegotiations(extendedNegotiation.getInformation())));
        }
        return arrayList;
    }

    private byte[] modifyNegotiations(byte[] byArray) {
        if (byArray.length >= 2) {
            byArray[2] = (byte)(this.semanticPNMatchingRequested ? 1 : 0);
        }
        return byArray;
    }

    private static String chooseTSUID(Set<String> set) {
        return set.iterator().next();
    }

    @Override
    public synchronized void connect() throws DicomException {
        Set set;
        String string;
        int n;
        int n2;
        String[] stringArray;
        super.connect();
        this.initReturnTags = true;
        this.qrTSUID = null;
        this.qrSOPClass = null;
        if (this.qrSOPClass == null) {
            stringArray = PrivateQueryClassUIDs;
            n2 = PrivateQueryClassUIDs.length;
            n = 0;
            while (n < n2) {
                string = stringArray[n];
                set = this.association.getTransferSyntaxesFor(string);
                if (set != null && !set.isEmpty()) {
                    if ("1.2.40.0.13.1.5.1.4.1.2.2.1.1".equals(string)) {
                        this.findBlocked = true;
                        this.initReturnTags = false;
                        this.queryRetrieveInformationModel = QueryRetrieveInformationModel.StudyRoot;
                    }
                    if ("1.2.40.0.13.1.5.1.4.1.2.2.1".equals(string)) {
                        this.findBlocked = false;
                        this.initReturnTags = false;
                        this.queryRetrieveInformationModel = QueryRetrieveInformationModel.StudyRoot;
                    }
                    if (this.queryRetrieveInformationModel != null) {
                        this.qrTSUID = DicomCompositeCFindSCU.chooseTSUID(set);
                        this.qrSOPClass = string;
                        break;
                    }
                }
                ++n;
            }
        }
        if (this.qrSOPClass == null) {
            stringArray = DicomQueryClassUIDs;
            n2 = DicomQueryClassUIDs.length;
            n = 0;
            while (n < n2) {
                string = stringArray[n];
                set = this.association.getTransferSyntaxesFor(string);
                if (set != null && !set.isEmpty()) {
                    if ("1.2.840.10008.5.1.4.1.2.1.1".equals(string)) {
                        this.findBlocked = false;
                        this.initReturnTags = true;
                        this.queryRetrieveInformationModel = QueryRetrieveInformationModel.PatientRoot;
                    }
                    if ("1.2.840.10008.5.1.4.1.2.2.1".equals(string)) {
                        this.findBlocked = false;
                        this.initReturnTags = true;
                        this.queryRetrieveInformationModel = QueryRetrieveInformationModel.StudyRoot;
                    }
                    if ("1.2.840.10008.5.1.4.1.2.3.1".equals(string)) {
                        this.findBlocked = false;
                        this.initReturnTags = true;
                        this.queryRetrieveInformationModel = QueryRetrieveInformationModel.PatientStudyOnly;
                    }
                    if (this.queryRetrieveInformationModel != null) {
                        this.qrTSUID = DicomCompositeCFindSCU.chooseTSUID(set);
                        this.qrSOPClass = string;
                        break;
                    }
                }
                ++n;
            }
        }
        if (this.qrSOPClass == null) {
            log.error("No Query SOP Class found !");
            log.info("Check if CalledAET and CallingAET are correct");
            log.info("Also check whether dicom archive is working correctly");
            throw new DicomException("No Query SOP Class found !");
        }
        log.info("C-FIND Q/R Model: " + (Object)((Object)this.getQueryRetrieveInformationModel()) + " | " + UIDUtilities.nameOf((String)this.qrSOPClass) + " | " + UIDUtilities.nameOf((String)this.qrTSUID));
        if (this.isExtendedNegotiationEnabled()) {
            this.fixDCM4CHENegotiatedTransferCapability(this.association, this.qrSOPClass);
            if (log.isDebugEnabled()) {
                log.debug("Semantic PN Matching (requested: " + this.isSemanticPNMatchingRequested() + ", negotiated: " + this.getExtInfoBoolean(this.qrSOPClass, 2) + ")");
            }
        }
    }

    public List<Attributes> find(Attributes attributes, QueryRetrieveLevel queryRetrieveLevel) throws DicomException {
        Attributes attributes2 = new Attributes();
        attributes2.addAll(attributes);
        attributes2.addAll(DicomConfigurationFactory.getConfiguration().createDicomObject());
        attributes2.setString(524370, VR.CS, queryRetrieveLevel.dicom());
        List<Attributes> list = this.cFind(attributes2);
        if (list.size() != 0 && !list.get(0).contains(524370)) {
            for (Attributes attributes3 : list) {
                attributes3.setString(524370, VR.CS, queryRetrieveLevel.dicom());
            }
        }
        return list;
    }

    @Override
    public synchronized List<Attributes> cFind(Attributes attributes) throws DicomException {
        boolean bl = Profiler.isProfilingEnabled();
        try {
            this.cancel = false;
            if (!this.isConnected()) {
                this.connect();
            }
            ArrayList<Object> arrayList = null;
            if (!this.findBlocked) {
                arrayList = new ArrayList<Attributes>(64);
            }
            if (bl) {
                profiler.addFindStart(attributes, null);
            }
            DimseRSP dimseRSP = this.association.cfind(this.qrSOPClass, 1, attributes, this.qrTSUID, -1);
            int n = 0;
            while (dimseRSP.next()) {
                if (this.cancel) {
                    dimseRSP.cancel(this.association);
                    break;
                }
                if (!this.handleStatus(dimseRSP, n++)) continue;
                if (this.findBlocked) {
                    Sequence sequence = dimseRSP.getDataset().getSequence(266784);
                    if (arrayList == null) {
                        arrayList = new ArrayList(sequence.size());
                    }
                    arrayList.addAll((Collection<Attributes>)sequence);
                    continue;
                }
                arrayList.add(dimseRSP.getDataset());
            }
            if (bl) {
                profiler.addFindEnd(attributes, this.association.getCalledAET(), arrayList == null ? 0 : arrayList.size(), null);
            }
            if (this.cancel && arrayList != null) {
                if (bl) {
                    profiler.addFindCanceled(attributes);
                }
                arrayList.clear();
                return arrayList;
            }
            if (arrayList == null) {
                return Collections.emptyList();
            }
            if (log.isTraceEnabled()) {
                log.trace("Received " + arrayList + " data items ");
            }
            return arrayList;
        }
        catch (DicomException dicomException) {
            if (bl) {
                profiler.addFindCanceled(attributes);
            }
            throw dicomException;
        }
        catch (Exception exception) {
            if (bl) {
                profiler.addFindCanceled(attributes);
            }
            throw new DicomException(exception);
        }
    }

    @Override
    public void cancel() {
        this.cancel = true;
    }

    private boolean handleStatus(DimseRSP dimseRSP, int n) throws DicomException {
        if (n % 100 != 0) {
            return this.isPending(dimseRSP.getCommand());
        }
        Attributes attributes = dimseRSP.getCommand();
        super.handleStatus(attributes, n == 0);
        int n2 = attributes.getInt(2304, 0);
        switch (n2) {
            case 65280: {
                if (!log.isTraceEnabled()) break;
                log.trace("Status: " + Integer.toHexString(n2));
                log.trace("PENDING: Successfully received data for the current request.");
                DicomCompositeCFindSCU.showNumbers(attributes);
                break;
            }
            case 65281: {
                if (!log.isTraceEnabled()) break;
                log.trace("Status: " + Integer.toHexString(n2));
                log.trace("PENDING: One or more optional keys were not supported for existence and/or matching for the Identifer.");
                DicomCompositeCFindSCU.showTags(attributes.getInts(2305));
                DicomCompositeCFindSCU.showNumbers(attributes);
                break;
            }
            case 0: {
                if (!log.isDebugEnabled()) break;
                log.debug("Status: " + Integer.toHexString(n2));
                log.debug("SUCCESS: Finished receiving data for the current request.");
                DicomCompositeCFindSCU.showNumbers(attributes);
                break;
            }
            case 42752: {
                log.error("Status: " + Integer.toHexString(n2));
                log.error("FAILURE: Refused: Out of Resources.");
                log.error(attributes.getString(2306));
                DicomCompositeCFindSCU.showTags(attributes.getInts(2305));
                DicomCompositeCFindSCU.showNumbers(attributes);
                throw new DicomException(n2, "FAILURE: Refused: Out of Resources.");
            }
            case 43264: {
                log.error("Status: " + Integer.toHexString(n2));
                log.error("FAILURE: Identifier does not match SOP Class.");
                log.error(attributes.getString(2306));
                DicomCompositeCFindSCU.showTags(attributes.getInts(2305));
                DicomCompositeCFindSCU.showNumbers(attributes);
                throw new DicomException(n2, "FAILURE: Identifier does not match SOP Class.");
            }
            case 65024: {
                log.info("Status: " + Integer.toHexString(n2));
                log.info("CANCEL: Request was cancelled.");
                DicomCompositeCFindSCU.showNumbers(attributes);
                break;
            }
            default: {
                log.error("Status: " + Integer.toHexString(n2));
                if ((n2 & 0xC000) != 49152) break;
                log.error("FAILURE: Unable to process.");
                log.error("Error Comment: " + attributes.getString(2306));
                DicomCompositeCFindSCU.showTags(attributes.getInts(2305));
                DicomCompositeCFindSCU.showNumbers(attributes);
                throw new DicomException(n2, "FAILURE: Unable to process.");
            }
        }
        return this.isPending(attributes);
    }

    private static void showTags(int[] nArray) {
        if (nArray == null) {
            return;
        }
        int[] nArray2 = nArray;
        int n = nArray.length;
        int n2 = 0;
        while (n2 < n) {
            int n3 = nArray2[n2];
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Tag: ");
            stringBuilder.append(TagUtils.toString((int)n3));
            stringBuilder.append(" ");
            stringBuilder.append(ElementDictionary.keywordOf((int)n3, null));
            log.error(stringBuilder.toString());
            ++n2;
        }
    }

    private static void showNumbers(Attributes attributes) {
        if (attributes.contains(4128)) {
            log.info("Remaining Sub-operations: " + attributes.getInt(4128, 0));
        }
        if (attributes.contains(4129)) {
            log.info("Completed Sub-operations: " + attributes.getInt(4129, 0));
        }
        if (attributes.contains(4130)) {
            log.info("Failed Sub-operations: " + attributes.getInt(4130, 0));
        }
        if (attributes.contains(4131)) {
            log.info("Warning Sub-operations: " + attributes.getInt(4131, 0));
        }
    }

    @Override
    public QueryRetrieveInformationModel getQueryRetrieveInformationModel() {
        return this.queryRetrieveInformationModel;
    }

    @Override
    public boolean isRelational() {
        return this.getExtInfoBoolean(this.qrSOPClass, 0);
    }

    public String getTransferSyntaxUID() {
        return this.qrTSUID;
    }

    public String getSOPClassUID() {
        return this.qrSOPClass;
    }

    public boolean isUsingTianiPrivateSOPClass() {
        return UIDUtilities.contains((String[])PrivateQueryClassUIDs, (String)this.qrSOPClass);
    }

    @Override
    public boolean isInitReturnTags() {
        return this.initReturnTags;
    }

    public boolean isSemanticPNMatchingRequested() {
        return this.semanticPNMatchingRequested;
    }

    @Override
    public boolean isSemanticPNMatchingEnabled() {
        return this.qrSOPClass != null && this.getExtInfoBoolean(this.qrSOPClass, 2);
    }

    public synchronized void setSemanticPNMatchingRequested(boolean bl) {
        if (this.semanticPNMatchingRequested != bl) {
            this.semanticPNMatchingRequested = bl;
            if (this.isConnected()) {
                try {
                    this.close();
                }
                catch (Exception exception) {
                    log.warn("Closing association failed!", (Throwable)exception);
                }
            }
        }
    }

    public synchronized void setPatientLevelQuery(boolean bl) {
        if (this.patientLevelQueryOnly != bl) {
            if (this.isConnected()) {
                try {
                    this.close();
                }
                catch (Exception exception) {
                    log.warn("Closing association failed.", (Throwable)exception);
                }
            }
            this.patientLevelQueryOnly = bl;
            if (this.patientLevelQueryOnly) {
                this.initTransferCapabilities(new String[]{"1.2.840.10008.5.1.4.1.2.1.1"}, this.originalExtInfo);
            } else {
                this.initTransferCapabilities(this.originalQueryClassUIDs, this.originalExtInfo);
            }
        }
    }

    private final void fixDCM4CHENegotiatedTransferCapability(Association association, String string) {
        block6: {
            if (this.getExtInfoBoolean(string, 2)) {
                try {
                    String string2 = association.getAAssociateAC().getImplVersionName();
                    if (string2 == null || !string2.startsWith("dcm4che-")) break block6;
                    try {
                        String string3 = string2.substring(string2.indexOf("dcm4che-") + 8);
                        String[] stringArray = Pattern.DOT.split(string3.trim());
                        if (stringArray.length >= 3 && Integer.valueOf(stringArray[0]) <= 1 && Integer.valueOf(stringArray[1]) <= 4 && Integer.valueOf(stringArray[2]) <= 28) {
                            ExtendedNegotiation extendedNegotiation = this.association.getAAssociateAC().getExtNegotiationFor(string);
                            ExtendedNegotiation extendedNegotiation2 = new ExtendedNegotiation(extendedNegotiation.getSOPClassUID(), DicomCompositeCFindSCU.disableFuzzyMatching(extendedNegotiation.getInformation()));
                            this.association.getAAssociateAC().addExtendedNegotiation(extendedNegotiation2);
                        }
                    }
                    catch (Exception exception) {
                        log.error("Could not detect dcm4chee version,using fuzzy logic yes(enabled)", (Throwable)exception);
                    }
                }
                catch (Exception exception) {
                    log.warn("Applying fix to correct 'semantic PN matching flag' in extended-negotiation of dcm4chee-based source failed!", (Throwable)exception);
                }
            }
        }
    }

    private static byte[] disableFuzzyMatching(byte[] byArray) {
        byArray[2] = 0;
        return byArray;
    }

    public static class CFindTransferCapabilityProvider
    implements ITransferCapabilityProvider {
        private static final List<TransferCapability> tcs = new ArrayList<TransferCapability>(DicomConfigurationFactory.getConfiguration().getQRCFindTransferCapabilities().values());
        private static final List<ExtendedNegotiation> extNegs = new ArrayList<ExtendedNegotiation>(DicomConfigurationFactory.getConfiguration().getQRExtendedNegotiation().values());

        @Override
        public List<TransferCapability> getTransferCapabilities() {
            return tcs;
        }

        @Override
        public List<ExtendedNegotiation> getExtendedNegotiation() {
            return extNegs;
        }
    }
}

