/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.data.dicom.comm;

import com.agfa.pacs.data.dicom.DicomException;
import com.agfa.pacs.data.dicom.comm.DicomSCU;
import com.agfa.pacs.data.dicom.config.DicomConfigurationFactory;
import com.agfa.pacs.data.shared.dicom.IDicomNode;
import com.agfa.pacs.logging.ALogger;
import java.util.Set;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.net.DimseRSP;

public class DicomNServiceSCU
extends DicomSCU {
    private static final ALogger log = ALogger.getLogger(DicomNServiceSCU.class);

    public DicomNServiceSCU(IDicomNode iDicomNode) {
        super(iDicomNode);
    }

    public void nSet(String string, String string2, String string3, Attributes attributes) throws DicomException {
        try {
            Set set;
            if (string == null) {
                string = string2;
            }
            if ((set = this.association.getTransferSyntaxesFor(string)) == null || set.isEmpty()) {
                throw new Exception("SOP Class " + string + " not supported");
            }
            String string4 = (String)set.iterator().next();
            DimseRSP dimseRSP = this.association.nset(string, string2, string3, attributes, string4);
            if (dimseRSP.next()) {
                Attributes attributes2 = dimseRSP.getCommand();
                this.handleStatus(attributes2, true);
            }
        }
        catch (Exception exception) {
            log.error("Dicom Set:", (Throwable)exception);
            throw new DicomException(exception);
        }
    }

    public void nDelete(String string, String string2, String string3) throws DicomException {
        try {
            DimseRSP dimseRSP;
            if (string == null) {
                string = string2;
            }
            if ((dimseRSP = this.association.ndelete(string, string2, string3)).next()) {
                Attributes attributes = dimseRSP.getCommand();
                this.handleStatus(attributes, true);
            }
        }
        catch (Exception exception) {
            log.error("Dicom Delete:", (Throwable)exception);
            throw new DicomException(exception);
        }
    }

    public Attributes nCreate(String string, String string2, String string3, Attributes attributes) throws DicomException {
        return this.nCreate(string, string2, string3, attributes, false);
    }

    public Attributes nCreate(String string, String string2, String string3, Attributes attributes, boolean bl) throws DicomException {
        try {
            String string4;
            DimseRSP dimseRSP;
            Set set;
            if (string == null) {
                string = string2;
            }
            if ((set = this.association.getTransferSyntaxesFor(string)) == null || set.isEmpty()) {
                throw new Exception("SOP Class " + string + " not supported");
            }
            if (!bl) {
                DicomConfigurationFactory.getConfiguration().checkPutCharacterSet(attributes);
            }
            if ((dimseRSP = this.association.ncreate(string, string2, string3, attributes, string4 = (String)set.iterator().next())).next()) {
                Attributes attributes2 = dimseRSP.getCommand();
                this.handleStatus(attributes2, true);
                return dimseRSP.getDataset();
            }
            return null;
        }
        catch (Exception exception) {
            log.error("Dicom Create:", (Throwable)exception);
            throw new DicomException(exception);
        }
    }

    public Attributes nAction(String string, String string2, String string3, int n, Attributes attributes) throws DicomException {
        try {
            Set set;
            if (string == null) {
                string = string2;
            }
            if ((set = this.association.getTransferSyntaxesFor(string)) == null || set.isEmpty()) {
                throw new Exception("SOP Class " + string + " not supported");
            }
            String string4 = (String)set.iterator().next();
            DimseRSP dimseRSP = this.association.naction(string, string2, string3, n, attributes, string4);
            if (dimseRSP.next()) {
                Attributes attributes2 = dimseRSP.getCommand();
                this.handleStatus(attributes2, true);
                return dimseRSP.getDataset();
            }
            return null;
        }
        catch (Exception exception) {
            log.error("Dicom Action:", (Throwable)exception);
            throw new DicomException(exception);
        }
    }

    public Attributes nGet(String string, String string2, String string3) throws DicomException {
        try {
            Set set = this.association.getTransferSyntaxesFor(string);
            if (set == null || set.isEmpty()) {
                throw new Exception("SOP Class " + string + " not supported");
            }
            DimseRSP dimseRSP = this.association.nget(string, string2, string3, null);
            if (dimseRSP.next()) {
                Attributes attributes = dimseRSP.getCommand();
                this.handleStatus(attributes, true);
                return dimseRSP.getDataset();
            }
            return null;
        }
        catch (Exception exception) {
            log.error("Dicom Get:", (Throwable)exception);
            throw new DicomException(exception);
        }
    }

    public Attributes nGet(String string, String string2) throws DicomException {
        try {
            Set set = this.association.getTransferSyntaxesFor(string);
            if (set == null || set.isEmpty()) {
                throw new Exception("SOP Class " + string + " not supported");
            }
            DimseRSP dimseRSP = this.association.nget(string, string2, null);
            if (dimseRSP.next()) {
                Attributes attributes = dimseRSP.getCommand();
                this.handleStatus(attributes, true);
                return dimseRSP.getDataset();
            }
            return null;
        }
        catch (Exception exception) {
            log.error("Dicom Get2:", (Throwable)exception);
            throw new DicomException(exception);
        }
    }
}

