/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.data.dicom.comm;

import com.agfa.pacs.data.dicom.DicomException;
import com.agfa.pacs.data.dicom.ISCU;
import com.agfa.pacs.data.dicom.comm.DicomSCUExceptionHandler;
import com.agfa.pacs.data.dicom.device.DicomDeviceFactory;
import com.agfa.pacs.data.dicom.device.config.DicomDeviceConfigurationFactory;
import com.agfa.pacs.data.dicom.transfercapability.ITransferCapabilityProvider;
import com.agfa.pacs.data.shared.NodeProperty;
import com.agfa.pacs.data.shared.dicom.IDicomNode;
import com.agfa.pacs.data.shared.dicom.UIDMap;
import com.agfa.pacs.logging.ALogger;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.WeakHashMap;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.net.ApplicationEntity;
import org.dcm4che3.net.Association;
import org.dcm4che3.net.Connection;
import org.dcm4che3.net.TransferCapability;
import org.dcm4che3.net.pdu.AAssociateRQ;
import org.dcm4che3.net.pdu.ExtendedNegotiation;
import org.dcm4che3.net.pdu.PresentationContext;

public class DicomSCU
implements ISCU {
    public static final String[] CIPHER_SUITES = new String[]{"SSL_RSA_WITH_NULL_SHA", "TLS_RSA_WITH_AES_128_CBC_SHA"};
    private static final ALogger log = ALogger.getLogger(DicomSCU.class);
    private String host;
    private int port;
    private String calledAET;
    private String callingAET;
    private boolean isSecure;
    private boolean usesAuthentication;
    protected Association association;
    protected ApplicationEntity localAE;
    protected List<TransferCapability> transferCapabilities;
    private List<ExtendedNegotiation> extNegotiations;
    private boolean noExtendedNegotation;
    private int lastStatus;
    private static DicomSCUExceptionHandler exceptionHandler;
    private static WeakHashMap<Association, Object> openAssociations;

    static {
        openAssociations = new WeakHashMap(32);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void closeAllAssociations() {
        Class<DicomSCU> clazz = DicomSCU.class;
        synchronized (DicomSCU.class) {
            for (Association association : openAssociations.keySet()) {
                try {
                    if (!association.isReadyForDataTransfer()) continue;
                    association.release();
                }
                catch (IOException iOException) {
                    log.warn("Could not close connection", (Throwable)iOException);
                }
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    public DicomSCU(IDicomNode iDicomNode, boolean bl) {
        this.localAE = DicomDeviceFactory.getInstance().getDicomDevice().getAE(iDicomNode.getCallingAET());
        this.transferCapabilities = new ArrayList<TransferCapability>(32);
        this.extNegotiations = new ArrayList<ExtendedNegotiation>(32);
        this.host = iDicomNode.getHost();
        this.port = iDicomNode.getPort();
        this.usesAuthentication = iDicomNode.isEnabled(NodeProperty.AuthenticationSupported);
        this.calledAET = iDicomNode.getCalledAET();
        this.callingAET = this.localAE.getAETitle();
        this.isSecure = iDicomNode.isEnabled(NodeProperty.Secure);
        this.noExtendedNegotation = bl;
        this.addTransferCapability("1.2.840.10008.1.1", "1.2.840.10008.1.2");
    }

    DicomSCU(IDicomNode iDicomNode) {
        this(iDicomNode, false);
    }

    private void addTransferCapability(String string, String string2) {
        this.addTransferCapability(string, new String[]{string2}, null);
    }

    protected void addTransferCapability(String string, String[] stringArray, byte[] byArray) {
        TransferCapability transferCapability = new TransferCapability(string, string, TransferCapability.Role.SCP, stringArray);
        if (!this.noExtendedNegotation && byArray != null) {
            this.extNegotiations.add(new ExtendedNegotiation(string, byArray));
        }
        this.transferCapabilities.add(transferCapability);
    }

    protected void addTransferCapability(String string, Set<String> set) {
        this.addTransferCapability(string, set.toArray(new String[set.size()]), null);
    }

    protected void addTransferCapabilities(UIDMap uIDMap) {
        for (String string : uIDMap.getClassUIDs()) {
            this.addTransferCapability(string, uIDMap.getTransferSyntaxUIDs(string));
        }
    }

    @Override
    public UIDMap getSupportedUIDs() throws DicomException {
        try {
            UIDMap uIDMap = new UIDMap();
            for (TransferCapability transferCapability : this.transferCapabilities) {
                String string = transferCapability.getSopClass();
                Set set = this.association.getTransferSyntaxesFor(string);
                if (set == null || set.isEmpty()) continue;
                uIDMap.addTransferSyntaxUIDs(string, (Collection)set);
            }
            return uIDMap;
        }
        catch (Exception exception) {
            throw new DicomException(exception);
        }
    }

    public String getRemoteHost() {
        return this.host;
    }

    public int getRemotePort() {
        return this.port;
    }

    public boolean isExtendedNegotiationEnabled() {
        return !this.noExtendedNegotation;
    }

    private AAssociateRQ createRequest() {
        AAssociateRQ aAssociateRQ = new AAssociateRQ();
        aAssociateRQ.setCalledAET(this.calledAET.trim());
        for (TransferCapability transferCapability : this.transferCapabilities) {
            String[] stringArray = transferCapability.getTransferSyntaxes();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String string = stringArray[n2];
                aAssociateRQ.addPresentationContext(new PresentationContext(aAssociateRQ.getNumberOfPresentationContexts() * 2 + 1, transferCapability.getSopClass(), new String[]{string}));
                ++n2;
            }
        }
        if (aAssociateRQ.getNumberOfPresentationContexts() > 128) {
            throw new IllegalArgumentException("Too many Presentation Contextes");
        }
        for (ExtendedNegotiation extendedNegotiation : this.getExtendedNegotiations()) {
            aAssociateRQ.addExtendedNegotiation(extendedNegotiation);
        }
        if (this.isUsingAuthentication()) {
            aAssociateRQ.setUserIdentityRQ(DicomDeviceConfigurationFactory.getConfiguration().getUserIdentity());
        }
        return aAssociateRQ;
    }

    protected List<ExtendedNegotiation> getExtendedNegotiations() {
        return this.extNegotiations;
    }

    @Override
    public synchronized void connect() throws DicomException {
        this.connect(new Connection());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void connect(Connection connection) throws DicomException {
        if (connection == null) {
            connection = new Connection();
        }
        try {
            InetAddress.getByName(this.host);
        }
        catch (UnknownHostException unknownHostException) {
            throw new IllegalStateException();
        }
        connection.setHostname(this.host);
        connection.setPort(this.port);
        if (this.isSecure) {
            connection.setTlsCipherSuites(CIPHER_SUITES);
        }
        if (this.localAE == null) {
            throw new DicomException("No local application entity available for title [" + this.callingAET + "]");
        }
        try {
            Connection connection2 = this.getLocalConnection();
            this.association = this.localAE.connect(connection2, connection, this.createRequest());
            Class<DicomSCU> clazz = DicomSCU.class;
            synchronized (DicomSCU.class) {
                openAssociations.put(this.association, null);
                // ** MonitorExit[var3_4] (shouldn't be in output)
                log.info("Association initiated between " + this.association.getLocalAET() + " and " + this.association.getRemoteAET() + " (" + this.host + ":" + this.port + ")");
            }
        }
        catch (Exception exception) {
            if (exceptionHandler != null) {
                exceptionHandler.handleException(this, exception);
            }
            throw new DicomException("Association could not be initiated between " + this.localAE.getAETitle() + " and " + this.calledAET + " (" + this.host + ":" + this.port + ")", exception);
        }
    }

    private Connection getLocalConnection() {
        if (!this.isSecure) {
            return DicomDeviceConfigurationFactory.getConfiguration().getFirstLocalConnection();
        }
        List<Connection> list = DicomDeviceConfigurationFactory.getConfiguration().getLocalConnections();
        for (Connection connection : list) {
            if (!connection.isTls()) continue;
            return connection;
        }
        throw new IllegalStateException("Secure connection not found");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void close() throws DicomException {
        if (this.association != null) {
            try {
                Class<DicomSCU> clazz = DicomSCU.class;
                synchronized (DicomSCU.class) {
                    openAssociations.remove(this.association);
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    if (this.association.isReadyForDataTransfer()) {
                        log.info("Association released between " + this.association.getLocalAET() + " and " + this.association.getRemoteAET() + " (" + this.host + ":" + this.port + ")");
                        this.association.release();
                    }
                    this.association = null;
                }
            }
            catch (Exception exception) {
                log.error("close error", (Throwable)exception);
            }
        }
    }

    @Override
    public synchronized boolean isConnected() {
        if (this.association == null) {
            return false;
        }
        return this.association.isReadyForDataTransfer();
    }

    @Override
    public synchronized void echo() throws DicomException {
        try {
            this.association.cecho();
        }
        catch (Exception exception) {
            throw new DicomException(exception);
        }
    }

    public static synchronized void setExceptionHandler(DicomSCUExceptionHandler dicomSCUExceptionHandler) {
        exceptionHandler = dicomSCUExceptionHandler;
    }

    public String getCalledAET() {
        return this.calledAET;
    }

    public String getCallingAET() {
        return this.callingAET;
    }

    private boolean isUsingAuthentication() {
        return this.usesAuthentication;
    }

    public static void echo(IDicomNode iDicomNode) throws DicomException {
        try (DicomSCU dicomSCU = null;){
            try {
                dicomSCU = new DicomSCU(iDicomNode);
                dicomSCU.connect();
                dicomSCU.echo();
            }
            catch (IllegalStateException illegalStateException) {
                throw new DicomException("Unknown host");
            }
        }
    }

    public int getLastStatus() {
        return this.lastStatus;
    }

    protected void handleStatus(Attributes attributes, boolean bl) throws DicomException {
        this.lastStatus = attributes.getInt(2304, 0);
        switch (this.lastStatus) {
            case 261: {
                log.error("Status: " + Integer.toHexString(this.lastStatus));
                log.error("FAILURE: No such attribute");
                throw new DicomException(this.lastStatus, "FAILURE: No such attribute");
            }
            case 262: {
                log.error("Status: " + Integer.toHexString(this.lastStatus));
                log.error("FAILURE: Invalid attribute value");
                throw new DicomException(this.lastStatus, "FAILURE: Invalid attribute value");
            }
            case 263: {
                log.warn("Status: " + Integer.toHexString(this.lastStatus));
                log.warn("WARN: Attribute list error");
                log.warn("Affected SOP Instance UID: " + attributes.getString(4096));
                break;
            }
            case 272: {
                log.error("Status: " + Integer.toHexString(this.lastStatus));
                log.error("FAILURE: Processing failure");
                log.error("Error Comment: " + attributes.getString(2306));
                log.error("Affected SOP Instance UID: " + attributes.getString(4096));
                log.error("Error ID: " + attributes.getString(2307));
                throw new DicomException(this.lastStatus, "FAILURE: Processing failure");
            }
            case 273: {
                log.error("Status: " + Integer.toHexString(this.lastStatus));
                log.error("FAILURE: Duplicate SOP instance");
                log.error("Affected SOP Instance UID: " + attributes.getString(4096));
                throw new DicomException(this.lastStatus, "FAILURE: Duplicate SOP instance");
            }
            case 274: {
                log.error("Status: " + Integer.toHexString(this.lastStatus));
                log.error("FAILURE: No such object instance");
                log.error("Affected SOP Instance UID: " + attributes.getString(4096));
                log.error("Event Type ID: " + attributes.getString(4098));
                throw new DicomException(this.lastStatus, "FAILURE: No such object instance");
            }
            case 275: {
                log.error("Status: " + Integer.toHexString(this.lastStatus));
                log.error("FAILURE: No such event type");
                log.error("Affected SOP Class UID: " + attributes.getString(2));
                log.error("Event Type ID: " + attributes.getString(4098));
                throw new DicomException(this.lastStatus, "FAILURE: No such event type");
            }
            case 276: {
                log.error("Status: " + Integer.toHexString(this.lastStatus));
                log.error("FAILURE: No such argument");
                log.error("Affected SOP Class UID: " + attributes.getString(2));
                log.error("Event Type ID: " + attributes.getString(4098));
                log.error("Action Type ID: " + attributes.getString(4104));
                throw new DicomException(this.lastStatus, "FAILURE: No such argument");
            }
            case 277: {
                log.error("Status: " + Integer.toHexString(this.lastStatus));
                log.error("FAILURE: Invalid argument value");
                log.error("Affected SOP Class UID: " + attributes.getString(2));
                log.error("Affected SOP Instance UID: " + attributes.getString(4096));
                log.error("Event Type ID: " + attributes.getString(4098));
                log.error("Action Type ID: " + attributes.getString(4104));
                throw new DicomException(this.lastStatus, "FAILURE: Invalid argument value");
            }
            case 278: {
                log.warn("Status: " + Integer.toHexString(this.lastStatus));
                log.warn("WARN: Attribute Value out of range");
                break;
            }
            case 279: {
                log.error("Status: " + Integer.toHexString(this.lastStatus));
                log.error("FAILURE: Invalid object instance");
                log.error("Affected SOP Instance UID: " + attributes.getString(4096));
                throw new DicomException(this.lastStatus, "FAILURE: Invalid object instance");
            }
            case 280: {
                log.error("Status: " + Integer.toHexString(this.lastStatus));
                log.error("FAILURE: No such SOP class");
                log.error("Affected SOP Class UID: " + attributes.getString(2));
                throw new DicomException(this.lastStatus, "FAILURE: No such SOP class");
            }
            case 281: {
                log.error("Status: " + Integer.toHexString(this.lastStatus));
                log.error("FAILURE: Class-instance conflict");
                log.error("Error Comment: " + attributes.getString(2306));
                log.error("Requested SOP Instance UID: " + attributes.getString(4097));
                throw new DicomException(this.lastStatus, "FAILURE: Class-instance conflict");
            }
            case 288: {
                log.error("Status: " + Integer.toHexString(this.lastStatus));
                log.error("FAILURE: Missing attribute");
                throw new DicomException(this.lastStatus, "FAILURE: Missing attribute");
            }
            case 289: {
                log.error("Status: " + Integer.toHexString(this.lastStatus));
                log.error("FAILURE: Missing attribute value");
                throw new DicomException(this.lastStatus, "FAILURE: Missing attribute value");
            }
            case 290: {
                log.error("Status: " + Integer.toHexString(this.lastStatus));
                log.error("FAILURE: Refused: SOP class not supported");
                log.error("Error Comment: " + attributes.getString(2306));
                throw new DicomException(this.lastStatus, "FAILURE: Refused: SOP class not supported");
            }
            case 291: {
                log.error("Status: " + Integer.toHexString(this.lastStatus));
                log.error("FAILURE: No such action type");
                log.error("Affected SOP Class UID: " + attributes.getString(2));
                log.error("Action Type ID: " + attributes.getString(4104));
                throw new DicomException(this.lastStatus, "FAILURE: No such action type");
            }
            case 528: {
                log.error("Status: " + Integer.toHexString(this.lastStatus));
                log.error("FAILURE: Duplicate invocation");
                throw new DicomException(this.lastStatus, "FAILURE: Duplicate invocation");
            }
            case 529: {
                log.error("Status: " + Integer.toHexString(this.lastStatus));
                log.error("FAILURE: Unrecognized operation");
                throw new DicomException(this.lastStatus, "FAILURE: Unrecognized operation");
            }
            case 530: {
                log.error("Status: " + Integer.toHexString(this.lastStatus));
                log.error("FAILURE: Mistyped argument");
                throw new DicomException(this.lastStatus, "FAILURE: Mistyped argument");
            }
            case 531: {
                log.error("Status: " + Integer.toHexString(this.lastStatus));
                log.error("FAILURE: Resource limmitation");
                throw new DicomException(this.lastStatus, "FAILURE: Resource limmitation");
            }
        }
    }

    protected boolean isPending(Attributes attributes) {
        return (attributes.getInt(2304, 0) & 0xFF00) == 65280;
    }

    protected boolean getExtInfoBoolean(String string, int n) {
        ExtendedNegotiation extendedNegotiation = this.association.getAAssociateAC().getExtNegotiationFor(string);
        return extendedNegotiation != null && extendedNegotiation.getInformation().length > n && extendedNegotiation.getInformation()[n] != 0;
    }

    public static class VerificationSCUTransferCapabilityProvider
    implements ITransferCapabilityProvider {
        @Override
        public List<TransferCapability> getTransferCapabilities() {
            ArrayList<TransferCapability> arrayList = new ArrayList<TransferCapability>();
            arrayList.add(new TransferCapability("1.2.840.10008.1.1", "1.2.840.10008.1.1", TransferCapability.Role.SCU, new String[]{"1.2.840.10008.1.2"}));
            return arrayList;
        }

        @Override
        public List<ExtendedNegotiation> getExtendedNegotiation() {
            return Collections.emptyList();
        }
    }
}

