/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.data.dicom.config;

import com.agfa.pacs.config.IConfigurationList;
import com.agfa.pacs.config.IConfigurationProvider;
import com.agfa.pacs.tools.Pattern;
import java.util.HashMap;
import java.util.Map;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.VR;
import org.dcm4che3.net.TransferCapability;
import org.dcm4che3.net.pdu.ExtendedNegotiation;

public class DicomConfiguration {
    private static final String ROOT = "listtext.dicom";
    private IConfigurationProvider provider;
    private String characterSet = null;

    DicomConfiguration(IConfigurationProvider iConfigurationProvider) {
        this.provider = iConfigurationProvider.getNode(ROOT);
    }

    public Map<String, TransferCapability> getQRCFindTransferCapabilities() {
        HashMap<String, TransferCapability> hashMap = new HashMap<String, TransferCapability>();
        IConfigurationList iConfigurationList = this.provider.getList("qrcfind.uids");
        for (IConfigurationProvider iConfigurationProvider : iConfigurationList) {
            TransferCapability transferCapability = DicomConfiguration.getTransferCapability(iConfigurationProvider, TransferCapability.Role.SCU);
            hashMap.put(transferCapability.getSopClass(), transferCapability);
        }
        return hashMap;
    }

    public Map<String, ExtendedNegotiation> getQRExtendedNegotiation() {
        HashMap<String, ExtendedNegotiation> hashMap = new HashMap<String, ExtendedNegotiation>();
        IConfigurationList iConfigurationList = this.provider.getList("qrcfind.uids");
        for (IConfigurationProvider iConfigurationProvider : iConfigurationList) {
            ExtendedNegotiation extendedNegotiation = DicomConfiguration.getExtendedNegotiation(iConfigurationProvider);
            if (extendedNegotiation == null) continue;
            hashMap.put(extendedNegotiation.getSOPClassUID(), extendedNegotiation);
        }
        return hashMap;
    }

    public void setDefaultCharacterSet(String string) {
        this.characterSet = string;
    }

    private static TransferCapability getTransferCapability(IConfigurationProvider iConfigurationProvider, TransferCapability.Role role) {
        String[] stringArray = Pattern.COMMA.split(iConfigurationProvider.getString("tsuids"));
        return new TransferCapability(null, iConfigurationProvider.getString("uid"), role, stringArray);
    }

    private static ExtendedNegotiation getExtendedNegotiation(IConfigurationProvider iConfigurationProvider) {
        if (iConfigurationProvider.exists("extInfo")) {
            String[] stringArray = Pattern.COMMA.split(iConfigurationProvider.getString("extInfo"));
            byte[] byArray = new byte[stringArray.length];
            int n = 0;
            while (n < byArray.length) {
                byArray[n] = Byte.parseByte(stringArray[n]);
                ++n;
            }
            return new ExtendedNegotiation(iConfigurationProvider.getString("uid"), byArray);
        }
        return null;
    }

    public Attributes createDicomObject() {
        Attributes attributes = new Attributes();
        if (this.characterSet != null) {
            attributes.setString(524293, VR.CS, this.characterSet);
        }
        return attributes;
    }

    public Attributes checkPutCharacterSet(Attributes attributes) {
        if (!attributes.contains(524293) && this.characterSet != null) {
            attributes.setString(524293, VR.CS, this.characterSet);
        }
        return attributes;
    }

    public String getDefaultCharacterSet() {
        return this.characterSet;
    }
}

