/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.data.dicom.device.config;

import com.agfa.pacs.config.ConfigurationProviderFactory;
import com.agfa.pacs.config.IConfigurationChangeListener;
import com.agfa.pacs.config.IConfigurationList;
import com.agfa.pacs.config.IConfigurationProvider;
import com.agfa.pacs.data.dicom.config.DicomConfigurationFactory;
import com.agfa.pacs.data.dicom.device.DicomServiceFactory;
import com.agfa.pacs.data.dicom.device.IDicomService;
import com.agfa.pacs.data.dicom.transfercapability.TransferCapabilityFactory;
import com.agfa.pacs.data.shared.certificate.CertificateFactory;
import com.agfa.pacs.data.shared.certificate.ICertificateProvider;
import com.agfa.pacs.logging.ALogger;
import com.agfa.pacs.login.URLProviderFactory;
import com.agfa.pacs.tools.Pattern;
import java.io.IOException;
import java.net.BindException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.KeyManager;
import org.apache.commons.lang3.StringUtils;
import org.dcm4che3.data.Issuer;
import org.dcm4che3.net.ApplicationEntity;
import org.dcm4che3.net.Connection;
import org.dcm4che3.net.Device;
import org.dcm4che3.net.DimseRQHandler;
import org.dcm4che3.net.TransferCapability;
import org.dcm4che3.net.pdu.UserIdentityRQ;
import org.dcm4che3.net.service.DicomServiceRegistry;

public class DicomDeviceConfiguration {
    private static final String[] CIPHER_SUITES = new String[]{"SSL_RSA_WITH_NULL_SHA", "TLS_RSA_WITH_AES_128_CBC_SHA"};
    private static final ALogger log = ALogger.getLogger(DicomDeviceConfiguration.class);
    private String ROOT = "listtext.dicom.device.config";
    private Device device;
    private IConfigurationProvider config = ConfigurationProviderFactory.getConfig();
    private IConfigurationProvider root = this.config.getNode(this.ROOT);
    private String defaultAET = null;
    private ConfigListener listener = new ConfigListener();
    private DicomServiceRegistry mainRegistry = new DicomServiceRegistry();
    private List<Connection> localConnection = new ArrayList<Connection>(2);
    private DicomAuthentication authenticationType = null;

    public DicomDeviceConfiguration() {
        List<IDicomService> list = DicomServiceFactory.getInstance().getDicomServiceProvider();
        for (IDicomService iDicomService : list) {
            iDicomService.registerIn(this.mainRegistry);
        }
    }

    public synchronized DicomServiceRegistry getRegistry() {
        return this.mainRegistry;
    }

    public synchronized Device getDevice() {
        if (this.device == null) {
            try {
                this.device = this.createDevice();
                ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(1, Integer.MAX_VALUE, 15L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>());
                threadPoolExecutor.allowCoreThreadTimeOut(true);
                this.device.setExecutor((Executor)threadPoolExecutor);
                this.device.setScheduledExecutor(Executors.newSingleThreadScheduledExecutor());
                this.device.setInstalled(true);
                this.device.bindConnections();
            }
            catch (IOException iOException) {
                log.error("Error on activating device", (Throwable)iOException);
                if (iOException instanceof BindException) {
                    throw new IllegalStateException(iOException);
                }
                if (iOException.getCause() instanceof BindException) {
                    throw new IllegalStateException(iOException.getCause());
                }
            }
            catch (GeneralSecurityException generalSecurityException) {
                log.error("Error on activating device", (Throwable)generalSecurityException);
            }
        }
        return this.device;
    }

    public String getDefaultAET() {
        return this.defaultAET;
    }

    public void registerAssociationAcceptorAE(String string) {
        if (StringUtils.isBlank((CharSequence)string)) {
            return;
        }
        List<TransferCapability> list = TransferCapabilityFactory.getInstance().getTransferCapabilities(true, true);
        ApplicationEntity applicationEntity = this.getDevice().getApplicationEntity(string);
        if (applicationEntity == null) {
            applicationEntity = this.createNetworkApplicationEntity(string, true, list);
            applicationEntity.setDimseRQHandler((DimseRQHandler)this.mainRegistry);
        } else if (!applicationEntity.isAssociationAcceptor()) {
            applicationEntity.setAssociationAcceptor(true);
            for (TransferCapability transferCapability : list) {
                applicationEntity.addTransferCapability(transferCapability);
            }
        }
    }

    public ApplicationEntity createNetworkApplicationEntity(String string, boolean bl, List<TransferCapability> list) {
        ApplicationEntity applicationEntity = this.getDevice().getApplicationEntity(string);
        if (applicationEntity != null) {
            return applicationEntity;
        }
        applicationEntity = new ApplicationEntity(string);
        if (list != null) {
            for (TransferCapability transferCapability : list) {
                applicationEntity.addTransferCapability(transferCapability);
            }
        }
        applicationEntity.setAssociationAcceptor(bl);
        applicationEntity.setAssociationInitiator(true);
        for (Connection connection : this.localConnection) {
            applicationEntity.addConnection(connection);
        }
        this.getDevice().addApplicationEntity(applicationEntity);
        log.info("Added new Network Application Entity with:" + string);
        return applicationEntity;
    }

    public List<Connection> getLocalConnections() {
        return this.localConnection;
    }

    public Connection getFirstLocalConnection() {
        return this.localConnection.get(0);
    }

    private Device createDevice() {
        IConfigurationProvider iConfigurationProvider2;
        IConfigurationList iConfigurationList = this.root.getList("NetworkApplicationEntity");
        IConfigurationList iConfigurationList2 = this.root.getList("NetworkConnection");
        Device device = this.createDevice(this.root.getNode("Device"));
        for (IConfigurationProvider iConfigurationProvider2 : iConfigurationList2) {
            Connection connection = this.createNetworkConnection(iConfigurationProvider2, device.isInstalled());
            this.localConnection.add(connection);
            device.addConnection(connection);
        }
        iConfigurationProvider2 = new ArrayList();
        for (Map.Entry entry : iConfigurationList.getChildrenItems().entrySet()) {
            this.createAndRegisterNetworkApplicationEntity((IConfigurationProvider)entry.getValue(), device, (List<ApplicationEntity>)iConfigurationProvider2);
        }
        for (Connection connection : this.localConnection) {
            String string = null;
            try {
                string = InetAddress.getByName(connection.getHostname()).toString();
            }
            catch (UnknownHostException unknownHostException) {
                string = "";
            }
            log.info("NetworkConnection [" + connection.getCommonName() + "] - Host: " + string + " - Port: " + connection.getPort());
        }
        for (ApplicationEntity applicationEntity : iConfigurationProvider2) {
            log.info("ApplicationEntity - AET: " + applicationEntity.getAETitle() + " - Acceptor: " + applicationEntity.isAssociationAcceptor() + " - Initiator: " + applicationEntity.isAssociationInitiator());
        }
        log.info("--- Device --- (end)");
        return device;
    }

    private Device createDevice(IConfigurationProvider iConfigurationProvider) {
        Device device = new Device(iConfigurationProvider.getString("DeviceName"));
        String string = this.getOptional(iConfigurationProvider, "CharacterSet");
        log.info("Computer's default character set:" + Charset.defaultCharset().displayName());
        if (string == null && Charset.defaultCharset().displayName().equals("windows-1252")) {
            string = "ISO_IR 100";
        }
        DicomConfigurationFactory.getConfiguration().setDefaultCharacterSet(string);
        log.info("Setting the input character set to:" + string);
        iConfigurationProvider.registerConfigurationChangeListener("CharacterSet", (IConfigurationChangeListener)this.listener);
        try {
            device.setInstalled(iConfigurationProvider.getBoolean("Installed"));
        }
        catch (Exception exception) {
            log.error("Could not install device", (Throwable)exception);
        }
        device.setDescription(this.getOptional(iConfigurationProvider, "Description"));
        device.setManufacturer(this.getOptional(iConfigurationProvider, "Manufacturer"));
        device.setManufacturerModelName(this.getOptional(iConfigurationProvider, "ManufacturerModelName"));
        device.setSoftwareVersions(this.getOptionalStrings(iConfigurationProvider, "SoftwareVersion"));
        device.setStationName(this.getOptional(iConfigurationProvider, "StationName"));
        device.setDeviceSerialNumber(this.getOptional(iConfigurationProvider, "DeviceSerialNumber"));
        device.setPrimaryDeviceTypes(this.getOptionalStrings(iConfigurationProvider, "PrimaryDeviceType"));
        device.setInstitutionNames(this.getOptionalStrings(iConfigurationProvider, "InstitutionName"));
        device.setInstitutionAddresses(this.getOptionalStrings(iConfigurationProvider, "InstitutionAddress"));
        device.setInstitutionalDepartmentNames(this.getOptionalStrings(iConfigurationProvider, "InstitutionalDepartmentName"));
        String string2 = this.getOptional(iConfigurationProvider, "IssuerOfPatientID");
        if (string2 != null) {
            device.setIssuerOfPatientID(new Issuer(string2));
        }
        try {
            ICertificateProvider iCertificateProvider = CertificateFactory.getProvider();
            if (iCertificateProvider != null) {
                char[] cArray;
                device.setTrustManager(iCertificateProvider.getTrustManager());
                KeyManager keyManager = device.getKeyManager();
                if (keyManager != null) {
                    device.setKeyManager(keyManager);
                }
                if ((cArray = iCertificateProvider.getKeyPairPassword()) != null) {
                    device.setKeyStoreKeyPin(new String(cArray));
                }
            }
        }
        catch (Exception exception) {
            log.error("Inititialization of DICOM TLS failed", (Throwable)exception);
        }
        return device;
    }

    private void createAndRegisterNetworkApplicationEntity(IConfigurationProvider iConfigurationProvider, Device device, List<ApplicationEntity> list) {
        ApplicationEntity applicationEntity = this.createNetworkApplicationEntity(iConfigurationProvider);
        device.addApplicationEntity(applicationEntity);
        applicationEntity.setDimseRQHandler((DimseRQHandler)this.mainRegistry);
        list.add(applicationEntity);
    }

    private ApplicationEntity createNetworkApplicationEntity(IConfigurationProvider iConfigurationProvider) {
        Object object;
        String[] stringArray;
        ApplicationEntity applicationEntity = new ApplicationEntity(iConfigurationProvider.getString("AETitle"));
        applicationEntity.setDescription(this.getOptional(iConfigurationProvider, "Description"));
        applicationEntity.setAssociationAcceptor(iConfigurationProvider.getBoolean("AssociationAcceptor"));
        applicationEntity.setAssociationInitiator(iConfigurationProvider.getBoolean("AssociationInitiator"));
        applicationEntity.setSupportedCharacterSets(this.getOptionalStrings(iConfigurationProvider, "SupportedCharacterSet"));
        applicationEntity.setAeInstalled(iConfigurationProvider.exists("Installed") ? Boolean.valueOf(iConfigurationProvider.getBoolean("Installed")) : Boolean.TRUE);
        String[] stringArray2 = stringArray = this.getMandatoryStrings(iConfigurationProvider, "NetworkConnectionReference");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            object = stringArray2[n2];
            for (Connection connection : this.localConnection) {
                if (!((String)object).equals(connection.getCommonName())) continue;
                applicationEntity.addConnection(connection);
            }
            ++n2;
        }
        object = TransferCapabilityFactory.getInstance().getTransferCapabilities(applicationEntity.isAssociationInitiator(), applicationEntity.isAssociationAcceptor());
        Iterator iterator = object.iterator();
        while (iterator.hasNext()) {
            TransferCapability transferCapability = (TransferCapability)iterator.next();
            applicationEntity.addTransferCapability(transferCapability);
        }
        if (this.root.exists("UserIdentityNegotiation")) {
            String string = this.root.getString("UserIdentityNegotiation");
            try {
                this.authenticationType = DicomAuthentication.valueOf(string);
            }
            catch (Exception exception) {
                log.warn("Could not parse authentication", (Throwable)exception);
            }
        }
        if (iConfigurationProvider.exists("isDefault") && iConfigurationProvider.getBoolean("isDefault")) {
            this.defaultAET = applicationEntity.getAETitle();
        }
        if (this.defaultAET == null) {
            this.defaultAET = applicationEntity.getAETitle();
        }
        return applicationEntity;
    }

    private Connection createNetworkConnection(IConfigurationProvider iConfigurationProvider, boolean bl) {
        Connection connection = new Connection();
        connection.setCommonName(iConfigurationProvider.getString("CommonName"));
        connection.setHostname(iConfigurationProvider.exists("Hostname") ? iConfigurationProvider.getString("Hostname") : "0.0.0.0");
        connection.setTlsCipherSuites(this.getOptionalStrings(iConfigurationProvider, "TLSCipherSuite"));
        try {
            connection.setConnectionInstalled(iConfigurationProvider.exists("Installed") ? Boolean.valueOf(iConfigurationProvider.getBoolean("Installed")) : Boolean.valueOf(bl));
        }
        catch (Exception exception) {
            log.error("Installing Connection failed", (Throwable)exception);
        }
        if (iConfigurationProvider.exists("Port")) {
            connection.setPort((int)iConfigurationProvider.getLong("Port"));
        }
        if (iConfigurationProvider.exists("Hostname")) {
            connection.setHostname(iConfigurationProvider.getString("Hostname"));
        }
        if (iConfigurationProvider.exists("AcceptTimeout")) {
            connection.setAcceptTimeout((int)iConfigurationProvider.getLong("AcceptTimeout"));
        }
        if (iConfigurationProvider.exists("ConnectTimeout")) {
            connection.setConnectTimeout((int)iConfigurationProvider.getLong("ConnectTimeout"));
        }
        if (iConfigurationProvider.exists("IdleTimeout")) {
            connection.setIdleTimeout((int)iConfigurationProvider.getLong("IdleTimeout"));
        }
        if (iConfigurationProvider.exists("ReleaseTimeout")) {
            connection.setReleaseTimeout((int)iConfigurationProvider.getLong("ReleaseTimeout"));
        }
        if (iConfigurationProvider.exists("RequestTimeout")) {
            connection.setRequestTimeout((int)iConfigurationProvider.getLong("RequestTimeout"));
        }
        if (iConfigurationProvider.exists("DimseRspTimeout")) {
            connection.setResponseTimeout((int)iConfigurationProvider.getLong("DimseRspTimeout"));
        }
        if (iConfigurationProvider.exists("RetrieveRspTimeout")) {
            connection.setRetrieveTimeout((int)iConfigurationProvider.getLong("RetrieveRspTimeout"));
        }
        if (iConfigurationProvider.exists("SendBufferSize")) {
            connection.setSendBufferSize((int)iConfigurationProvider.getLong("SendBufferSize"));
        }
        if (iConfigurationProvider.exists("ReceiveBufferSize")) {
            connection.setReceiveBufferSize((int)iConfigurationProvider.getLong("ReceiveBufferSize"));
        }
        if (iConfigurationProvider.exists("SocketCloseDelay")) {
            connection.setSocketCloseDelay((int)iConfigurationProvider.getLong("SocketCloseDelay"));
        }
        if (iConfigurationProvider.exists("TCPNoDelay")) {
            connection.setTcpNoDelay(iConfigurationProvider.getBoolean("TCPNoDelay"));
        }
        if (iConfigurationProvider.exists("Secure") && iConfigurationProvider.getBoolean("Secure")) {
            connection.setTlsCipherSuites(CIPHER_SUITES);
        }
        if (System.getProperty("dicom.port") != null) {
            connection.setPort(Integer.parseInt(System.getProperty("dicom.port")));
            log.info("Dicom port overriden by command line");
        }
        return connection;
    }

    private String getOptional(IConfigurationProvider iConfigurationProvider, String string) {
        if (!iConfigurationProvider.exists(string)) {
            return null;
        }
        return iConfigurationProvider.getString(string);
    }

    private String[] getOptionalStrings(IConfigurationProvider iConfigurationProvider, String string) {
        if (!iConfigurationProvider.exists(string)) {
            return new String[0];
        }
        return Pattern.COMMA.split(iConfigurationProvider.getString(string));
    }

    private String[] getMandatoryStrings(IConfigurationProvider iConfigurationProvider, String string) {
        return Pattern.COMMA.split(iConfigurationProvider.getString(string));
    }

    public UserIdentityRQ getUserIdentity() {
        if (this.authenticationType != null && this.authenticationType != DicomAuthentication.NO) {
            String string = URLProviderFactory.getProvider().getLoginInformation().getUserID();
            if (this.authenticationType == DicomAuthentication.USERPASSWORD) {
                String string2 = URLProviderFactory.getProvider().getLoginInformation().getPassword();
                return new UserIdentityRQ(string, string2.toCharArray());
            }
            return new UserIdentityRQ(string, true);
        }
        return null;
    }

    private class ConfigListener
    implements IConfigurationChangeListener {
        private ConfigListener() {
        }

        public void configurationChanged(String string) {
            if (DicomDeviceConfiguration.this.config.exists("listtext.dicom.device.config.Device.CharacterSet")) {
                DicomConfigurationFactory.getConfiguration().setDefaultCharacterSet(DicomDeviceConfiguration.this.config.getString("listtext.dicom.device.config.Device.CharacterSet"));
            } else {
                DicomConfigurationFactory.getConfiguration().setDefaultCharacterSet(null);
            }
        }
    }

    private static enum DicomAuthentication {
        USERNAME,
        USERPASSWORD,
        NO;

    }
}

