/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.dicomobject.general;

import com.agfa.pacs.data.shared.code.Code;
import com.agfa.pacs.data.shared.data.AbstractDatasetSource;
import com.agfa.pacs.data.shared.data.DatasetAccessor;
import com.agfa.pacs.data.shared.data.DatasetSource;
import java.util.ArrayList;
import java.util.List;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.Sequence;

public class PersonIdentification
extends AbstractDatasetSource {
    private List<Code> personIdentfications;
    private String personsAddress;
    private String[] personsTelephoneNumbers;
    private String institutionName;
    private String institutionAddress;
    private Code institution;

    private PersonIdentification(Attributes attributes) {
        this.personIdentfications = Code.createList((Attributes)attributes, (int)0x401101);
        this.personsAddress = this.getString(attributes, 4198658);
        this.personsTelephoneNumbers = this.getStrings(attributes, 4198659);
        this.institutionName = this.getString(attributes, 524416);
        this.institutionAddress = this.getString(attributes, 524417);
        this.institution = Code.create((Attributes)attributes, (int)524418);
    }

    public PersonIdentification() {
        this.personIdentfications = new ArrayList<Code>();
    }

    public static PersonIdentification create(Attributes attributes) {
        if (attributes == null) {
            return null;
        }
        if (attributes.contains(0x401101)) {
            return new PersonIdentification(attributes);
        }
        return null;
    }

    public static List<PersonIdentification> createList(Attributes attributes, int n) {
        Sequence sequence = attributes.getSequence(n);
        ArrayList<PersonIdentification> arrayList = new ArrayList<PersonIdentification>();
        if (sequence == null) {
            return arrayList;
        }
        int n2 = 0;
        while (n2 < sequence.size()) {
            PersonIdentification personIdentification = PersonIdentification.create((Attributes)sequence.get(n2));
            if (personIdentification != null) {
                arrayList.add(personIdentification);
            }
            ++n2;
        }
        return arrayList;
    }

    public Code getInstitution() {
        return this.institution;
    }

    public String getInstitutionAddress() {
        return this.institutionAddress;
    }

    public String getInstitutionName() {
        return this.institutionName;
    }

    public List<Code> personIdentfications() {
        return this.personIdentfications;
    }

    public String getPersonsAddress() {
        return this.personsAddress;
    }

    public String[] getPersonsTelephoneNumbers() {
        return this.personsTelephoneNumbers;
    }

    public void setInstitution(Code code) {
        this.institution = code;
    }

    public void setInstitutionAddress(String string) {
        this.institutionAddress = string;
    }

    public void setInstitutionName(String string) {
        this.institutionName = string;
    }

    public void setPersonsAddress(String string) {
        this.personsAddress = string;
    }

    public Attributes toDataset() {
        Attributes attributes = new Attributes();
        this.set(this.personIdentfications, attributes, 0x401101, DatasetAccessor.Type.Mandatory);
        this.set(this.personsAddress, attributes, 4198658, DatasetAccessor.Type.Optional);
        this.set(this.personsTelephoneNumbers, attributes, 4198659, DatasetAccessor.Type.Optional);
        this.set(this.institutionName, attributes, 524416, DatasetAccessor.Type.ConditionalMandatory);
        this.set(this.institutionAddress, attributes, 524417, DatasetAccessor.Type.Optional);
        this.set((DatasetSource)this.institution, attributes, 524418, DatasetAccessor.Type.ConditionalMandatory);
        return attributes;
    }
}

