/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.dicomobject.module.curve;

import com.agfa.pacs.data.shared.data.AbstractDatasetSource;
import com.agfa.pacs.data.shared.data.DatasetAccessor;
import com.agfa.pacs.listtext.dicomobject.module.curve.TypeOfData;
import com.agfa.pacs.logging.ALogger;
import java.io.IOException;
import org.dcm4che3.data.Attributes;

public class Curve
extends AbstractDatasetSource {
    private int group;
    private Integer curveDimensions;
    private Integer numberOfPoints;
    private TypeOfData typeOfData;
    private Integer dataValueRepresentation;
    private byte[] curveData;
    private String curveDescription;
    private String[] axisUnits;
    private String[] axisLabels;
    private int[] minimumCoordinateValue;
    private int[] maximumCoordinateValue;
    private String[] curveRange;
    private int[] curveDataDescriptor;
    private int[] coordinateStartValue;
    private int[] coordinateStepValue;
    private String curveLabel;

    public Curve() {
    }

    private Curve(Attributes attributes, int n) {
        int n2 = n << 16;
        this.group = n;
        this.curveDimensions = this.getInteger(attributes, 0x50000005 + n2);
        this.numberOfPoints = this.getInteger(attributes, 0x50000010 + n2);
        this.typeOfData = TypeOfData.get(this.getString(attributes, 0x50000020 + n2));
        this.dataValueRepresentation = this.getInteger(attributes, 1342177539 + n2);
        try {
            this.curveData = attributes.getBytes(0x50003000 + n2);
        }
        catch (IOException iOException) {
            ALogger.getLogger(Curve.class).error("Could not handle Bulk data", (Throwable)iOException);
        }
        this.curveDescription = this.getString(attributes, 0x50000022 + n2);
        this.axisUnits = this.getStrings(attributes, 0x50000030 + n2);
        this.axisLabels = this.getStrings(attributes, 0x50000040 + n2);
        this.minimumCoordinateValue = this.getIntegers(attributes, 1342177540 + n2);
        this.maximumCoordinateValue = this.getIntegers(attributes, 0x50000105 + n2);
        this.curveRange = this.getStrings(attributes, 1342177542 + n2);
        this.curveDataDescriptor = this.getIntegers(attributes, 0x50000110 + n2);
        this.coordinateStartValue = this.getIntegers(attributes, 1342177554 + n2);
        this.coordinateStepValue = this.getIntegers(attributes, 1342177556 + n2);
        this.curveLabel = this.getString(attributes, 0x50002500 + n2);
    }

    public static Curve create(Attributes attributes, int n) {
        int n2 = n << 16;
        if (attributes.contains(0x50003000 + n2)) {
            return new Curve(attributes, n);
        }
        return null;
    }

    public int getGroup() {
        return this.group;
    }

    public void setGroup(int n) {
        this.group = n;
    }

    public Attributes toDataset() {
        Attributes attributes = new Attributes();
        int n = this.group << 16;
        this.set(this.curveDimensions, attributes, 0x50000005 + n, DatasetAccessor.Type.Mandatory);
        this.set(this.numberOfPoints, attributes, 0x50000010 + n, DatasetAccessor.Type.Mandatory);
        this.set(this.typeOfData, attributes, 0x50000020 + n, DatasetAccessor.Type.Mandatory);
        this.set(this.dataValueRepresentation, attributes, 1342177539 + n, DatasetAccessor.Type.Mandatory);
        this.set(this.curveData, attributes, 0x50003000 + n, DatasetAccessor.Type.Mandatory);
        this.set(this.curveDescription, attributes, 0x50000022 + n, DatasetAccessor.Type.Optional);
        this.set(this.axisUnits, attributes, 0x50000030 + n, DatasetAccessor.Type.Optional);
        this.set(this.axisLabels, attributes, 0x50000040 + n, DatasetAccessor.Type.Optional);
        this.set(this.minimumCoordinateValue, attributes, 1342177540 + n, DatasetAccessor.Type.Optional);
        this.set(this.maximumCoordinateValue, attributes, 0x50000105 + n, DatasetAccessor.Type.Optional);
        this.set(this.curveRange, attributes, 1342177542 + n, DatasetAccessor.Type.Optional);
        this.set(this.curveDataDescriptor, attributes, 0x50000110 + n, DatasetAccessor.Type.ConditionalMandatory);
        this.set(this.coordinateStartValue, attributes, 1342177554 + n, DatasetAccessor.Type.ConditionalMandatory);
        this.set(this.coordinateStepValue, attributes, 1342177556 + n, DatasetAccessor.Type.ConditionalMandatory);
        this.set(this.curveLabel, attributes, 0x50002500 + n, DatasetAccessor.Type.Optional);
        return attributes;
    }

    public String[] getAxisLabels() {
        return this.axisLabels;
    }

    public String[] getAxisUnits() {
        return this.axisUnits;
    }

    public int[] getCoordinateStartValue() {
        return this.coordinateStartValue;
    }

    public int[] getCoordinateStepValue() {
        return this.coordinateStepValue;
    }

    public byte[] getCurveData() {
        return this.curveData;
    }

    public int[] getCurveDataDescriptor() {
        return this.curveDataDescriptor;
    }

    public String getCurveDescription() {
        return this.curveDescription;
    }

    public Integer getCurveDimensions() {
        return this.curveDimensions;
    }

    public String getCurveLabel() {
        return this.curveLabel;
    }

    public String[] getCurveRange() {
        return this.curveRange;
    }

    public Integer getDataValueRepresentation() {
        return this.dataValueRepresentation;
    }

    public int[] getMaximumCoordinateValue() {
        return this.maximumCoordinateValue;
    }

    public int[] getMinimumCoordinateValue() {
        return this.minimumCoordinateValue;
    }

    public Integer getNumberOfPoints() {
        return this.numberOfPoints;
    }

    public TypeOfData getTypeOfData() {
        return this.typeOfData;
    }
}

