/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.dicomobject.module.mwl;

import com.agfa.pacs.data.shared.data.AbstractDatasetSource;
import com.agfa.pacs.data.shared.data.DatasetAccessor;
import com.agfa.pacs.data.shared.dicom.DicomEnum;
import com.agfa.pacs.data.shared.dicom.YesNo;
import com.agfa.pacs.listtext.dicomobject.general.PersonIdentification;
import com.agfa.pacs.listtext.dicomobject.general.ReferencedSOP;
import java.util.ArrayList;
import java.util.List;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.Sequence;

public class PerformedSeries
extends AbstractDatasetSource {
    private List<ReferencedSOP> referencedImages;
    private String protocolName;
    private String seriesInstanceUID;
    private String seriesDescription;
    private String retrieveAETitle;
    private List<ReferencedSOP> referencedNonImageCompositeSOPInstances;
    private List<String> performingPhysiciansName;
    private List<String> operatorsName;
    private List<PersonIdentification> operatorsIdentification;
    private List<PersonIdentification> performingPhysicianIdentification;
    private YesNo archiveRequested;

    public PerformedSeries() {
        this.referencedImages = new ArrayList<ReferencedSOP>();
        this.referencedNonImageCompositeSOPInstances = new ArrayList<ReferencedSOP>();
        this.operatorsIdentification = new ArrayList<PersonIdentification>();
        this.performingPhysicianIdentification = new ArrayList<PersonIdentification>();
    }

    private PerformedSeries(Attributes attributes) {
        this.performingPhysiciansName = this.getStringsAsList(attributes, 528464);
        this.performingPhysicianIdentification = PersonIdentification.createList(attributes, 528466);
        this.operatorsName = this.getStringsAsList(attributes, 528496);
        this.operatorsIdentification = PersonIdentification.createList(attributes, 528498);
        this.protocolName = this.getString(attributes, 1577008);
        this.seriesInstanceUID = this.getString(attributes, 0x20000E);
        this.seriesDescription = this.getString(attributes, 528446);
        this.retrieveAETitle = this.getString(attributes, 524372);
        this.referencedImages = ReferencedSOP.createList((Attributes)attributes, (int)528704);
        this.referencedNonImageCompositeSOPInstances = ReferencedSOP.createList((Attributes)attributes, (int)0x400220);
        this.archiveRequested = YesNo.get((String)this.getString(attributes, 4236436));
    }

    public Attributes toDataset() {
        Attributes attributes = new Attributes();
        this.set(this.performingPhysiciansName, attributes, 528464, DatasetAccessor.Type.MandatoryOrEmpty);
        this.set(this.performingPhysicianIdentification, attributes, 528466, DatasetAccessor.Type.Optional);
        this.set(this.operatorsName, attributes, 528496, DatasetAccessor.Type.MandatoryOrEmpty);
        this.set(this.operatorsIdentification, attributes, 528498, DatasetAccessor.Type.Optional);
        this.set(this.protocolName, attributes, 1577008, DatasetAccessor.Type.Mandatory);
        this.set(this.seriesInstanceUID, attributes, 0x20000E, DatasetAccessor.Type.Mandatory);
        this.set(this.seriesDescription, attributes, 528446, DatasetAccessor.Type.MandatoryOrEmpty);
        this.set(this.retrieveAETitle, attributes, 524372, DatasetAccessor.Type.MandatoryOrEmpty);
        this.set(this.referencedImages, attributes, 528704, DatasetAccessor.Type.MandatoryOrEmpty);
        this.set(this.referencedNonImageCompositeSOPInstances, attributes, 0x400220, DatasetAccessor.Type.MandatoryOrEmpty);
        this.set((DicomEnum)this.archiveRequested, attributes, 4236436, DatasetAccessor.Type.Optional);
        return attributes;
    }

    public static PerformedSeries create(Attributes attributes) {
        if (attributes == null) {
            return null;
        }
        return new PerformedSeries(attributes);
    }

    public static List<PerformedSeries> createList(Attributes attributes, int n) {
        ArrayList<PerformedSeries> arrayList = new ArrayList<PerformedSeries>();
        Sequence sequence = attributes.getSequence(n);
        if (sequence == null) {
            return arrayList;
        }
        int n2 = 0;
        while (n2 < sequence.size()) {
            PerformedSeries performedSeries = PerformedSeries.create((Attributes)sequence.get(n2));
            if (performedSeries != null) {
                arrayList.add(performedSeries);
            }
            ++n2;
        }
        return arrayList;
    }

    public List<PersonIdentification> operatorsIdentification() {
        return this.operatorsIdentification;
    }

    public List<String> operatorsName() {
        return this.operatorsName;
    }

    public List<PersonIdentification> performingPhysicianIdentification() {
        return this.performingPhysicianIdentification;
    }

    public List<String> performingPhysiciansName() {
        return this.performingPhysiciansName;
    }

    public String getProtocolName() {
        return this.protocolName;
    }

    public void setProtocolName(String string) {
        this.protocolName = string;
    }

    public List<ReferencedSOP> referencedImages() {
        return this.referencedImages;
    }

    public List<ReferencedSOP> referencedNonImageCompositeSOPInstances() {
        return this.referencedNonImageCompositeSOPInstances;
    }

    public String getRetrieveAETitle() {
        return this.retrieveAETitle;
    }

    public void setRetrieveAETitle(String string) {
        this.retrieveAETitle = string;
    }

    public String getSeriesDescription() {
        return this.seriesDescription;
    }

    public void setSeriesDescription(String string) {
        this.seriesDescription = string;
    }

    public String getSeriesInstanceUID() {
        return this.seriesInstanceUID;
    }

    public void setSeriesInstanceUID(String string) {
        this.seriesInstanceUID = string;
    }

    public YesNo getArchiveRequested() {
        return this.archiveRequested;
    }

    public void setArchiveRequested(YesNo yesNo) {
        this.archiveRequested = yesNo;
    }
}

