/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.dicomobject.module.mwl;

import com.agfa.pacs.data.shared.code.Code;
import com.agfa.pacs.data.shared.data.AbstractDatasetSource;
import com.agfa.pacs.data.shared.data.DatasetAccessor;
import com.agfa.pacs.data.shared.data.DatasetSource;
import com.agfa.pacs.listtext.dicomobject.general.ReferencedSOP;
import com.agfa.pacs.listtext.dicomobject.module.series.Protocol;
import java.util.ArrayList;
import java.util.List;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.Sequence;

public class ScheduledStepAttribute
extends AbstractDatasetSource {
    private String studyInstanceUID;
    private ReferencedSOP referencedStudy;
    private String accessionNumber;
    private String placerOrderNumber;
    private String fillerOrderNumber;
    private String requestedProcedureID;
    private String requestedProcedureDescription;
    private Code requestedProcedureCode;
    private String scheduledProcedureStepID;
    private String scheduledProcedureStepDescription;
    private List<Protocol> scheduledProtocol;

    public ScheduledStepAttribute() {
        this.scheduledProtocol = new ArrayList<Protocol>();
    }

    private ScheduledStepAttribute(Attributes attributes) {
        this.studyInstanceUID = this.getString(attributes, 0x20000D);
        this.referencedStudy = ReferencedSOP.create((Attributes)attributes.getNestedDataset(528656));
        this.accessionNumber = this.getString(attributes, 524368);
        this.placerOrderNumber = this.getString(attributes, 4202518);
        this.fillerOrderNumber = this.getString(attributes, 4202519);
        this.requestedProcedureID = this.getString(attributes, 0x401001);
        this.requestedProcedureDescription = this.getString(attributes, 3280992);
        this.requestedProcedureCode = Code.create((Attributes)attributes, (int)3280996);
        this.scheduledProcedureStepID = this.getString(attributes, 0x400009);
        this.scheduledProcedureStepDescription = this.getString(attributes, 0x400007);
        this.scheduledProtocol = Protocol.createList(attributes, 0x400008);
    }

    public Attributes toDataset() {
        Attributes attributes = new Attributes();
        this.set(this.studyInstanceUID, attributes, 0x20000D, DatasetAccessor.Type.Mandatory);
        this.set((DatasetSource)this.referencedStudy, attributes, 528656, DatasetAccessor.Type.MandatoryOrEmpty);
        this.set(this.accessionNumber, attributes, 524368, DatasetAccessor.Type.MandatoryOrEmpty);
        this.set(this.placerOrderNumber, attributes, 4202518, DatasetAccessor.Type.Optional);
        this.set(this.fillerOrderNumber, attributes, 4202519, DatasetAccessor.Type.Optional);
        this.set(this.requestedProcedureID, attributes, 0x401001, DatasetAccessor.Type.MandatoryOrEmpty);
        this.set(this.requestedProcedureDescription, attributes, 3280992, DatasetAccessor.Type.MandatoryOrEmpty);
        this.set((DatasetSource)this.requestedProcedureCode, attributes, 3280996, DatasetAccessor.Type.Mandatory);
        this.set(this.scheduledProcedureStepID, attributes, 0x400009, DatasetAccessor.Type.MandatoryOrEmpty);
        this.set(this.scheduledProcedureStepDescription, attributes, 0x400007, DatasetAccessor.Type.MandatoryOrEmpty);
        this.set(this.scheduledProtocol, attributes, 0x400008, DatasetAccessor.Type.MandatoryOrEmpty);
        return attributes;
    }

    public static ScheduledStepAttribute create(Attributes attributes) {
        if (attributes == null) {
            return null;
        }
        if (attributes.contains(0x20000D) && attributes.contains(528656)) {
            return new ScheduledStepAttribute(attributes);
        }
        return null;
    }

    public static List<ScheduledStepAttribute> createList(Attributes attributes, int n) {
        ArrayList<ScheduledStepAttribute> arrayList = new ArrayList<ScheduledStepAttribute>();
        Sequence sequence = attributes.getSequence(n);
        if (sequence == null) {
            return arrayList;
        }
        int n2 = 0;
        while (n2 < sequence.size()) {
            ScheduledStepAttribute scheduledStepAttribute = ScheduledStepAttribute.create((Attributes)sequence.get(n2));
            if (scheduledStepAttribute != null) {
                arrayList.add(scheduledStepAttribute);
            }
            ++n2;
        }
        return arrayList;
    }

    public String getAccessionNumber() {
        return this.accessionNumber;
    }

    public void setAccessionNumber(String string) {
        this.accessionNumber = string;
    }

    public String getFillerOrderNumber() {
        return this.fillerOrderNumber;
    }

    public void setFillerOrderNumber(String string) {
        this.fillerOrderNumber = string;
    }

    public String getPlacerOrderNumber() {
        return this.placerOrderNumber;
    }

    public void setPlacerOrderNumber(String string) {
        this.placerOrderNumber = string;
    }

    public ReferencedSOP getReferencedStudy() {
        return this.referencedStudy;
    }

    public void setReferencedStudy(ReferencedSOP referencedSOP) {
        this.referencedStudy = referencedSOP;
    }

    public String getRequestedProcedureDescription() {
        return this.requestedProcedureDescription;
    }

    public void setRequestedProcedureDescription(String string) {
        this.requestedProcedureDescription = string;
    }

    public String getRequestedProcedureID() {
        return this.requestedProcedureID;
    }

    public void setRequestedProcedureID(String string) {
        this.requestedProcedureID = string;
    }

    public String getScheduledProcedureStepDescription() {
        return this.scheduledProcedureStepDescription;
    }

    public void setScheduledProcedureStepDescription(String string) {
        this.scheduledProcedureStepDescription = string;
    }

    public String getScheduledProcedureStepID() {
        return this.scheduledProcedureStepID;
    }

    public void setScheduledProcedureStepID(String string) {
        this.scheduledProcedureStepID = string;
    }

    public List<Protocol> scheduledProtocol() {
        return this.scheduledProtocol;
    }

    public String getStudyInstanceUID() {
        return this.studyInstanceUID;
    }

    public void setStudyInstanceUID(String string) {
        this.studyInstanceUID = string;
    }

    public Code getRequestedProcedureCode() {
        return this.requestedProcedureCode;
    }

    public void setRequestedProcedureCode(Code code) {
        this.requestedProcedureCode = code;
    }
}

