/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.dicomobject.module.print;

import com.agfa.pacs.data.shared.data.DatasetAccessor;
import com.agfa.pacs.data.shared.data.DatasetSource;
import com.agfa.pacs.listtext.dicomobject.general.ReferencedSOP;
import com.agfa.pacs.listtext.dicomobject.module.AbstractModule;
import com.agfa.pacs.listtext.dicomobject.module.image.ImagePixel;
import com.agfa.pacs.listtext.dicomobject.type.print.ConfigurationInformation;
import com.agfa.pacs.listtext.dicomobject.type.print.DecimateCropBehavior;
import com.agfa.pacs.listtext.dicomobject.type.print.MagnificationType;
import com.agfa.pacs.listtext.dicomobject.type.print.Polarity;
import org.dcm4che3.data.Attributes;

public class ImageBoxPresentationModule
extends AbstractModule {
    private Integer imagePosition;
    private Polarity polarity;
    private MagnificationType magnificationType;
    private String smoothingType;
    private ConfigurationInformation configurationInformation;
    private Double requestedImageSize;
    private DecimateCropBehavior requestedDecimateCropBehavior;
    private ImagePixel grayscaleImage;
    private ImagePixel colorImage;
    private Integer minDensity;
    private Integer maxDensity;
    private ReferencedSOP presentationLUT;

    public ImageBoxPresentationModule() {
        super(null);
    }

    @Override
    public boolean isValid() {
        return true;
    }

    @Override
    public boolean containsModule(Attributes attributes) {
        return true;
    }

    @Override
    public void readFrom(Attributes attributes) {
        this.imagePosition = this.getInteger(attributes, 0x20200010);
        this.polarity = Polarity.get(this.getString(attributes, 0x20200020));
        this.magnificationType = MagnificationType.get(this.getString(attributes, 537919584));
        this.smoothingType = this.getString(attributes, 537919616);
        this.configurationInformation = ConfigurationInformation.create(this.getString(attributes, 537919824));
        this.requestedImageSize = this.getDouble(attributes, 0x20200030);
        this.requestedDecimateCropBehavior = DecimateCropBehavior.get(this.getString(attributes, 0x20200040));
        this.grayscaleImage = ImagePixel.create(attributes.getNestedDataset(0x20200110), true);
        this.colorImage = ImagePixel.create(attributes.getNestedDataset(0x20200111), true);
    }

    @Override
    public void writeTo(Attributes attributes) {
        this.set(this.imagePosition, attributes, 0x20200010, DatasetAccessor.Type.Optional);
        this.set(this.polarity, attributes, 0x20200020, DatasetAccessor.Type.Optional);
        this.set(this.magnificationType, attributes, 537919584, DatasetAccessor.Type.Optional);
        this.set(this.smoothingType, attributes, 537919616, DatasetAccessor.Type.Optional);
        this.set(this.configurationInformation, attributes, 537919824, DatasetAccessor.Type.Optional);
        this.set(this.requestedImageSize, attributes, 0x20200030, DatasetAccessor.Type.Optional);
        this.set(this.requestedDecimateCropBehavior, attributes, 0x20200040, DatasetAccessor.Type.Optional);
        this.set(this.grayscaleImage, attributes, 0x20200110, DatasetAccessor.Type.Optional);
        this.set(this.colorImage, attributes, 0x20200111, DatasetAccessor.Type.Optional);
    }

    public void writeToGrayNSet(Attributes attributes) {
        this.set(this.imagePosition, attributes, 0x20200010, DatasetAccessor.Type.Optional);
        this.set(this.polarity, attributes, 0x20200020, DatasetAccessor.Type.Optional);
        this.set(this.magnificationType, attributes, 537919584, DatasetAccessor.Type.Optional);
        this.set(this.smoothingType, attributes, 537919616, DatasetAccessor.Type.Optional);
        this.set(this.configurationInformation, attributes, 537919824, DatasetAccessor.Type.Optional);
        this.set(this.requestedImageSize, attributes, 0x20200030, DatasetAccessor.Type.Optional);
        this.set(this.requestedDecimateCropBehavior, attributes, 0x20200040, DatasetAccessor.Type.Optional);
        this.set(this.grayscaleImage, attributes, 0x20200110, DatasetAccessor.Type.Optional);
        this.set(this.minDensity, attributes, 0x20100120, DatasetAccessor.Type.Optional);
        this.set(this.maxDensity, attributes, 537919792, DatasetAccessor.Type.Optional);
        this.set((DatasetSource)this.presentationLUT, attributes, 0x20500500, DatasetAccessor.Type.Optional);
    }

    public void writeToColorNSet(Attributes attributes) {
        this.set(this.imagePosition, attributes, 0x20200010, DatasetAccessor.Type.Optional);
        this.set(this.polarity, attributes, 0x20200020, DatasetAccessor.Type.Optional);
        this.set(this.magnificationType, attributes, 537919584, DatasetAccessor.Type.Optional);
        this.set(this.smoothingType, attributes, 537919616, DatasetAccessor.Type.Optional);
        this.set(this.requestedImageSize, attributes, 0x20200030, DatasetAccessor.Type.Optional);
        this.set(this.requestedDecimateCropBehavior, attributes, 0x20200040, DatasetAccessor.Type.Optional);
        this.set(this.colorImage, attributes, 0x20200111, DatasetAccessor.Type.Optional);
    }

    public ImagePixel getColorImage() {
        return this.colorImage;
    }

    public void setColorImage(ImagePixel imagePixel) {
        this.colorImage = imagePixel;
    }

    public ConfigurationInformation getConfigurationInformation() {
        return this.configurationInformation;
    }

    public void setConfigurationInformation(ConfigurationInformation configurationInformation) {
        this.configurationInformation = configurationInformation;
    }

    public ImagePixel getGrayscaleImage() {
        return this.grayscaleImage;
    }

    public void setGrayscaleImage(ImagePixel imagePixel) {
        this.grayscaleImage = imagePixel;
    }

    public Integer getImagePosition() {
        return this.imagePosition;
    }

    public void setImagePosition(Integer n) {
        this.imagePosition = n;
    }

    public MagnificationType getMagnificationType() {
        return this.magnificationType;
    }

    public void setMagnificationType(MagnificationType magnificationType) {
        this.magnificationType = magnificationType;
    }

    public Polarity getPolarity() {
        return this.polarity;
    }

    public void setPolarity(Polarity polarity) {
        this.polarity = polarity;
    }

    public DecimateCropBehavior getRequestedDecimateCropBehavior() {
        return this.requestedDecimateCropBehavior;
    }

    public void setRequestedDecimateCropBehavior(DecimateCropBehavior decimateCropBehavior) {
        this.requestedDecimateCropBehavior = decimateCropBehavior;
    }

    public Double getRequestedImageSize() {
        return this.requestedImageSize;
    }

    public void setRequestedImageSize(Double d) {
        this.requestedImageSize = d;
    }

    public String getSmoothingType() {
        return this.smoothingType;
    }

    public void setSmoothingType(String string) {
        this.smoothingType = string;
    }

    public Integer getMaxDensity() {
        return this.maxDensity;
    }

    public void setMaxDensity(Integer n) {
        this.maxDensity = n;
    }

    public Integer getMinDensity() {
        return this.minDensity;
    }

    public void setMinDensity(Integer n) {
        this.minDensity = n;
    }

    public ReferencedSOP getPresentationLUT() {
        return this.presentationLUT;
    }

    public void setPresentationLUT(ReferencedSOP referencedSOP) {
        this.presentationLUT = referencedSOP;
    }
}

