/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.dicomobject.module.print;

import com.agfa.pacs.data.shared.data.AbstractDatasetSource;
import com.agfa.pacs.data.shared.data.DatasetAccessor;
import com.agfa.pacs.listtext.dicomobject.type.print.FilmSizeID;
import com.agfa.pacs.listtext.dicomobject.type.print.MediumType;
import java.util.ArrayList;
import java.util.List;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.Sequence;

public class Media
extends AbstractDatasetSource {
    private Integer itemNumber;
    private MediumType mediumType;
    private FilmSizeID filmSizeID;
    private Integer minDensity;
    private Integer maxDensity;
    private String name;

    public Media(int n, MediumType mediumType, FilmSizeID filmSizeID, Integer n2, Integer n3, String string) {
        this.itemNumber = n;
        this.mediumType = mediumType;
        this.filmSizeID = filmSizeID;
        this.minDensity = n2;
        this.maxDensity = n3;
        this.name = string;
    }

    protected Media(Attributes attributes) {
        this.itemNumber = this.getInteger(attributes, 2097177);
        this.mediumType = MediumType.get(this.getString(attributes, 0x20000030));
        this.filmSizeID = FilmSizeID.get(this.getString(attributes, 537919568));
        this.minDensity = this.getInteger(attributes, 0x20100120);
        this.maxDensity = this.getInteger(attributes, 537919792);
    }

    public static Media create(Attributes attributes) {
        if (attributes == null) {
            return null;
        }
        return new Media(attributes);
    }

    public static List<Media> createList(Attributes attributes, int n) {
        ArrayList<Media> arrayList = new ArrayList<Media>();
        Sequence sequence = attributes.getSequence(n);
        if (sequence == null) {
            return arrayList;
        }
        int n2 = 0;
        while (n2 < sequence.size()) {
            Media media = Media.create((Attributes)sequence.get(n2));
            if (media != null) {
                arrayList.add(media);
            }
            ++n2;
        }
        return arrayList;
    }

    public Attributes toDataset() {
        Attributes attributes = new Attributes();
        this.set(this.itemNumber, attributes, 2097177, DatasetAccessor.Type.Optional);
        this.set(this.mediumType, attributes, 0x20000030, DatasetAccessor.Type.Mandatory);
        this.set(this.filmSizeID, attributes, 537919568, DatasetAccessor.Type.Mandatory);
        this.set(this.minDensity, attributes, 0x20100120, DatasetAccessor.Type.Mandatory);
        this.set(this.maxDensity, attributes, 537919792, DatasetAccessor.Type.Mandatory);
        return attributes;
    }

    public FilmSizeID getFilmSizeID() {
        return this.filmSizeID;
    }

    public void setFilmSizeID(FilmSizeID filmSizeID) {
        this.filmSizeID = filmSizeID;
    }

    public Integer getItemNumber() {
        return this.itemNumber;
    }

    public void setItemNumber(Integer n) {
        this.itemNumber = n;
    }

    public Integer getMaxDensity() {
        return this.maxDensity;
    }

    public void setMaxDensity(Integer n) {
        this.maxDensity = n;
    }

    public MediumType getMediumType() {
        return this.mediumType;
    }

    public void setMediumType(MediumType mediumType) {
        this.mediumType = mediumType;
    }

    public Integer getMinDensity() {
        return this.minDensity;
    }

    public void setMinDensity(Integer n) {
        this.minDensity = n;
    }

    public String toString() {
        if (this.name != null) {
            return this.name;
        }
        return String.valueOf(this.filmSizeID.dicom()) + "-" + this.mediumType.dicom();
    }
}

