/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.dicomobject.module.print;

import com.agfa.pacs.data.shared.data.DatasetAccessor;
import com.agfa.pacs.listtext.dicomobject.module.AbstractModule;
import com.agfa.pacs.listtext.dicomobject.type.print.ExecutionStatusInfo;
import com.agfa.pacs.listtext.dicomobject.type.print.PrinterStatus;
import java.util.Date;
import org.dcm4che3.data.Attributes;

public class PrinterModule
extends AbstractModule {
    private PrinterStatus printerStatus;
    private ExecutionStatusInfo printerStatusInfo;
    private String printerName;
    private String manufacturer;
    private String manufacturerModelName;
    private String deviceSerialNumber;
    private String[] softwareVersions;
    private Date dateOfLastCalibration;
    private Date timeOfLastCalibration;

    public PrinterModule() {
        super(null);
    }

    @Override
    public boolean isValid() {
        return true;
    }

    @Override
    public boolean containsModule(Attributes attributes) {
        return true;
    }

    @Override
    public void readFrom(Attributes attributes) {
        this.printerStatus = PrinterStatus.get(this.getString(attributes, 0x21100010));
        this.printerStatusInfo = ExecutionStatusInfo.get(this.getString(attributes, 0x21100020));
        this.printerName = this.getString(attributes, 554696752);
        this.manufacturer = this.getString(attributes, 524400);
        this.manufacturerModelName = this.getString(attributes, 528528);
        this.deviceSerialNumber = this.getString(attributes, 0x181000);
        this.softwareVersions = this.getStrings(attributes, 1576992);
        this.dateOfLastCalibration = this.getDate(attributes, 1577472);
        this.timeOfLastCalibration = this.getDate(attributes, 1577473);
    }

    @Override
    public void writeTo(Attributes attributes) {
        this.set(this.printerStatus, attributes, 0x21100010, DatasetAccessor.Type.Optional);
        this.set(this.printerStatusInfo, attributes, 0x21100020, DatasetAccessor.Type.Optional);
        this.set(this.printerName, attributes, 554696752, DatasetAccessor.Type.Optional);
        this.set(this.manufacturer, attributes, 524400, DatasetAccessor.Type.Optional);
        this.set(this.manufacturerModelName, attributes, 528528, DatasetAccessor.Type.Optional);
        this.set(this.deviceSerialNumber, attributes, 0x181000, DatasetAccessor.Type.Optional);
        this.set(this.softwareVersions, attributes, 1576992, DatasetAccessor.Type.Optional);
        this.set(this.dateOfLastCalibration, attributes, 1577472, DatasetAccessor.Type.Optional);
        this.set(this.timeOfLastCalibration, attributes, 1577473, DatasetAccessor.Type.Optional);
    }

    public Date getDateOfLastCalibration() {
        return this.dateOfLastCalibration;
    }

    public void setDateOfLastCalibration(Date date) {
        this.dateOfLastCalibration = date;
    }

    public String getDeviceSerialNumber() {
        return this.deviceSerialNumber;
    }

    public void setDeviceSerialNumber(String string) {
        this.deviceSerialNumber = string;
    }

    public String getManufacturer() {
        return this.manufacturer;
    }

    public void setManufacturer(String string) {
        this.manufacturer = string;
    }

    public String getManufacturerModelName() {
        return this.manufacturerModelName;
    }

    public void setManufacturerModelName(String string) {
        this.manufacturerModelName = string;
    }

    public String getPrinterName() {
        return this.printerName;
    }

    public void setPrinterName(String string) {
        this.printerName = string;
    }

    public PrinterStatus getPrinterStatus() {
        return this.printerStatus;
    }

    public void setPrinterStatus(PrinterStatus printerStatus) {
        this.printerStatus = printerStatus;
    }

    public ExecutionStatusInfo getPrinterStatusInfo() {
        return this.printerStatusInfo;
    }

    public void setPrinterStatusInfo(ExecutionStatusInfo executionStatusInfo) {
        this.printerStatusInfo = executionStatusInfo;
    }

    public String[] getSoftwareVersions() {
        return this.softwareVersions;
    }

    public void setSoftwareVersions(String[] stringArray) {
        this.softwareVersions = stringArray;
    }

    public Date getTimeOfLastCalibration() {
        return this.timeOfLastCalibration;
    }

    public void setTimeOfLastCalibration(Date date) {
        this.timeOfLastCalibration = date;
    }
}

