/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.dicomobject.module.ps;

import com.agfa.pacs.data.shared.data.AbstractDatasetSource;
import com.agfa.pacs.data.shared.data.DatasetAccessor;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.Sequence;

public class GraphicLayer
extends AbstractDatasetSource
implements Comparable<GraphicLayer> {
    public static final String DEFAULT_LAYER_NAME = "[Default Layer]";
    private int[] graphicLayerRecommendedDisplayRGBValue;
    private Integer graphicLayerRecommendedDisplayGrayscaleValue;
    private String graphicLayerOrder;
    private String graphicLayerDescription;
    private String graphicLayer;
    private int[] graphicLayerRecommendedDisplayCIELabValue;

    public GraphicLayer() {
        this.graphicLayer = null;
        this.graphicLayerDescription = DEFAULT_LAYER_NAME;
        this.graphicLayerOrder = "0";
        this.graphicLayerRecommendedDisplayGrayscaleValue = 65535;
        this.graphicLayerRecommendedDisplayRGBValue = new int[]{65535, 65535, 65535};
    }

    private GraphicLayer(Attributes attributes) {
        this.graphicLayer = this.getString(attributes, 0x700002);
        this.graphicLayerDescription = this.getString(attributes, 7340136);
        this.graphicLayerOrder = this.getString(attributes, 7340130);
        this.graphicLayerRecommendedDisplayGrayscaleValue = this.getInteger(attributes, 0x700066);
        this.graphicLayerRecommendedDisplayRGBValue = this.getIntegers(attributes, 0x700067);
        this.graphicLayerRecommendedDisplayCIELabValue = this.getIntegers(attributes, 7341057);
    }

    public Attributes toDataset() {
        Attributes attributes = new Attributes();
        this.set(this.graphicLayer, attributes, 0x700002, DatasetAccessor.Type.Mandatory);
        this.set(this.graphicLayerDescription, attributes, 7340136, DatasetAccessor.Type.Optional);
        this.set(this.graphicLayerOrder, attributes, 7340130, DatasetAccessor.Type.Mandatory);
        this.set(this.graphicLayerRecommendedDisplayGrayscaleValue, attributes, 0x700066, DatasetAccessor.Type.Optional);
        this.set(this.graphicLayerRecommendedDisplayRGBValue, attributes, 0x700067, DatasetAccessor.Type.Optional);
        this.set(this.graphicLayerRecommendedDisplayCIELabValue, attributes, 7341057, DatasetAccessor.Type.Optional);
        return attributes;
    }

    public static GraphicLayer createDefault() {
        return new GraphicLayer();
    }

    public static List<GraphicLayer> createDefaultAsList() {
        ArrayList<GraphicLayer> arrayList = new ArrayList<GraphicLayer>();
        arrayList.add(GraphicLayer.createDefault());
        return arrayList;
    }

    public static GraphicLayer create(Attributes attributes) {
        if (attributes == null) {
            return null;
        }
        if (attributes.contains(0x700002) && attributes.contains(7340130)) {
            return new GraphicLayer(attributes);
        }
        return null;
    }

    public static List<GraphicLayer> createList(Attributes attributes, int n) {
        ArrayList<GraphicLayer> arrayList = new ArrayList<GraphicLayer>();
        Sequence sequence = attributes.getSequence(n);
        if (sequence == null) {
            return arrayList;
        }
        int n2 = 0;
        while (n2 < sequence.size()) {
            GraphicLayer graphicLayer = GraphicLayer.create((Attributes)sequence.get(n2));
            if (graphicLayer != null) {
                arrayList.add(graphicLayer);
            }
            ++n2;
        }
        return arrayList;
    }

    public String getGraphicLayer() {
        return this.graphicLayer;
    }

    public String getGraphicLayerDescription() {
        return this.graphicLayerDescription;
    }

    public String getGraphicLayerOrder() {
        return this.graphicLayerOrder;
    }

    public Integer getGraphicLayerRecommendedDisplayGrayscaleValue() {
        return this.graphicLayerRecommendedDisplayGrayscaleValue;
    }

    public int[] getGraphicLayerRecommendedDisplayRGBValue() {
        return this.graphicLayerRecommendedDisplayRGBValue;
    }

    public int[] getGraphicLayerRecommendedDisplayCIELabValue() {
        return this.graphicLayerRecommendedDisplayCIELabValue;
    }

    @Override
    public int compareTo(GraphicLayer graphicLayer) {
        return Integer.parseInt(this.graphicLayerOrder) - Integer.parseInt(graphicLayer.graphicLayerOrder);
    }

    public String toString() {
        return "(" + this.graphicLayer + ", " + this.graphicLayerDescription + ", " + this.graphicLayerOrder + ")";
    }

    public Color getColor(boolean bl) {
        int[] nArray;
        Color color = null;
        Integer n = this.getGraphicLayerRecommendedDisplayGrayscaleValue();
        if (n != null) {
            color = new Color(n >> 8, n >> 8, n >> 8);
        }
        if (bl && (nArray = this.getGraphicLayerRecommendedDisplayRGBValue()) != null) {
            color = new Color(nArray[0] >> 8, nArray[1] >> 8, nArray[2] >> 8);
        }
        return color;
    }

    public static int[] to16BitRgbValue(Color color) {
        int[] nArray = new int[]{color.getRed(), color.getGreen(), color.getBlue()};
        int[] nArray2 = new int[]{nArray[0] << 8 | nArray[0], nArray[1] << 8 | nArray[1], nArray[2] << 8 | nArray[2]};
        return nArray2;
    }

    public void setGraphicLayer(String string) {
        this.graphicLayer = string;
    }

    public void setGraphicLayerDescription(String string) {
        this.graphicLayerDescription = string;
    }

    public void setGraphicLayerOrder(String string) {
        this.graphicLayerOrder = string;
    }

    public void setGraphicLayerRecommendedDisplayCIELabValue(int[] nArray) {
        this.graphicLayerRecommendedDisplayCIELabValue = nArray;
    }

    public void setGraphicLayerRecommendedDisplayGrayscaleValue(Integer n) {
        this.graphicLayerRecommendedDisplayGrayscaleValue = n;
    }

    public void setGraphicLayerRecommendedDisplayRGBValue(int[] nArray) {
        this.graphicLayerRecommendedDisplayRGBValue = nArray;
    }
}

