/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.dicomobject.module.ps;

import com.agfa.pacs.data.shared.data.AbstractDatasetSource;
import com.agfa.pacs.data.shared.data.DatasetAccessor;
import com.agfa.pacs.listtext.dicomobject.module.ps.MaskOperation;
import com.agfa.pacs.listtext.dicomobject.module.ps.MaskSelectionMode;
import java.util.ArrayList;
import java.util.List;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.Sequence;

public class MaskSubtraction
extends AbstractDatasetSource {
    private MaskOperation maskOperation;
    private int[] applicableFrameRange;
    private int[] maskFrameNumbers;
    private int[] contrastFrameAveraging;
    private float[] maskSubPixelShift;
    private Integer tidOffset;
    private String maskOperationExplanation;
    private Integer subtractionItemID;
    private MaskSelectionMode maskSelectionMode;

    private MaskSubtraction(Attributes attributes) {
        this.maskOperation = MaskOperation.get(this.getString(attributes, 2646273));
        this.applicableFrameRange = this.getIntegers(attributes, 2646274);
        this.subtractionItemID = this.getInteger(attributes, 2659350);
        this.maskFrameNumbers = this.getIntegers(attributes, 2646288);
        this.contrastFrameAveraging = this.getIntegers(attributes, 2646290);
        this.maskSubPixelShift = this.getFloats(attributes, 2646292);
        this.tidOffset = this.getInteger(attributes, 2646304);
        this.maskOperationExplanation = this.getString(attributes, 2646416);
        this.maskSelectionMode = MaskSelectionMode.get(this.getString(attributes, 2659412));
    }

    public Attributes toDataset() {
        Attributes attributes = new Attributes();
        this.set(this.maskOperation, attributes, 2646273, DatasetAccessor.Type.Mandatory);
        this.set(this.applicableFrameRange, attributes, 2646274, DatasetAccessor.Type.ConditionalMandatory);
        this.set(this.subtractionItemID, attributes, 2659350, DatasetAccessor.Type.ConditionalMandatory);
        this.set(this.maskFrameNumbers, attributes, 2646288, DatasetAccessor.Type.ConditionalMandatory);
        this.set(this.contrastFrameAveraging, attributes, 2646290, DatasetAccessor.Type.Optional);
        this.set(this.maskSubPixelShift, attributes, 2646292, DatasetAccessor.Type.Optional);
        this.set(this.tidOffset, attributes, 2646304, DatasetAccessor.Type.ConditionalMandatoryOrEmpty);
        this.set(this.maskOperationExplanation, attributes, 2646416, DatasetAccessor.Type.Optional);
        this.set(this.maskSelectionMode, attributes, 2659412, DatasetAccessor.Type.Optional);
        return attributes;
    }

    public static MaskSubtraction create(Attributes attributes) {
        if (attributes.contains(2646288)) {
            return new MaskSubtraction(attributes);
        }
        return null;
    }

    public static List<MaskSubtraction> createList(Attributes attributes, int n) {
        ArrayList<MaskSubtraction> arrayList = new ArrayList<MaskSubtraction>();
        Sequence sequence = attributes.getSequence(n);
        if (sequence == null) {
            return arrayList;
        }
        int n2 = 0;
        while (n2 < sequence.size()) {
            MaskSubtraction maskSubtraction = MaskSubtraction.create((Attributes)sequence.get(n2));
            if (maskSubtraction != null) {
                arrayList.add(maskSubtraction);
            }
            ++n2;
        }
        return arrayList;
    }

    public int[] getApplicableFrameRange() {
        return this.applicableFrameRange;
    }

    public int[] getContrastFrameAveraging() {
        return this.contrastFrameAveraging;
    }

    public int[] getMaskFrameNumbers() {
        return this.maskFrameNumbers;
    }

    public MaskOperation getMaskOperation() {
        return this.maskOperation;
    }

    public float[] getMaskSubPixelShift() {
        return this.maskSubPixelShift;
    }

    public Integer getTIDOffset() {
        return this.tidOffset;
    }

    public String getMaskOperationExplanation() {
        return this.maskOperationExplanation;
    }

    public MaskSelectionMode getMaskSelectionMode() {
        return this.maskSelectionMode;
    }

    public Integer getSubtractionItemID() {
        return this.subtractionItemID;
    }
}

