/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.dicomobject.module.ps;

import com.agfa.pacs.data.shared.data.AbstractDatasetSource;
import com.agfa.pacs.data.shared.data.DatasetAccessor;
import com.agfa.pacs.data.shared.lut.DicomLookupTable;
import com.agfa.pacs.data.shared.lut.ILookupTable;
import com.agfa.pacs.data.shared.lut.ILookupTableSource;
import com.agfa.pacs.logging.ALogger;
import com.agfa.pacs.tools.CompareUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.Sequence;

public final class ModalityLookupTable
extends AbstractDatasetSource
implements ILookupTableSource {
    protected String lutExplanation;
    protected int[] lutDescriptor;
    protected byte[] lutData;
    private String modalityLUTType;

    public ModalityLookupTable() {
    }

    private ModalityLookupTable(Attributes attributes) {
        this.lutDescriptor = ModalityLookupTable.getLUTDescriptor((Attributes)attributes);
        this.lutExplanation = this.getString(attributes, 2633731);
        this.modalityLUTType = this.getString(attributes, 2633732);
        try {
            this.lutData = attributes.getBytes(2633734);
        }
        catch (IOException iOException) {
            ALogger.getLogger(ModalityLookupTable.class).error("Bulk error", (Throwable)iOException);
        }
    }

    public static ModalityLookupTable create(Attributes attributes) {
        if (attributes == null) {
            return null;
        }
        if (attributes.contains(2633730)) {
            return new ModalityLookupTable(attributes);
        }
        return null;
    }

    public static List<ModalityLookupTable> createList(Attributes attributes, int n) {
        ArrayList<ModalityLookupTable> arrayList = new ArrayList<ModalityLookupTable>();
        Sequence sequence = attributes.getSequence(n);
        if (sequence == null) {
            return arrayList;
        }
        int n2 = 0;
        while (n2 < sequence.size()) {
            ModalityLookupTable modalityLookupTable = ModalityLookupTable.create((Attributes)sequence.get(n2));
            if (modalityLookupTable != null) {
                arrayList.add(modalityLookupTable);
            }
            ++n2;
        }
        return arrayList;
    }

    public Attributes toDataset() {
        Attributes attributes = new Attributes();
        this.set(this.lutDescriptor, attributes, 2633730, DatasetAccessor.Type.Mandatory);
        this.set(this.lutExplanation, attributes, 2633731, DatasetAccessor.Type.Optional);
        this.set(this.modalityLUTType, attributes, 2633732, DatasetAccessor.Type.Mandatory);
        this.set(this.lutData, attributes, 2633734, DatasetAccessor.Type.Mandatory);
        return attributes;
    }

    public void setLUTData(byte[] byArray) {
        this.lutData = byArray;
    }

    public void setLUTDescriptor(int[] nArray) {
        this.lutDescriptor = nArray;
    }

    public ILookupTable getLookupTable() {
        return new DicomLookupTable(this.lutDescriptor, this.lutData, null, this.lutExplanation);
    }

    public boolean hasLookupTable() {
        return this.lutDescriptor != null;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof ModalityLookupTable)) {
            return false;
        }
        ModalityLookupTable modalityLookupTable = (ModalityLookupTable)((Object)object);
        return CompareUtils.equals((Object)this.lutExplanation, (Object)modalityLookupTable.lutExplanation) && CompareUtils.equals((Object)this.modalityLUTType, (Object)modalityLookupTable.modalityLUTType) && Arrays.equals(this.lutDescriptor, modalityLookupTable.lutDescriptor) && Arrays.equals(this.lutData, modalityLookupTable.lutData);
    }

    public int hashCode() {
        return CompareUtils.hashCode((Object)this.lutExplanation) ^ CompareUtils.hashCode((Object)this.modalityLUTType) ^ CompareUtils.hashCode((Object)this.lutDescriptor) ^ CompareUtils.hashCode((Object)this.lutData);
    }
}

