/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.dicomobject.module.ps;

import com.agfa.pacs.cache.ByteArrayContainer;
import com.agfa.pacs.cache.CacheID;
import com.agfa.pacs.cache.DataCacheProviderFactory;
import com.agfa.pacs.cache.IPersistentCache;
import com.agfa.pacs.data.shared.data.AbstractDatasetSource;
import com.agfa.pacs.data.shared.data.DatasetAccessor;
import com.agfa.pacs.data.shared.util.OverlayUtils;
import com.agfa.pacs.logging.ALogger;
import java.io.IOException;
import org.dcm4che3.data.Attributes;

public class OverlayPlane
extends AbstractDatasetSource {
    private static final IPersistentCache cache = DataCacheProviderFactory.getPersistentCache();
    private String overlayType;
    private int[] overlayOrigin;
    private Integer overlayBitsAllocated;
    private Integer overlayBitPosition;
    private CacheID key = null;
    private String StudyInstanceUID;
    private String SOPInstanceUID;
    private String overlayDescription;
    private String overlaySubtype;
    private String overlayLabel;
    private String roiArea;
    private String roiMean;
    private String roiStandardDeviation;
    private Integer overlayRows;
    private Integer overlayColumns;
    private Integer imageFrameOrigin;
    private Integer numberOfFramesInOverlay;
    private int groupTag;

    public OverlayPlane() {
    }

    public OverlayPlane(CacheID cacheID) {
        this();
        this.key = cacheID;
    }

    private OverlayPlane(Attributes attributes, int n) {
        this.groupTag = n;
        this.overlayRows = this.getInteger(attributes, 0x60000010 + this.groupTag);
        this.overlayColumns = this.getInteger(attributes, 0x60000011 + this.groupTag);
        this.overlayType = this.getString(attributes, 0x60000040 + this.groupTag);
        this.overlayOrigin = this.getIntegers(attributes, 0x60000050 + this.groupTag);
        this.overlayBitsAllocated = this.getInteger(attributes, 0x60000100 + this.groupTag);
        this.overlayBitPosition = this.getInteger(attributes, 1610612994 + this.groupTag);
        byte[] byArray = null;
        try {
            byArray = attributes.getBytes(0x60003000 + this.groupTag);
        }
        catch (IOException iOException) {
            ALogger.getLogger(OverlayPlane.class).error("Bulk data error", (Throwable)iOException);
            return;
        }
        this.StudyInstanceUID = attributes.getString(0x20000D);
        this.SOPInstanceUID = attributes.getString(524312);
        if (byArray != null) {
            this.key = OverlayUtils.getOverlayCacheID((String)this.StudyInstanceUID, (String)this.SOPInstanceUID, (int)n);
            if (!cache.exists(ByteArrayContainer.class, this.key)) {
                cache.addPersistentObject((Object)new ByteArrayContainer((byte[])byArray.clone()), this.key);
            }
        }
        this.overlayDescription = this.getString(attributes, 0x60000022 + this.groupTag);
        this.overlaySubtype = this.getString(attributes, 1610612805 + this.groupTag);
        this.overlayLabel = this.getString(attributes, 1610618112 + this.groupTag);
        this.roiArea = this.getString(attributes, 1610617601 + this.groupTag);
        this.roiMean = this.getString(attributes, 1610617602 + this.groupTag);
        this.roiStandardDeviation = this.getString(attributes, 1610617603 + this.groupTag);
        this.numberOfFramesInOverlay = this.getInteger(attributes, 1610612757 + this.groupTag);
        this.imageFrameOrigin = this.getInteger(attributes, 1610612817 + this.groupTag);
    }

    public static OverlayPlane create(Attributes attributes, int n) {
        if (attributes.contains(0x60000040 + n) && attributes.contains(0x60000050 + n) && attributes.contains(0x60000100 + n) && attributes.contains(1610612994 + n)) {
            return new OverlayPlane(attributes, n);
        }
        return null;
    }

    public int getGroupTag() {
        return this.groupTag;
    }

    public Attributes writeToGroup(int n) {
        this.groupTag = n;
        return this.toDataset();
    }

    public Integer getImageFrameOrigin() {
        if (this.imageFrameOrigin == null) {
            return 1;
        }
        return this.imageFrameOrigin;
    }

    public int getNumberOfFramesInOverlay() {
        if (this.numberOfFramesInOverlay == null) {
            return 1;
        }
        return this.numberOfFramesInOverlay;
    }

    public Integer getOverlayBitPosition() {
        return this.overlayBitPosition;
    }

    public Integer getOverlayBitsAllocated() {
        return this.overlayBitsAllocated;
    }

    public Integer getOverlayColumns() {
        return this.overlayColumns;
    }

    public byte[] getOverlayData() {
        byte[] byArray = new byte[1];
        if (this.key != null) {
            ByteArrayContainer byteArrayContainer = OverlayUtils.getBitmapOverlay((CacheID)this.key);
            byArray = DataCacheProviderFactory.getMemoryPool().allocBytes((long)byteArrayContainer.length);
            System.arraycopy(byteArrayContainer.data, byteArrayContainer.offset, byArray, 0, byteArrayContainer.length);
            cache.releaseReference(this.key);
        }
        return byArray;
    }

    public CacheID getOverlayDataCacheID() {
        return this.key;
    }

    public String getOverlayDescription() {
        return this.overlayDescription;
    }

    public String getOverlayLabel() {
        return this.overlayLabel;
    }

    public int[] getOverlayOrigin() {
        return this.overlayOrigin;
    }

    public int getOverlayRows() {
        return this.overlayRows;
    }

    public String getOverlaySubtype() {
        return this.overlaySubtype;
    }

    public String getOverlayType() {
        return this.overlayType;
    }

    public Integer getRoiArea() {
        return Integer.parseInt(this.roiArea);
    }

    public Double getRoiMean() {
        return Double.valueOf(this.roiMean);
    }

    public Double getRoiStandardDeviation() {
        return Double.valueOf(this.roiStandardDeviation);
    }

    public Attributes toDataset() {
        Attributes attributes = new Attributes();
        this.set(this.overlayRows, attributes, 0x60000010 + this.groupTag, DatasetAccessor.Type.Mandatory);
        this.set(this.overlayColumns, attributes, 0x60000011 + this.groupTag, DatasetAccessor.Type.Mandatory);
        this.set(this.overlayType, attributes, 0x60000040 + this.groupTag, DatasetAccessor.Type.Mandatory);
        this.set(this.overlayOrigin, attributes, 0x60000050 + this.groupTag, DatasetAccessor.Type.Mandatory);
        this.set(this.overlayBitsAllocated, attributes, 0x60000100 + this.groupTag, DatasetAccessor.Type.Mandatory);
        this.set(this.overlayBitPosition, attributes, 1610612994 + this.groupTag, DatasetAccessor.Type.Mandatory);
        this.set(this.getOverlayData(), attributes, 0x60003000 + this.groupTag, DatasetAccessor.Type.Mandatory);
        this.set(this.overlayDescription, attributes, 0x60000022 + this.groupTag, DatasetAccessor.Type.Optional);
        this.set(this.overlaySubtype, attributes, 1610612805 + this.groupTag, DatasetAccessor.Type.Optional);
        this.set(this.overlayLabel, attributes, 1610618112 + this.groupTag, DatasetAccessor.Type.Optional);
        this.set(this.roiArea, attributes, 1610617601 + this.groupTag, DatasetAccessor.Type.Optional);
        this.set(this.roiMean, attributes, 1610617602 + this.groupTag, DatasetAccessor.Type.Optional);
        this.set(this.roiStandardDeviation, attributes, 1610617603 + this.groupTag, DatasetAccessor.Type.Optional);
        this.set(this.numberOfFramesInOverlay, attributes, 1610612757 + this.groupTag, DatasetAccessor.Type.Mandatory);
        this.set(this.imageFrameOrigin, attributes, 1610612817 + this.groupTag, DatasetAccessor.Type.Optional);
        return attributes;
    }

    public void setImageFrameOrigin(Integer n) {
        this.imageFrameOrigin = n;
    }

    public void setNumberOfFramesInOverlay(Integer n) {
        this.numberOfFramesInOverlay = n;
    }

    public void setOverlayBitPosition(Integer n) {
        this.overlayBitPosition = n;
    }

    public void setOverlayBitsAllocated(Integer n) {
        this.overlayBitsAllocated = n;
    }

    public void setOverlayColumns(Integer n) {
        this.overlayColumns = n;
    }

    public void setOverlayData(byte[] byArray) {
        if (this.key != null) {
            cache.releaseReference(this.key);
        }
        this.key = OverlayUtils.getOverlayCacheID((String)this.StudyInstanceUID, (String)this.SOPInstanceUID, (int)this.groupTag);
        if (!cache.exists(ByteArrayContainer.class, this.key) && byArray != null) {
            cache.addPersistentObject((Object)new ByteArrayContainer((byte[])byArray.clone()), this.key);
        }
    }

    public void setOverlayDescription(String string) {
        this.overlayDescription = string;
    }

    public void setOverlayLabel(String string) {
        this.overlayLabel = string;
    }

    public void setOverlayOrigin(int[] nArray) {
        this.overlayOrigin = nArray;
    }

    public void setOverlayRows(int n) {
        this.overlayRows = n;
    }

    public void setOverlaySubtype(String string) {
        this.overlaySubtype = string;
    }

    public void setOverlayType(String string) {
        this.overlayType = string;
    }

    public void setRoiArea(String string) {
        this.roiArea = string;
    }

    public void setRoiMean(String string) {
        this.roiMean = string;
    }

    public void setRoiStandardDeviation(String string) {
        this.roiStandardDeviation = string;
    }

    public String getProviderUID() {
        return this.SOPInstanceUID;
    }
}

