/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.dicomobject.module.ps;

import com.agfa.pacs.data.shared.dicom.DicomEnum;

public class RescaleType
implements DicomEnum {
    public static final RescaleType OpticalDensity = new RescaleType("OD", 0.001);
    public static final RescaleType HounsfieldUnits = new RescaleType("HU", 1.0);
    public static final RescaleType Unspecified = new RescaleType("US", 1.0);
    private final String dicomId;
    private double scale;

    RescaleType(String string, double d) {
        this.dicomId = string;
        this.scale = d;
    }

    public String dicom() {
        return this.dicomId;
    }

    public double scale() {
        return this.scale;
    }

    public static RescaleType get(String string) {
        if (string == null) {
            return null;
        }
        if (HounsfieldUnits.dicom().equals(string)) {
            return HounsfieldUnits;
        }
        if (OpticalDensity.dicom().equals(string)) {
            return OpticalDensity;
        }
        if (Unspecified.dicom().equals(string)) {
            return Unspecified;
        }
        return new RescaleType(string, 1.0);
    }
}

