/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.dicomobject.module.ps;

import com.agfa.pacs.data.shared.data.AbstractDatasetSource;
import com.agfa.pacs.data.shared.data.DatasetAccessor;
import com.agfa.pacs.listtext.dicomobject.general.ReferencedImage;
import com.agfa.pacs.listtext.dicomobject.interfaces.IImageReferencing;
import com.agfa.pacs.listtext.dicomobject.module.ps.IVOILUT;
import com.agfa.pacs.listtext.dicomobject.module.ps.VOILUT;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.Sequence;

public class SoftcopyVOILUT
extends AbstractDatasetSource
implements IImageReferencing {
    private IVOILUT voiLUT;
    private Map<String, ReferencedImage> referencedImages;

    public SoftcopyVOILUT() {
        this.referencedImages = new LinkedHashMap<String, ReferencedImage>();
    }

    private SoftcopyVOILUT(Attributes attributes) {
        this.voiLUT = VOILUT.create(attributes);
        this.referencedImages = ReferencedImage.createMap(attributes, 528704);
    }

    private static SoftcopyVOILUT create(Attributes attributes) {
        if (attributes == null) {
            return null;
        }
        return new SoftcopyVOILUT(attributes);
    }

    public static List<SoftcopyVOILUT> createList(Attributes attributes, int n) {
        ArrayList<SoftcopyVOILUT> arrayList = new ArrayList<SoftcopyVOILUT>();
        Sequence sequence = attributes.getSequence(n);
        if (sequence == null) {
            return arrayList;
        }
        int n2 = 0;
        while (n2 < sequence.size()) {
            SoftcopyVOILUT softcopyVOILUT = SoftcopyVOILUT.create((Attributes)sequence.get(n2));
            if (softcopyVOILUT != null) {
                arrayList.add(softcopyVOILUT);
            }
            ++n2;
        }
        return arrayList;
    }

    public Attributes toDataset() {
        Attributes attributes = new Attributes();
        this.voiLUT.toDataset(attributes);
        this.set(this.referencedImages.values(), attributes, 528704, DatasetAccessor.Type.ConditionalMandatory);
        return attributes;
    }

    @Override
    public Map<String, ReferencedImage> referencedImages() {
        return this.referencedImages;
    }

    public IVOILUT getVOILUT() {
        return this.voiLUT;
    }

    public void setVOILUT(IVOILUT iVOILUT) {
        this.voiLUT = iVOILUT;
    }
}

