/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.dicomobject.module.ps;

import com.agfa.pacs.data.shared.data.DatasetAccessor;
import com.agfa.pacs.data.shared.dicom.Level;
import com.agfa.pacs.listtext.dicomobject.module.AbstractModule;
import com.agfa.pacs.listtext.dicomobject.type.YN;
import com.agfa.pacs.tools.CompareUtils;
import com.agfa.pacs.tools.DoubleEquals;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.dcm4che3.data.Attributes;

public class SpatialTransformationModule
extends AbstractModule {
    private Integer imageRotation;
    private YN imageHorizontalFlip;
    private Double freeRotationAngle;

    public SpatialTransformationModule() {
        super(Level.Object);
    }

    @Override
    public boolean isValid() {
        return true;
    }

    @Override
    public boolean containsModule(Attributes attributes) {
        return attributes.contains(7340098);
    }

    @Override
    public void readFrom(Attributes attributes) {
        this.imageRotation = this.getInteger(attributes, 7340098);
        this.imageHorizontalFlip = YN.get(this.getString(attributes, 7340097));
        this.freeRotationAngle = this.getDouble(attributes, 0x290020, "TIANI");
    }

    @Override
    public void writeTo(Attributes attributes) {
        this.set(this.imageRotation, attributes, 7340098, DatasetAccessor.Type.Mandatory);
        this.set(this.imageHorizontalFlip, attributes, 7340097, DatasetAccessor.Type.Mandatory);
        this.set(this.freeRotationAngle, attributes, 0x290020, "TIANI");
    }

    public YN getImageHorizontalFlip() {
        return this.imageHorizontalFlip;
    }

    public Integer getImageRotation() {
        return this.imageRotation;
    }

    public Double getFreeRotationAngle() {
        return this.freeRotationAngle;
    }

    public void setImageHorizontalFlip(YN yN) {
        this.imageHorizontalFlip = yN;
    }

    public void setImageRotation(Integer n) {
        this.imageRotation = n;
    }

    public void setFreeRotationAngle(Double d) {
        this.freeRotationAngle = d;
    }

    public void copy(SpatialTransformationModule spatialTransformationModule) {
        this.imageHorizontalFlip = spatialTransformationModule.getImageHorizontalFlip();
        this.imageRotation = spatialTransformationModule.getImageRotation();
        this.freeRotationAngle = spatialTransformationModule.getFreeRotationAngle();
    }

    public boolean equals(Object object) {
        if (!(object instanceof SpatialTransformationModule)) {
            return false;
        }
        SpatialTransformationModule spatialTransformationModule = (SpatialTransformationModule)object;
        return this.imageHorizontalFlip == spatialTransformationModule.imageHorizontalFlip && CompareUtils.equals((Object)this.imageRotation, (Object)spatialTransformationModule.imageRotation) && this.match(this.freeRotationAngle, spatialTransformationModule.freeRotationAngle);
    }

    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode((Object)this, (String[])new String[0]);
    }

    public boolean hasSomeRotationFlipping() {
        return this.imageHorizontalFlip == YN.Yes || this.imageRotation != null && this.imageRotation != 0 || this.hasFreeRotation();
    }

    public boolean hasFreeRotation() {
        return this.freeRotationAngle != null && !DoubleEquals.equals((double)this.freeRotationAngle, (double)0.0);
    }
}

