/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.dicomobject.module.ps;

import com.agfa.pacs.data.shared.lut.DicomLookupTable;
import com.agfa.pacs.data.shared.lut.IColorLookupTableSource;
import com.agfa.pacs.data.shared.lut.ILookupTable;
import com.agfa.pacs.listtext.dicomobject.module.ps.PaletteColorLUTModule;
import com.agfa.pacs.logging.ALogger;
import java.io.IOException;
import org.dcm4che3.data.Attributes;

public class TianiPaletteColorLUTModule
extends PaletteColorLUTModule {
    private int[] alphaPaletteColorLookupTableDescriptor;
    private byte[] alphaPaletteColorLookupTableData;
    private byte[] segmentedAlphaPaletteColorLookupTableData;

    @Override
    public boolean isValid() {
        return true;
    }

    @Override
    public boolean containsModule(Attributes attributes) {
        return true;
    }

    @Override
    public void readFrom(Attributes attributes) {
        super.readFrom(attributes);
        this.alphaPaletteColorLookupTableDescriptor = this.getIntegers(attributes, 0x290000, "TIANI");
        try {
            this.alphaPaletteColorLookupTableData = attributes.getBytes("TIANI", 0x290002);
            this.segmentedAlphaPaletteColorLookupTableData = attributes.getBytes("TIANI", 2686977);
        }
        catch (IOException iOException) {
            ALogger.getLogger(TianiPaletteColorLUTModule.class).error("Bulk data error", (Throwable)iOException);
        }
    }

    @Override
    public void writeTo(Attributes attributes) {
        super.writeTo(attributes);
        if (this.alphaPaletteColorLookupTableDescriptor != null) {
            this.set(this.alphaPaletteColorLookupTableDescriptor, attributes, 0x290000, "TIANI");
            this.set(this.alphaPaletteColorLookupTableData, attributes, 0x290002, "TIANI");
            this.set(this.segmentedAlphaPaletteColorLookupTableData, attributes, 2686977, "TIANI");
        }
    }

    public byte[] getAlphaPaletteColorLookupTableData() {
        return this.alphaPaletteColorLookupTableData;
    }

    public void setAlphaPaletteColorLookupTableData(byte[] byArray) {
        this.alphaPaletteColorLookupTableData = byArray;
    }

    public int[] getAlphaPaletteColorLookupTableDescriptor() {
        return this.alphaPaletteColorLookupTableDescriptor;
    }

    public void setAlphaPaletteColorLookupTableDescriptor(int[] nArray) {
        this.alphaPaletteColorLookupTableDescriptor = nArray;
    }

    public byte[] getSegmentedAlphaPaletteColorLookupTableData() {
        return this.segmentedAlphaPaletteColorLookupTableData;
    }

    public void setSegmentedAlphaPaletteColorLookupTableData(byte[] byArray) {
        this.segmentedAlphaPaletteColorLookupTableData = byArray;
    }

    @Override
    public ILookupTable getLookupTable(IColorLookupTableSource.Channel channel) {
        switch (channel) {
            case Alpha: {
                if (this.alphaPaletteColorLookupTableDescriptor == null) {
                    return null;
                }
                return new DicomLookupTable(this.alphaPaletteColorLookupTableDescriptor, this.alphaPaletteColorLookupTableData, this.segmentedAlphaPaletteColorLookupTableData, channel.toString());
            }
        }
        return super.getLookupTable(channel);
    }

    @Override
    public void setTo(IColorLookupTableSource.Channel channel, ILookupTable iLookupTable) {
        switch (channel) {
            case Alpha: {
                if (!(iLookupTable instanceof DicomLookupTable)) break;
                DicomLookupTable dicomLookupTable = (DicomLookupTable)iLookupTable;
                this.alphaPaletteColorLookupTableDescriptor = dicomLookupTable.getLUTDescriptor();
                if (dicomLookupTable.getLUTSegmentedData() != null) {
                    this.segmentedAlphaPaletteColorLookupTableData = dicomLookupTable.getLUTSegmentedData();
                    break;
                }
                this.alphaPaletteColorLookupTableData = dicomLookupTable.getLUTData();
                break;
            }
            default: {
                super.setTo(channel, iLookupTable);
            }
        }
    }
}

