/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.dicomobject.module.series;

import com.agfa.pacs.data.shared.data.DatasetAccessor;
import com.agfa.pacs.data.shared.data.DatasetSource;
import com.agfa.pacs.data.shared.dicom.Level;
import com.agfa.pacs.listtext.dicomobject.general.PersonIdentification;
import com.agfa.pacs.listtext.dicomobject.general.ReferencedSOP;
import com.agfa.pacs.listtext.dicomobject.interfaces.IExtendedSeriesIdentifier;
import com.agfa.pacs.listtext.dicomobject.module.AbstractModule;
import com.agfa.pacs.listtext.dicomobject.module.series.Protocol;
import com.agfa.pacs.listtext.dicomobject.module.series.RelatedSeries;
import com.agfa.pacs.listtext.dicomobject.module.series.RequestAttribute;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.dcm4che3.data.Attributes;

public class GeneralSeriesModule
extends AbstractModule
implements IExtendedSeriesIdentifier {
    private String modality;
    private String seriesInstanceUID;
    private Integer seriesNumber;
    private String laterality;
    private Date seriesDate;
    private Date seriesTime;
    private List<String> performingPhysicianName;
    private List<PersonIdentification> performingPhysicianIdentification;
    private String protocolName;
    private String seriesDescription;
    private List<String> operatorName;
    private List<PersonIdentification> operatorIdentification;
    private ReferencedSOP performedProcedureStep;
    private String bodyPartExamined;
    private String patientPosition;
    private Integer smallestPixelValueInSeries;
    private Integer largestPixelValueInSeries;
    private String ppsID;
    private Date ppsStartDate;
    private Date ppsStartTime;
    private String ppsDescription;
    private String ppsComments;
    private List<RelatedSeries> relatedSeries = new ArrayList<RelatedSeries>();
    private List<RequestAttribute> requestAttribute = new ArrayList<RequestAttribute>();
    private List<Protocol> performedProtocol = new ArrayList<Protocol>();

    public GeneralSeriesModule() {
        super(Level.Series);
        this.performingPhysicianIdentification = new ArrayList<PersonIdentification>();
        this.operatorIdentification = new ArrayList<PersonIdentification>();
        this.performingPhysicianName = new ArrayList<String>();
    }

    @Override
    public boolean isValid() {
        return true;
    }

    @Override
    public boolean containsModule(Attributes attributes) {
        return true;
    }

    @Override
    public void readFrom(Attributes attributes) {
        this.modality = this.getString(attributes, 524384);
        this.seriesInstanceUID = this.getString(attributes, 0x20000E);
        this.seriesNumber = this.getInteger(attributes, 0x200011);
        this.laterality = this.getString(attributes, 0x200060);
        this.seriesDate = this.getDate(attributes, 524321);
        this.seriesTime = this.getDate(attributes, 524337);
        this.performingPhysicianName = this.getStringsAsList(attributes, 528464);
        this.performingPhysicianIdentification = PersonIdentification.createList(attributes, 528466);
        this.protocolName = this.getString(attributes, 1577008);
        this.seriesDescription = this.getString(attributes, 528446);
        this.operatorName = this.getStringsAsList(attributes, 528496);
        this.operatorIdentification = PersonIdentification.createList(attributes, 528498);
        this.performedProcedureStep = ReferencedSOP.create((Attributes)attributes.getNestedDataset(528657));
        this.relatedSeries = RelatedSeries.createList(attributes, 528976);
        this.bodyPartExamined = this.getString(attributes, 1572885);
        this.patientPosition = this.getString(attributes, 1593600);
        this.smallestPixelValueInSeries = this.getInteger(attributes, 2621704);
        this.largestPixelValueInSeries = this.getInteger(attributes, 2621705);
        this.requestAttribute = RequestAttribute.createList(attributes, 4194933);
        this.ppsID = this.getString(attributes, 4194899);
        this.ppsStartDate = this.getDate(attributes, 0x400244);
        this.ppsStartTime = this.getDate(attributes, 4194885);
        this.ppsDescription = this.getString(attributes, 4194900);
        this.performedProtocol = Protocol.createList(attributes, 4194912);
        this.ppsComments = this.getString(attributes, 4194944);
    }

    @Override
    public void writeTo(Attributes attributes) {
        this.set(this.modality, attributes, 524384, DatasetAccessor.Type.Mandatory);
        this.set(this.seriesInstanceUID, attributes, 0x20000E, DatasetAccessor.Type.Mandatory);
        this.set(this.seriesNumber, attributes, 0x200011, DatasetAccessor.Type.MandatoryOrEmpty);
        this.set(this.laterality, attributes, 0x200060, DatasetAccessor.Type.ConditionalMandatoryOrEmpty);
        this.set(this.seriesDate, attributes, 524321, DatasetAccessor.Type.Optional);
        this.set(this.seriesTime, attributes, 524337, DatasetAccessor.Type.Optional);
        this.set(this.performingPhysicianName, attributes, 528464, DatasetAccessor.Type.Optional);
        this.set(this.performingPhysicianIdentification, attributes, 528466, DatasetAccessor.Type.Optional);
        this.set(this.protocolName, attributes, 1577008, DatasetAccessor.Type.Optional);
        this.set(this.seriesDescription, attributes, 528446, DatasetAccessor.Type.Optional);
        this.set(this.operatorName, attributes, 528496, DatasetAccessor.Type.Optional);
        this.set(this.operatorIdentification, attributes, 528498, DatasetAccessor.Type.Optional);
        this.set((DatasetSource)this.performedProcedureStep, attributes, 528657, DatasetAccessor.Type.Optional);
        this.set(this.relatedSeries, attributes, 528976, DatasetAccessor.Type.Optional);
        this.set(this.bodyPartExamined, attributes, 1572885, DatasetAccessor.Type.Optional);
        this.set(this.patientPosition, attributes, 1593600, DatasetAccessor.Type.Optional);
        this.set(this.smallestPixelValueInSeries, attributes, 2621704, DatasetAccessor.Type.Optional);
        this.set(this.largestPixelValueInSeries, attributes, 2621705, DatasetAccessor.Type.Optional);
        this.set(this.requestAttribute, attributes, 4194933, DatasetAccessor.Type.Optional);
        this.set(this.ppsID, attributes, 4194899, DatasetAccessor.Type.Optional);
        this.set(this.ppsStartDate, attributes, 0x400244, DatasetAccessor.Type.Optional);
        this.set(this.ppsStartTime, attributes, 4194885, DatasetAccessor.Type.Optional);
        this.set(this.ppsDescription, attributes, 4194900, DatasetAccessor.Type.Optional);
        this.set(this.performedProtocol, attributes, 4194912, DatasetAccessor.Type.Optional);
        this.set(this.ppsComments, attributes, 4194944, DatasetAccessor.Type.Optional);
    }

    public String getBodyPartExamined() {
        return this.bodyPartExamined;
    }

    public Integer getLargestPixelValueInSeries() {
        return this.largestPixelValueInSeries;
    }

    public String getLaterality() {
        return this.laterality;
    }

    @Override
    public String getModality() {
        return this.modality;
    }

    public List<PersonIdentification> operatorIdentification() {
        return this.operatorIdentification;
    }

    public List<String> operatorName() {
        return this.operatorName;
    }

    public String getPatientPosition() {
        return this.patientPosition;
    }

    @Override
    public ReferencedSOP getReferencedPerformedProcedureStep() {
        return this.performedProcedureStep;
    }

    public List<Protocol> performedProtocol() {
        return this.performedProtocol;
    }

    public List<PersonIdentification> performingPhysicianIdentification() {
        return this.performingPhysicianIdentification;
    }

    public List<String> performingPhysicianName() {
        return this.performingPhysicianName;
    }

    public String getPPSComments() {
        return this.ppsComments;
    }

    public String getPPSDescription() {
        return this.ppsDescription;
    }

    public String getPPSID() {
        return this.ppsID;
    }

    public Date getPPSStartDate() {
        return this.ppsStartDate;
    }

    public Date getPPSStartTime() {
        return this.ppsStartTime;
    }

    public String getProtocolName() {
        return this.protocolName;
    }

    public List<RelatedSeries> getRelatedSeries() {
        return this.relatedSeries;
    }

    public List<RequestAttribute> requestAttributes() {
        return this.requestAttribute;
    }

    @Override
    public Date getSeriesDate() {
        return this.seriesDate;
    }

    public String getSeriesDescription() {
        return this.seriesDescription;
    }

    @Override
    public String getSeriesInstanceUID() {
        return this.seriesInstanceUID;
    }

    @Override
    public Integer getSeriesNumber() {
        return this.seriesNumber;
    }

    @Override
    public Date getSeriesTime() {
        return this.seriesTime;
    }

    public Integer getSmallestPixelValueInSeries() {
        return this.smallestPixelValueInSeries;
    }

    @Override
    public void setModality(String string) {
        this.modality = string;
    }

    public void setBodyPartExamined(String string) {
        this.bodyPartExamined = string;
    }

    public void setLargestPixelValueInSeries(Integer n) {
        this.largestPixelValueInSeries = n;
    }

    public void setLaterality(String string) {
        this.laterality = string;
    }

    public void setPatientPosition(String string) {
        this.patientPosition = string;
    }

    @Override
    public void setReferencedPerformedProcedureStep(ReferencedSOP referencedSOP) {
        this.performedProcedureStep = referencedSOP;
    }

    public void setPPSComments(String string) {
        this.ppsComments = string;
    }

    public void setPPSDescription(String string) {
        this.ppsDescription = string;
    }

    public void setPPSID(String string) {
        this.ppsID = string;
    }

    public void setPPSStartDate(Date date) {
        this.ppsStartDate = date;
    }

    public void setPPSStartTime(Date date) {
        this.ppsStartTime = date;
    }

    public void setProtocolName(String string) {
        this.protocolName = string;
    }

    @Override
    public void setSeriesDate(Date date) {
        this.seriesDate = date;
    }

    public void setSeriesDescription(String string) {
        this.seriesDescription = string;
    }

    @Override
    public void setSeriesInstanceUID(String string) {
        this.seriesInstanceUID = string;
    }

    @Override
    public void setSeriesNumber(Integer n) {
        this.seriesNumber = n;
    }

    @Override
    public void setSeriesTime(Date date) {
        this.seriesTime = date;
    }

    public void setSmallestPixelValueInSeries(Integer n) {
        this.smallestPixelValueInSeries = n;
    }
}

