/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.dicomobject.module.series;

import com.agfa.pacs.data.shared.code.Code;
import com.agfa.pacs.data.shared.data.AbstractDatasetSource;
import com.agfa.pacs.data.shared.data.DatasetAccessor;
import com.agfa.pacs.data.shared.data.DatasetSource;
import com.agfa.pacs.listtext.dicomobject.module.series.ProtocolContext;
import java.util.ArrayList;
import java.util.List;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.Sequence;

public class Protocol
extends AbstractDatasetSource {
    private Code protocol;
    private List<ProtocolContext> protocolContext;

    public Protocol(Code code) {
        this.protocol = code;
        this.protocolContext = new ArrayList<ProtocolContext>();
    }

    private Protocol(Attributes attributes) {
        this.protocol = Code.create((Attributes)attributes);
        this.protocolContext = ProtocolContext.createList(attributes, 0x400440);
    }

    public static Protocol create(Attributes attributes) {
        return new Protocol(attributes);
    }

    public static List<Protocol> createList(Attributes attributes, int n) {
        Sequence sequence = attributes.getSequence(n);
        ArrayList<Protocol> arrayList = new ArrayList<Protocol>();
        if (sequence == null) {
            return arrayList;
        }
        int n2 = 0;
        while (n2 < sequence.size()) {
            arrayList.add(Protocol.create((Attributes)sequence.get(n2)));
            ++n2;
        }
        return arrayList;
    }

    public Code getProtocol() {
        return this.protocol;
    }

    public List<ProtocolContext> getProtocolContext() {
        return this.protocolContext;
    }

    public Attributes toDataset() {
        Attributes attributes = new Attributes();
        this.set((DatasetSource)this.protocol, attributes);
        this.set(this.protocolContext, attributes, 0x400440, DatasetAccessor.Type.Optional);
        return attributes;
    }
}

