/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.dicomobject.module.series;

import com.agfa.pacs.data.shared.code.Code;
import com.agfa.pacs.data.shared.data.AbstractDatasetSource;
import com.agfa.pacs.data.shared.data.DatasetAccessor;
import com.agfa.pacs.data.shared.data.DatasetSource;
import com.agfa.pacs.listtext.dicomobject.general.ReferencedSOP;
import com.agfa.pacs.listtext.dicomobject.module.series.Protocol;
import java.util.ArrayList;
import java.util.List;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.Sequence;

public class RequestAttribute
extends AbstractDatasetSource {
    private String requestedProcedureID;
    private String requestedProcedureReason;
    private String scheduledProcedureStepDescription;
    private Code requestedProcedureReasonCode;
    private String scheduledProcedureStepID;
    private List<Protocol> scheduledProtocol;
    private String studyInstanceUID;
    private String accessionNumber;
    private List<ReferencedSOP> referencedStudies;
    private String requestedProcedureDescription;
    private Code requestedProcedureCode;

    public RequestAttribute() {
        this.scheduledProtocol = new ArrayList<Protocol>();
        this.referencedStudies = new ArrayList<ReferencedSOP>();
    }

    private RequestAttribute(Attributes attributes) {
        this.requestedProcedureID = this.getString(attributes, 0x401001);
        this.studyInstanceUID = this.getString(attributes, 0x20000D);
        this.accessionNumber = this.getString(attributes, 524368);
        this.referencedStudies = ReferencedSOP.createList((Attributes)attributes, (int)528656);
        this.requestedProcedureDescription = this.getString(attributes, 3280992);
        this.requestedProcedureCode = Code.create((Attributes)attributes, (int)3280996);
        this.requestedProcedureReason = this.getString(attributes, 4198402);
        this.requestedProcedureReasonCode = Code.create((Attributes)attributes, (int)4198410);
        this.scheduledProcedureStepID = this.getString(attributes, 0x400009);
        this.scheduledProcedureStepDescription = this.getString(attributes, 0x400007);
        this.scheduledProtocol = Protocol.createList(attributes, 0x400008);
    }

    public static RequestAttribute create(Attributes attributes) {
        if (attributes == null) {
            return null;
        }
        return new RequestAttribute(attributes);
    }

    public static List<RequestAttribute> createList(Attributes attributes, int n) {
        Sequence sequence = attributes.getSequence(n);
        ArrayList<RequestAttribute> arrayList = new ArrayList<RequestAttribute>();
        if (sequence == null) {
            return arrayList;
        }
        int n2 = 0;
        while (n2 < sequence.size()) {
            RequestAttribute requestAttribute = RequestAttribute.create((Attributes)sequence.get(n2));
            if (requestAttribute != null) {
                arrayList.add(requestAttribute);
            }
            ++n2;
        }
        return arrayList;
    }

    public Code getRequestedProcedureReasonCode() {
        return this.requestedProcedureReasonCode;
    }

    public String getRequestedProcedureID() {
        return this.requestedProcedureID;
    }

    public String getRequestedProcedureReason() {
        return this.requestedProcedureReason;
    }

    public String getScheduledProcedureStepDescription() {
        return this.scheduledProcedureStepDescription;
    }

    public String getScheduledProcedureStepID() {
        return this.scheduledProcedureStepID;
    }

    public List<Protocol> scheduledProtocol() {
        return this.scheduledProtocol;
    }

    public void setRequestedProcedureReasonCode(Code code) {
        this.requestedProcedureReasonCode = code;
    }

    public void setRequestedProcedureID(String string) {
        this.requestedProcedureID = string;
    }

    public void setRequestedProcedureReason(String string) {
        this.requestedProcedureReason = string;
    }

    public void setScheduledProcedureStepDescription(String string) {
        this.scheduledProcedureStepDescription = string;
    }

    public void setScheduledProcedureStepID(String string) {
        this.scheduledProcedureStepID = string;
    }

    public String getAccessionNumber() {
        return this.accessionNumber;
    }

    public void setAccessionNumber(String string) {
        this.accessionNumber = string;
    }

    public Code getRequestedProcedureCode() {
        return this.requestedProcedureCode;
    }

    public void setRequestedProcedureCode(Code code) {
        this.requestedProcedureCode = code;
    }

    public String getRequestedProcedureDescription() {
        return this.requestedProcedureDescription;
    }

    public void setRequestedProcedureDescription(String string) {
        this.requestedProcedureDescription = string;
    }

    public String getStudyInstanceUID() {
        return this.studyInstanceUID;
    }

    public void setStudyInstanceUID(String string) {
        this.studyInstanceUID = string;
    }

    public List<ReferencedSOP> referencedStudies() {
        return this.referencedStudies;
    }

    public Attributes toDataset() {
        Attributes attributes = new Attributes();
        this.set(this.requestedProcedureID, attributes, 0x401001, DatasetAccessor.Type.Mandatory);
        this.set(this.requestedProcedureReason, attributes, 4198402, DatasetAccessor.Type.Optional);
        this.set((DatasetSource)this.requestedProcedureReasonCode, attributes, 4198410, DatasetAccessor.Type.Optional);
        this.set(this.scheduledProcedureStepID, attributes, 0x400009, DatasetAccessor.Type.Mandatory);
        this.set(this.scheduledProcedureStepDescription, attributes, 0x400007, DatasetAccessor.Type.Optional);
        this.set(this.scheduledProtocol, attributes, 0x400008, DatasetAccessor.Type.Optional);
        this.set(this.studyInstanceUID, attributes, 0x20000D, DatasetAccessor.Type.Optional);
        this.set(this.accessionNumber, attributes, 524368, DatasetAccessor.Type.Optional);
        this.set(this.referencedStudies, attributes, 528656, DatasetAccessor.Type.Optional);
        this.set(this.requestedProcedureDescription, attributes, 3280992, DatasetAccessor.Type.MandatoryOrEmpty);
        this.set((DatasetSource)this.requestedProcedureCode, attributes, 3280996, DatasetAccessor.Type.Mandatory);
        return attributes;
    }
}

