/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.dicomobject.module.sr;

import com.agfa.pacs.data.shared.code.Code;
import com.agfa.pacs.data.shared.data.DatasetAccessor;
import com.agfa.pacs.data.shared.data.DatasetSource;
import com.agfa.pacs.data.shared.dicom.DicomEnum;
import com.agfa.pacs.data.shared.dicom.Level;
import com.agfa.pacs.listtext.dicomobject.general.ReferencedSOP;
import com.agfa.pacs.listtext.dicomobject.general.SOPInstanceReference;
import com.agfa.pacs.listtext.dicomobject.module.AbstractModule;
import com.agfa.pacs.listtext.dicomobject.module.IModule;
import com.agfa.pacs.listtext.dicomobject.module.general.SOPCommonModule;
import com.agfa.pacs.listtext.dicomobject.module.sr.CustodialOrganization;
import com.agfa.pacs.listtext.dicomobject.module.sr.IdentifiedPersonOrDevice;
import com.agfa.pacs.listtext.dicomobject.module.sr.Participant;
import com.agfa.pacs.listtext.dicomobject.module.sr.ReferencedRequest;
import com.agfa.pacs.listtext.dicomobject.module.sr.VerifyingObserver;
import com.agfa.pacs.listtext.dicomobject.type.CompletionFlag;
import com.agfa.pacs.listtext.dicomobject.type.VerificationFlag;
import java.util.Date;
import java.util.List;
import org.dcm4che3.data.Attributes;

public class SRDocumentGeneralModule
extends AbstractModule {
    private Integer instanceNumber;
    private List<SOPInstanceReference> currentRequestedProcedureEvidences;
    private List<ReferencedRequest> referencedRequests;
    private List<SOPInstanceReference> identicalDocuments;
    private CompletionFlag completionFlag;
    private String completionFlagDescription;
    private VerificationFlag verificationFlag;
    private List<VerifyingObserver> verifyingObserver;
    private List<Participant> participants;
    private CustodialOrganization custodialOrganization;
    private IdentifiedPersonOrDevice authorObserver;
    private List<SOPInstanceReference> predecessorDocuments;
    private List<Code> performedProcedureCodes;
    private List<SOPInstanceReference> pertinentOtherEvidences;
    private ReferencedSOP equivalentCDADocument;
    private Date contentTime;
    private Date contentDate;

    @Override
    public Class<? extends IModule>[] specializationOf() {
        return new Class[]{SOPCommonModule.class};
    }

    public SRDocumentGeneralModule() {
        super(Level.Object);
    }

    @Override
    public boolean isValid() {
        return true;
    }

    @Override
    public boolean containsModule(Attributes attributes) {
        return attributes.contains(2097171) && attributes.contains(524323) && attributes.contains(524339);
    }

    @Override
    public void readFrom(Attributes attributes) {
        this.instanceNumber = this.getInteger(attributes, 2097171);
        this.completionFlag = CompletionFlag.get((String)this.getString(attributes, 4236433));
        this.completionFlagDescription = this.getString(attributes, 4236434);
        this.verificationFlag = VerificationFlag.get((String)this.getString(attributes, 4236435));
        this.contentDate = this.getDate(attributes, 524323);
        this.contentTime = this.getDate(attributes, 524339);
        this.verifyingObserver = VerifyingObserver.createList(attributes, 4235379);
        this.authorObserver = IdentifiedPersonOrDevice.create(attributes, 4235384);
        this.participants = Participant.createList(attributes, 4235386);
        this.custodialOrganization = CustodialOrganization.create(attributes.getNestedDataset(4235388));
        this.predecessorDocuments = SOPInstanceReference.createList((Attributes)attributes, (int)4236128);
        this.identicalDocuments = SOPInstanceReference.createList((Attributes)attributes, (int)4236581);
        this.referencedRequests = ReferencedRequest.createList(attributes, 4236144);
        this.performedProcedureCodes = Code.createList((Attributes)attributes, (int)4236146);
        this.currentRequestedProcedureEvidences = SOPInstanceReference.createList((Attributes)attributes, (int)4236149);
        this.pertinentOtherEvidences = SOPInstanceReference.createList((Attributes)attributes, (int)4236165);
        this.equivalentCDADocument = ReferencedSOP.create((Attributes)attributes.getNestedDataset(4235408));
    }

    @Override
    public void writeTo(Attributes attributes) {
        this.set(this.instanceNumber, attributes, 2097171, DatasetAccessor.Type.Mandatory);
        this.set((DicomEnum)this.completionFlag, attributes, 4236433, DatasetAccessor.Type.Mandatory);
        this.set(this.completionFlagDescription, attributes, 4236434, DatasetAccessor.Type.Optional);
        this.set((DicomEnum)this.verificationFlag, attributes, 4236435, DatasetAccessor.Type.Mandatory);
        this.set(this.contentDate, attributes, 524323, DatasetAccessor.Type.Mandatory);
        this.set(this.contentTime, attributes, 524339, DatasetAccessor.Type.Mandatory);
        this.set(this.verifyingObserver, attributes, 4235379, DatasetAccessor.Type.ConditionalMandatory);
        this.set((DatasetSource)this.authorObserver, attributes, 4235384, DatasetAccessor.Type.Optional);
        this.set(this.participants, attributes, 4235386, DatasetAccessor.Type.Optional);
        this.set((DatasetSource)this.custodialOrganization, attributes, 4235388, DatasetAccessor.Type.Optional);
        this.set(this.predecessorDocuments, attributes, 4236128, DatasetAccessor.Type.ConditionalMandatory);
        this.set(this.identicalDocuments, attributes, 4236581, DatasetAccessor.Type.ConditionalMandatory);
        this.set(this.referencedRequests, attributes, 4236144, DatasetAccessor.Type.ConditionalMandatory);
        this.set(this.performedProcedureCodes, attributes, 4236146, DatasetAccessor.Type.MandatoryOrEmpty);
        this.set(this.currentRequestedProcedureEvidences, attributes, 4236149, DatasetAccessor.Type.ConditionalMandatory);
        this.set(this.pertinentOtherEvidences, attributes, 4236165, DatasetAccessor.Type.ConditionalMandatory);
        this.set((DatasetSource)this.equivalentCDADocument, attributes, 4235408, DatasetAccessor.Type.ConditionalMandatory);
    }

    public List<SOPInstanceReference> currentRequestedProcedureEvidences() {
        return this.currentRequestedProcedureEvidences;
    }

    public List<SOPInstanceReference> identicalDocuments() {
        return this.identicalDocuments;
    }

    public Integer getInstanceNumber() {
        return this.instanceNumber;
    }

    public List<ReferencedRequest> referencedRequests() {
        return this.referencedRequests;
    }

    public void setInstanceNumber(Integer n) {
        this.instanceNumber = n;
    }

    public CompletionFlag getCompletionFlag() {
        return this.completionFlag;
    }

    public void setCompletionFlag(CompletionFlag completionFlag) {
        this.completionFlag = completionFlag;
    }

    public String getCompletionFlagDescription() {
        return this.completionFlagDescription;
    }

    public void setCompletionFlagDescription(String string) {
        this.completionFlagDescription = string;
    }

    public VerificationFlag getVerificationFlag() {
        return this.verificationFlag;
    }

    public void setVerificationFlag(VerificationFlag verificationFlag) {
        this.verificationFlag = verificationFlag;
    }

    public IdentifiedPersonOrDevice getAuthorObserver() {
        return this.authorObserver;
    }

    public void setAuthorObserver(IdentifiedPersonOrDevice identifiedPersonOrDevice) {
        this.authorObserver = identifiedPersonOrDevice;
    }

    public CustodialOrganization getCustodialOrganization() {
        return this.custodialOrganization;
    }

    public void setCustodialOrganization(CustodialOrganization custodialOrganization) {
        this.custodialOrganization = custodialOrganization;
    }

    public void setEquivalentCDADocument(ReferencedSOP referencedSOP) {
        this.equivalentCDADocument = referencedSOP;
    }

    public ReferencedSOP getEquivalentCDADocument() {
        return this.equivalentCDADocument;
    }

    public List<Participant> participants() {
        return this.participants;
    }

    public List<Code> performedProcedureCodes() {
        return this.performedProcedureCodes;
    }

    public List<SOPInstanceReference> pertinentOtherEvidences() {
        return this.pertinentOtherEvidences;
    }

    public List<SOPInstanceReference> predecessorDocuments() {
        return this.predecessorDocuments;
    }

    public List<VerifyingObserver> verifyingObserver() {
        return this.verifyingObserver;
    }

    public Date getContentTime() {
        return this.contentTime;
    }

    public void setContentTime(Date date) {
        this.contentTime = date;
    }

    public Date getContentDate() {
        return this.contentDate;
    }

    public void setContentDate(Date date) {
        this.contentDate = date;
    }
}

