/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.dicomobject.sr.content;

import com.agfa.pacs.data.shared.code.Code;
import com.agfa.pacs.data.shared.data.AbstractDatasetSource;
import com.agfa.pacs.data.shared.data.DatasetAccessor;
import com.agfa.pacs.data.shared.data.DatasetSource;
import com.agfa.pacs.data.shared.dicom.DicomEnum;
import com.agfa.pacs.listtext.dicomobject.general.ReferencedSOP;
import com.agfa.pacs.listtext.dicomobject.general.ReferencedWaveform;
import com.agfa.pacs.listtext.dicomobject.sr.content.ContentTemplate;
import com.agfa.pacs.listtext.dicomobject.sr.content.SRReferencedImage;
import com.agfa.pacs.listtext.dicomobject.type.ContinuityOfContent;
import com.agfa.pacs.listtext.dicomobject.type.GraphicType;
import com.agfa.pacs.listtext.dicomobject.type.TemporalRangeType;
import com.agfa.pacs.listtext.dicomobject.type.ValueType;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.Sequence;

public abstract class DocumentContent
extends AbstractDatasetSource {
    private Code conceptName;
    private ValueType valueType;

    private DocumentContent(ValueType valueType) {
        this.valueType = valueType;
    }

    private DocumentContent(ValueType valueType, Code code) {
        this(valueType);
        this.conceptName = code;
    }

    private DocumentContent(Attributes attributes) {
        this.conceptName = Code.create((Attributes)attributes, (int)4235331);
        this.valueType = ValueType.get((String)this.getString(attributes, 0x40A040));
    }

    public static DocumentContent create(Attributes attributes) {
        if (attributes == null) {
            return null;
        }
        if (attributes.contains(0x40A040)) {
            String string = attributes.getString(0x40A040);
            if ("TEXT".equals(string)) {
                return new TextContent(attributes);
            }
            if ("NUM".equals(string)) {
                return new NumericContent(attributes);
            }
            if ("CODE".equals(string)) {
                return new CodeContent(attributes);
            }
            if ("DATETIME".equals(string)) {
                return new DateTimeContent(attributes);
            }
            if ("DATE".equals(string)) {
                return new DateContent(attributes);
            }
            if ("TIME".equals(string)) {
                return new TimeContent(attributes);
            }
            if ("UIDREF".equals(string)) {
                return new UIDReferenceContent(attributes);
            }
            if ("PNAME".equals(string)) {
                return new PersonNameContent(attributes);
            }
            if ("COMPOSITE".equals(string)) {
                return new CompositeContent(attributes);
            }
            if ("IMAGE".equals(string)) {
                return new ImageContent(attributes);
            }
            if ("WAVEFORM".equals(string)) {
                return new WaveformContent(attributes);
            }
            if ("SCOORD".equals(string)) {
                return new SpatialCoordContent(attributes);
            }
            if ("TCOORD".equals(string)) {
                return new TemporalCoordContent(attributes);
            }
            if ("CONTAINER".equals(string)) {
                return new ContainerContent(attributes);
            }
        }
        return null;
    }

    public static DocumentContent create(ValueType valueType) {
        switch (valueType) {
            case Text: {
                return new TextContent();
            }
            case Numeric: {
                return new NumericContent();
            }
            case Code: {
                return new CodeContent();
            }
            case DateTime: {
                return new DateTimeContent();
            }
            case Date: {
                return new DateContent();
            }
            case Time: {
                return new TimeContent();
            }
            case UIDReference: {
                return new UIDReferenceContent();
            }
            case PersonName: {
                return new PersonNameContent();
            }
            case Composite: {
                return new CompositeContent();
            }
            case Image: {
                return new ImageContent();
            }
            case Waveform: {
                return new WaveformContent();
            }
            case SpatialCoord: {
                return new SpatialCoordContent();
            }
            case TemporalCoord: {
                return new TemporalCoordContent();
            }
            case Container: {
                return new ContainerContent();
            }
        }
        return null;
    }

    public static List<DocumentContent> createList(Attributes attributes, int n) {
        ArrayList<DocumentContent> arrayList = new ArrayList<DocumentContent>();
        Sequence sequence = attributes.getSequence(n);
        if (sequence != null) {
            int n2 = 0;
            while (n2 < sequence.size()) {
                DocumentContent documentContent = DocumentContent.create((Attributes)sequence.get(n2));
                if (documentContent != null) {
                    arrayList.add(documentContent);
                }
                ++n2;
            }
        }
        return arrayList;
    }

    public ValueType getValueType() {
        return this.valueType;
    }

    public Code getConceptName() {
        return this.conceptName;
    }

    public void setConceptName(Code code) {
        this.conceptName = code;
    }

    public String toString() {
        if (this.conceptName == null) {
            return this.valueType.toString();
        }
        return String.valueOf(this.conceptName.toString()) + " (" + this.valueType.toString() + ")";
    }

    public Attributes toDataset() {
        Attributes attributes = new Attributes();
        this.set((DatasetSource)this.conceptName, attributes, 4235331, DatasetAccessor.Type.ConditionalMandatory);
        this.set((DicomEnum)this.valueType, attributes, 0x40A040, DatasetAccessor.Type.Mandatory);
        return attributes;
    }

    /* synthetic */ DocumentContent(ValueType valueType, DocumentContent documentContent) {
        this(valueType);
    }

    /* synthetic */ DocumentContent(ValueType valueType, Code code, DocumentContent documentContent) {
        this(valueType, code);
    }

    /* synthetic */ DocumentContent(Attributes attributes, DocumentContent documentContent) {
        this(attributes);
    }

    public static class CodeContent
    extends DocumentContent {
        private Code concept;

        public CodeContent() {
            super(ValueType.Code, (DocumentContent)null);
        }

        public CodeContent(Code code, Code code2) {
            super(ValueType.Code, code, null);
            this.concept = code2;
        }

        public CodeContent(Attributes attributes) {
            super(attributes, null);
            this.concept = Code.create((Attributes)attributes, (int)4235624);
        }

        public Code getConcept() {
            return this.concept;
        }

        public void setConcept(Code code) {
            this.concept = code;
        }

        @Override
        public Attributes toDataset() {
            Attributes attributes = super.toDataset();
            this.set((DatasetSource)this.concept, attributes, 4235624, DatasetAccessor.Type.Mandatory);
            return attributes;
        }
    }

    public static class CompositeContent
    extends DocumentContent {
        private ReferencedSOP referencedSOP;

        public CompositeContent() {
            super(ValueType.Composite, (DocumentContent)null);
        }

        public CompositeContent(ReferencedSOP referencedSOP) {
            super(ValueType.Composite, (DocumentContent)null);
            this.referencedSOP = referencedSOP;
        }

        public CompositeContent(Attributes attributes) {
            super(attributes, null);
            this.referencedSOP = ReferencedSOP.create((Attributes)attributes.getNestedDataset(528793));
        }

        public ReferencedSOP getReferencedSOP() {
            return this.referencedSOP;
        }

        public void setReferencedSOP(ReferencedSOP referencedSOP) {
            this.referencedSOP = referencedSOP;
        }

        @Override
        public Attributes toDataset() {
            Attributes attributes = super.toDataset();
            this.set((DatasetSource)this.referencedSOP, attributes, 528793, DatasetAccessor.Type.Mandatory);
            return attributes;
        }
    }

    public static class ContainerContent
    extends DocumentContent {
        private ContinuityOfContent continuityOfContent;
        private ContentTemplate contentTemplate;

        public ContainerContent() {
            super(ValueType.Container, (DocumentContent)null);
        }

        public ContainerContent(Code code, ContinuityOfContent continuityOfContent) {
            super(ValueType.Container, code, null);
            this.continuityOfContent = continuityOfContent;
        }

        public ContainerContent(Attributes attributes) {
            super(attributes, null);
            this.continuityOfContent = ContinuityOfContent.get((String)this.getString(attributes, 4235344));
            this.contentTemplate = ContentTemplate.create(attributes.getNestedDataset(4236548));
        }

        public ContinuityOfContent getContinuityOfContent() {
            return this.continuityOfContent;
        }

        public ContentTemplate getContentTemplate() {
            return this.contentTemplate;
        }

        public void setContentTemplate(ContentTemplate contentTemplate) {
            this.contentTemplate = contentTemplate;
        }

        public void setContinuityOfContent(ContinuityOfContent continuityOfContent) {
            this.continuityOfContent = continuityOfContent;
        }

        @Override
        public Attributes toDataset() {
            Attributes attributes = super.toDataset();
            this.set((DicomEnum)this.continuityOfContent, attributes, 4235344, DatasetAccessor.Type.Mandatory);
            this.set((DatasetSource)this.contentTemplate, attributes, 4236548, DatasetAccessor.Type.ConditionalMandatory);
            return attributes;
        }
    }

    public static class DateContent
    extends DocumentContent {
        private Date date;

        public DateContent() {
            super(ValueType.Date, (DocumentContent)null);
        }

        public DateContent(Code code, Date date) {
            super(ValueType.Date, code, null);
            this.date = date;
        }

        public DateContent(Attributes attributes) {
            super(attributes, null);
            this.date = this.getDate(attributes, 4235553);
        }

        public Date getDate() {
            return this.date;
        }

        public void setDate(Date date) {
            this.date = date;
        }

        @Override
        public Attributes toDataset() {
            Attributes attributes = super.toDataset();
            this.set(this.date, attributes, 4235553, DatasetAccessor.Type.Mandatory);
            return attributes;
        }
    }

    public static class DateTimeContent
    extends DocumentContent {
        private Date dateTime;

        public DateTimeContent() {
            super(ValueType.DateTime, (DocumentContent)null);
        }

        public DateTimeContent(Code code, Date date) {
            super(ValueType.DateTime, code, null);
            this.dateTime = date;
        }

        public DateTimeContent(Attributes attributes) {
            super(attributes, null);
            this.dateTime = this.getDate(attributes, 4235552);
        }

        public Date getDateTime() {
            return this.dateTime;
        }

        public void setDateTime(Date date) {
            this.dateTime = date;
        }

        @Override
        public Attributes toDataset() {
            Attributes attributes = super.toDataset();
            this.set(this.dateTime, attributes, 4235552, DatasetAccessor.Type.Mandatory);
            return attributes;
        }
    }

    public static class ImageContent
    extends DocumentContent {
        private SRReferencedImage referencedImage;

        public ImageContent() {
            super(ValueType.Image, (DocumentContent)null);
        }

        public ImageContent(SRReferencedImage sRReferencedImage) {
            super(ValueType.Image, (DocumentContent)null);
            this.referencedImage = sRReferencedImage;
        }

        public ImageContent(Attributes attributes) {
            super(attributes, null);
            this.referencedImage = SRReferencedImage.create(attributes.getNestedDataset(528793));
        }

        public SRReferencedImage getReferencedImage() {
            return this.referencedImage;
        }

        public void setReferencedImage(SRReferencedImage sRReferencedImage) {
            this.referencedImage = sRReferencedImage;
        }

        @Override
        public Attributes toDataset() {
            Attributes attributes = super.toDataset();
            this.set((DatasetSource)this.referencedImage, attributes, 528793, DatasetAccessor.Type.Mandatory);
            return attributes;
        }
    }

    public static class NumericContent
    extends DocumentContent {
        private MeasuredValue measuredValue;
        private Code numericValueQualifier;

        public NumericContent() {
            super(ValueType.Numeric, (DocumentContent)null);
        }

        public NumericContent(Code code, MeasuredValue measuredValue, Code code2) {
            super(ValueType.Numeric, code, null);
            this.measuredValue = measuredValue;
            this.numericValueQualifier = code2;
        }

        public NumericContent(Attributes attributes) {
            super(attributes, null);
            this.measuredValue = MeasuredValue.create(attributes.getNestedDataset(4236032));
            this.numericValueQualifier = Code.create((Attributes)attributes, (int)4236033);
        }

        public MeasuredValue getMeasuredValue() {
            return this.measuredValue;
        }

        public Code getNumericValueQualifier() {
            return this.numericValueQualifier;
        }

        public void setMeasuredValue(MeasuredValue measuredValue) {
            this.measuredValue = measuredValue;
        }

        public void setNumericValueQualifier(Code code) {
            this.numericValueQualifier = code;
        }

        @Override
        public Attributes toDataset() {
            Attributes attributes = super.toDataset();
            this.set((DatasetSource)this.measuredValue, attributes, 4236032, DatasetAccessor.Type.MandatoryOrEmpty);
            this.set((DatasetSource)this.numericValueQualifier, attributes, 4236033, DatasetAccessor.Type.Optional);
            return attributes;
        }

        public static class MeasuredValue
        extends AbstractDatasetSource {
            private String[] numericValue;
            private Code measurementUnits;

            public MeasuredValue() {
            }

            public MeasuredValue(Attributes attributes) {
                this.numericValue = this.getStrings(attributes, 4236042);
                this.measurementUnits = Code.create((Attributes)attributes, (int)4196586);
            }

            public static MeasuredValue create(Attributes attributes) {
                if (attributes == null) {
                    return null;
                }
                if (attributes.contains(4236042) && attributes.contains(4196586)) {
                    return new MeasuredValue(attributes);
                }
                return null;
            }

            public double[] getNumericValue() {
                double[] dArray = new double[this.numericValue.length];
                int n = 0;
                while (n < dArray.length) {
                    dArray[n] = Double.parseDouble(this.numericValue[n]);
                    ++n;
                }
                return dArray;
            }

            public Code getMeasurementUnits() {
                return this.measurementUnits;
            }

            public void setMeasurementUnits(Code code) {
                this.measurementUnits = code;
            }

            public void setNumericValue(String[] stringArray) {
                this.numericValue = stringArray;
            }

            public Attributes toDataset() {
                Attributes attributes = new Attributes();
                this.set(this.numericValue, attributes, 4236042, DatasetAccessor.Type.Mandatory);
                this.set((DatasetSource)this.measurementUnits, attributes, 4196586, DatasetAccessor.Type.Mandatory);
                return attributes;
            }
        }
    }

    public static class PersonNameContent
    extends DocumentContent {
        private String personName;

        public PersonNameContent() {
            super(ValueType.PersonName, (DocumentContent)null);
        }

        public PersonNameContent(Code code, String string) {
            super(ValueType.PersonName, code, null);
            this.personName = string;
        }

        public PersonNameContent(Attributes attributes) {
            super(attributes, null);
            this.personName = this.getString(attributes, 4235555);
        }

        public String getPersonName() {
            return this.personName;
        }

        public void setPersonName(String string) {
            this.personName = string;
        }

        @Override
        public Attributes toDataset() {
            Attributes attributes = super.toDataset();
            this.set(this.personName, attributes, 4235555, DatasetAccessor.Type.Mandatory);
            return attributes;
        }
    }

    public static class SpatialCoordContent
    extends DocumentContent {
        private float[] graphicData;
        private GraphicType graphicType;

        public SpatialCoordContent() {
            super(ValueType.SpatialCoord, (DocumentContent)null);
        }

        public SpatialCoordContent(Code code, float[] fArray, GraphicType graphicType) {
            super(ValueType.SpatialCoord, code, null);
            this.graphicData = fArray;
            this.graphicType = graphicType;
        }

        public SpatialCoordContent(Attributes attributes) {
            super(attributes, null);
            this.graphicData = this.getFloats(attributes, 0x700022);
            this.graphicType = GraphicType.get((String)this.getString(attributes, 7340067));
        }

        public float[] getGraphicData() {
            return this.graphicData;
        }

        public GraphicType getGraphicType() {
            return this.graphicType;
        }

        public void setGraphicData(float[] fArray) {
            this.graphicData = fArray;
        }

        public void setGraphicType(GraphicType graphicType) {
            this.graphicType = graphicType;
        }

        @Override
        public Attributes toDataset() {
            Attributes attributes = super.toDataset();
            this.set(this.graphicData, attributes, 0x700022, DatasetAccessor.Type.Mandatory);
            this.set((DicomEnum)this.graphicType, attributes, 7340067, DatasetAccessor.Type.Mandatory);
            return attributes;
        }
    }

    public static class TemporalCoordContent
    extends DocumentContent {
        private TemporalRangeType temporalRangeType;
        private int[] samplePositions;
        private String[] timeOffsets;
        private Date[] dateTime;

        public TemporalCoordContent() {
            super(ValueType.TemporalCoord, (DocumentContent)null);
        }

        public TemporalCoordContent(Code code, TemporalRangeType temporalRangeType, int[] nArray, String[] stringArray, Date[] dateArray) {
            super(ValueType.TemporalCoord, code, null);
            this.temporalRangeType = temporalRangeType;
            this.samplePositions = nArray;
            this.timeOffsets = stringArray;
            this.dateTime = dateArray;
        }

        public TemporalCoordContent(Attributes attributes) {
            super(attributes, null);
            this.temporalRangeType = TemporalRangeType.get((String)this.getString(attributes, 4235568));
            this.samplePositions = this.getIntegers(attributes, 4235570);
            this.timeOffsets = this.getStrings(attributes, 4235576);
            this.dateTime = this.getDates(attributes, 4235578);
        }

        public Date[] getDateTime() {
            return this.dateTime;
        }

        public int[] getSamplePositions() {
            return this.samplePositions;
        }

        public TemporalRangeType getTemporalRangeType() {
            return this.temporalRangeType;
        }

        public double[] getTimeOffsets() {
            double[] dArray = new double[this.timeOffsets.length];
            int n = 0;
            while (n < dArray.length) {
                dArray[n] = Double.parseDouble(this.timeOffsets[n]);
                ++n;
            }
            return dArray;
        }

        public void setDateTime(Date[] dateArray) {
            this.dateTime = dateArray;
        }

        public void setSamplePositions(int[] nArray) {
            this.samplePositions = nArray;
        }

        public void setTemporalRangeType(TemporalRangeType temporalRangeType) {
            this.temporalRangeType = temporalRangeType;
        }

        public void setTimeOffsets(String[] stringArray) {
            this.timeOffsets = stringArray;
        }

        @Override
        public Attributes toDataset() {
            Attributes attributes = super.toDataset();
            this.set((DicomEnum)this.temporalRangeType, attributes, 4235568, DatasetAccessor.Type.Mandatory);
            this.set(this.samplePositions, attributes, 4235570, DatasetAccessor.Type.ConditionalMandatory);
            this.set(this.timeOffsets, attributes, 4235576, DatasetAccessor.Type.ConditionalMandatory);
            this.set(this.dateTime, attributes, 4235578, DatasetAccessor.Type.ConditionalMandatory);
            return attributes;
        }
    }

    public static class TextContent
    extends DocumentContent {
        private String textValue;

        public TextContent() {
            super(ValueType.Text, (DocumentContent)null);
        }

        public TextContent(Code code, String string) {
            super(ValueType.Text, code, null);
            this.textValue = string;
        }

        public TextContent(Attributes attributes) {
            super(attributes, null);
            this.textValue = this.getString(attributes, 4235616);
        }

        public String getTextValue() {
            return this.textValue;
        }

        public void setTextValue(String string) {
            this.textValue = string;
        }

        @Override
        public Attributes toDataset() {
            Attributes attributes = super.toDataset();
            this.set(this.textValue, attributes, 4235616, DatasetAccessor.Type.Mandatory);
            return attributes;
        }
    }

    public static class TimeContent
    extends DocumentContent {
        private Date time;

        public TimeContent() {
            super(ValueType.Time, (DocumentContent)null);
        }

        public TimeContent(Code code, Date date) {
            super(ValueType.Time, code, null);
            this.time = date;
        }

        public TimeContent(Attributes attributes) {
            super(attributes, null);
            this.time = this.getDate(attributes, 4235554);
        }

        public Date getTime() {
            return this.time;
        }

        public void setTime(Date date) {
            this.time = date;
        }

        @Override
        public Attributes toDataset() {
            Attributes attributes = super.toDataset();
            this.set(this.time, attributes, 4235554, DatasetAccessor.Type.Mandatory);
            return attributes;
        }
    }

    public static class UIDReferenceContent
    extends DocumentContent {
        private String uid;

        public UIDReferenceContent() {
            super(ValueType.UIDReference, (DocumentContent)null);
        }

        public UIDReferenceContent(Code code, String string) {
            super(ValueType.UIDReference, code, null);
            this.uid = string;
        }

        public UIDReferenceContent(Attributes attributes) {
            super(attributes, null);
            this.uid = this.getString(attributes, 4235556);
        }

        public String getUID() {
            return this.uid;
        }

        public void setUID(String string) {
            this.uid = string;
        }

        @Override
        public Attributes toDataset() {
            Attributes attributes = super.toDataset();
            this.set(this.uid, attributes, 4235556, DatasetAccessor.Type.Mandatory);
            return attributes;
        }
    }

    public static class WaveformContent
    extends DocumentContent {
        private ReferencedWaveform referencedWaveform;

        public WaveformContent() {
            super(ValueType.Waveform, (DocumentContent)null);
        }

        public WaveformContent(ReferencedWaveform referencedWaveform) {
            super(ValueType.Waveform, (DocumentContent)null);
            this.referencedWaveform = referencedWaveform;
        }

        public WaveformContent(Code code, ReferencedWaveform referencedWaveform) {
            super(ValueType.Waveform, code, null);
            this.referencedWaveform = referencedWaveform;
        }

        public WaveformContent(Attributes attributes) {
            super(attributes, null);
            this.referencedWaveform = ReferencedWaveform.create((Attributes)attributes.getNestedDataset(528793));
        }

        public ReferencedWaveform getReferencedWaveform() {
            return this.referencedWaveform;
        }

        public void setReferencedWaveform(ReferencedWaveform referencedWaveform) {
            this.referencedWaveform = referencedWaveform;
        }

        @Override
        public Attributes toDataset() {
            Attributes attributes = super.toDataset();
            this.set((DatasetSource)this.referencedWaveform, attributes, 528793, DatasetAccessor.Type.Mandatory);
            return attributes;
        }
    }
}

