/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.dicomobject.type;

import com.agfa.pacs.data.shared.dicom.DicomEnum;
import com.agfa.pacs.tools.Pattern;
import java.util.EnumSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;

public enum ImageType implements DicomEnum
{
    ORIGINAL,
    PRIMARY,
    DERIVED,
    SECONDARY,
    LOCALIZER,
    PERFUSION,
    OTHER,
    ROI_ANALYSIS("ROI_ANALYSIS"),
    REFORMATION,
    SCOUT,
    REFORMATED,
    REFORMATTED,
    MPR,
    ADC,
    EADC,
    RECON_TOMO,
    RECON_GATED_TOMO,
    RECON_TOMO_GATED,
    TOMO,
    EXAM_PROTOCOL,
    STATIC,
    DYNAMIC,
    GATED,
    WHOLE_BODY,
    GATED_TOMO,
    SCM;

    private final String dicom;

    private ImageType() {
        this(null);
    }

    private ImageType(String string2) {
        this.dicom = string2 == null ? Pattern.UNDERSCORE.matcher(this.name()).replaceAll(" ") : string2;
    }

    private static ImageType get(String string) {
        if (string == null) {
            return null;
        }
        try {
            return ImageType.valueOf(Pattern.SPACE.matcher(string.toUpperCase(Locale.ENGLISH)).replaceAll("_"));
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static Set<ImageType> get(String[] stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            return EnumSet.noneOf(ImageType.class);
        }
        EnumSet<ImageType> enumSet = EnumSet.noneOf(ImageType.class);
        String[] stringArray2 = stringArray;
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray2[n2];
            ImageType imageType = ImageType.get(string);
            if (imageType != null) {
                enumSet.add(imageType);
            }
            ++n2;
        }
        return enumSet;
    }

    public static String[] getDerivedSecondary(ImageType ... imageTypeArray) {
        String[] stringArray = new String[imageTypeArray.length + 2];
        stringArray[0] = DERIVED.dicom();
        stringArray[1] = SECONDARY.dicom();
        int n = 0;
        while (n < imageTypeArray.length) {
            stringArray[n + 2] = imageTypeArray[n].dicom();
            ++n;
        }
        return stringArray;
    }

    public static String[] toStringArray(List<ImageType> list) {
        String[] stringArray = new String[list.size()];
        int n = 0;
        while (n < stringArray.length) {
            stringArray[n] = list.get(n).dicom();
            ++n;
        }
        return stringArray;
    }

    public String dicom() {
        return this.dicom;
    }
}

