/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.dicomobject.type;

import com.agfa.pacs.data.shared.dicom.DicomEnum;
import java.util.Locale;

public enum TianiSubType implements DicomEnum
{
    Marker("MARKER"),
    MarkerLeft("MARKER_LEFT"),
    MarkerRight("MARKER_RIGHT"),
    Length("LENGTH"),
    NormalDistance("NORMAL_DISTANCE", 2),
    BidimensionalLength("BIDIMENSIONAL_LENGTH", 2),
    HorizontalDistance("HORIZONTAL_DISTANCE", 3),
    Centerline("CENTERLINE", 5),
    DoubleCenterline("DOUBLE_CENTERLINE", 10),
    Arrow("ARROW"),
    Angle("ANGLE", 2),
    CobbAngle("COBB", 3),
    Ratio("RATIO", 2),
    Rectangle("RECTANGLE"),
    MagneticContour("MAGNETIC_CONTOUR");

    private final String dicomId;
    private final int partCount;

    private TianiSubType(String string2) {
        this(string2, 1);
    }

    private TianiSubType(String string2, int n2) {
        this.dicomId = string2;
        this.partCount = n2;
    }

    public String dicom() {
        return this.dicomId;
    }

    public int getPartCount() {
        return this.partCount;
    }

    public static TianiSubType get(String string) {
        if (string == null) {
            return null;
        }
        string = string.toUpperCase(Locale.ENGLISH).trim();
        TianiSubType[] tianiSubTypeArray = TianiSubType.values();
        int n = tianiSubTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            TianiSubType tianiSubType = tianiSubTypeArray[n2];
            if (tianiSubType.dicom().equals(string)) {
                return tianiSubType;
            }
            ++n2;
        }
        return null;
    }
}

