/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.clinicalcode.acr.node;

import com.agfa.pacs.listtext.clinicalcode.IClinicalCodeNode;
import com.agfa.pacs.listtext.clinicalcode.acr.ACRCode;
import com.agfa.pacs.listtext.clinicalcode.acr.ACRNode;
import com.agfa.pacs.listtext.clinicalcode.acr.code.ACRCodeFactory;
import com.agfa.pacs.listtext.clinicalcode.acr.code.CompositeACRCode;
import com.agfa.pacs.listtext.clinicalcode.acr.node.ACRNodeFactory;
import com.agfa.pacs.listtext.clinicalcode.acr.node.ACRPathologyNode;
import com.agfa.pacs.listtext.clinicalcode.acr.node.AbstractACRNode;

public class ACRAnatomyNode
extends AbstractACRNode {
    public ACRAnatomyNode(ACRCode aCRCode) {
        super(aCRCode);
    }

    @Override
    public boolean hasBranches() {
        return true;
    }

    @Override
    public int getBranchCount() {
        return 1;
    }

    @Override
    public IClinicalCodeNode[] getBranches() {
        IClinicalCodeNode[] iClinicalCodeNodeArray;
        ACRPathologyNode aCRPathologyNode = this.getPathologyBranch();
        if (aCRPathologyNode != null) {
            IClinicalCodeNode[] iClinicalCodeNodeArray2 = new IClinicalCodeNode[1];
            iClinicalCodeNodeArray = iClinicalCodeNodeArray2;
            iClinicalCodeNodeArray2[0] = aCRPathologyNode;
        } else {
            iClinicalCodeNodeArray = new IClinicalCodeNode[]{};
        }
        return iClinicalCodeNodeArray;
    }

    public ACRAnatomyNode[] getAnatomyChildren() {
        return (ACRAnatomyNode[])super.getChildren();
    }

    public ACRPathologyNode getPathologyBranch() {
        return this.createPathologyBranch();
    }

    public void addChild(ACRAnatomyNode aCRAnatomyNode) {
        String string = aCRAnatomyNode.getCode().getId();
        ACRAnatomyNode aCRAnatomyNode2 = null;
        if (string.length() == 1 && this.isRootNode()) {
            aCRAnatomyNode2 = this;
        } else {
            String string2 = string.substring(0, string.length() - 1);
            ACRCode aCRCode = ACRCodeFactory.createAnatomyInstance(string2, null);
            aCRAnatomyNode2 = (ACRAnatomyNode)this.findNodeForCode(aCRCode);
        }
        if (aCRAnatomyNode2 != null) {
            aCRAnatomyNode2.node.add(aCRAnatomyNode.getAsNode());
        }
    }

    @Override
    public ACRNode findNodeForCode(ACRCode aCRCode) {
        ACRCode aCRCode2;
        ACRCode aCRCode3 = aCRCode2 = aCRCode.isCompositeCode() ? ((CompositeACRCode)aCRCode).getAnatomyCode() : aCRCode;
        if (this.code.equals(aCRCode2)) {
            return this;
        }
        ACRNode[] aCRNodeArray = this.getChildren();
        int n = aCRNodeArray.length;
        int n2 = 0;
        while (n2 < n) {
            ACRNode aCRNode = aCRNodeArray[n2];
            ACRNode aCRNode2 = aCRNode.findNodeForCode(aCRCode);
            if (aCRNode2 != null) {
                if (aCRNode2 instanceof ACRAnatomyNode && aCRCode.isCompositeCode()) {
                    ACRCode aCRCode4 = ((CompositeACRCode)aCRCode).getPathologyCode();
                    return ((ACRAnatomyNode)aCRNode2).getPathologyBranch().findNodeForCode(aCRCode4);
                }
                return aCRNode2;
            }
            ++n2;
        }
        return null;
    }

    private ACRPathologyNode createPathologyBranch() {
        return ACRNodeFactory.createPathologyRoot(this);
    }
}

