/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.clinicalcode.acr.ui;

import com.agfa.pacs.listtext.clinicalcode.IClinicalCode;
import com.agfa.pacs.listtext.clinicalcode.IClinicalCodeScheme;
import com.agfa.pacs.listtext.clinicalcode.IClinicalCodeSchemeUI;
import com.agfa.pacs.listtext.clinicalcode.IClinicalCodeSchemeUIListener;
import com.agfa.pacs.listtext.clinicalcode.acr.ACRClinicalCodeScheme;
import com.agfa.pacs.listtext.clinicalcode.acr.ACRCode;
import com.agfa.pacs.listtext.clinicalcode.acr.ACRNode;
import com.agfa.pacs.listtext.clinicalcode.acr.node.ACRAnatomyNode;
import com.agfa.pacs.listtext.clinicalcode.acr.node.ACRNodeFactory;
import com.agfa.pacs.listtext.clinicalcode.acr.node.ACRPathologyNode;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class ACRClinicalCodeSchemeUI
implements IClinicalCodeSchemeUI {
    private ACRCodeView view;
    private JSplitPane splitPane;
    private JScrollPane anatomyScp;
    private JScrollPane pathologyScp;
    private JTree anatomyTree;
    private JTree pathologyTree;
    private ACRClinicalCodeScheme scheme;
    private TreeSelectionListener treeSelectionListener;
    private List<IClinicalCodeSchemeUIListener> listener = new ArrayList<IClinicalCodeSchemeUIListener>();

    public ACRClinicalCodeSchemeUI(ACRClinicalCodeScheme aCRClinicalCodeScheme) {
        this.treeSelectionListener = new DefaultTreeSelectionListener();
        this.scheme = aCRClinicalCodeScheme != null ? aCRClinicalCodeScheme : new ACRClinicalCodeScheme();
        this.createComponents();
        this.initComponents();
        this.installLayout();
        this.installListeners();
    }

    public ACRClinicalCodeSchemeUI() {
        this(null);
    }

    @Override
    public Component getAWTRootComponent() {
        return this.view;
    }

    @Override
    public IClinicalCodeScheme getCodeScheme() {
        return this.scheme;
    }

    @Override
    public boolean isMultiCodeSelectionSupported() {
        return false;
    }

    @Override
    public List<IClinicalCode> getSelectedCodes() {
        ACRNode aCRNode = (ACRNode)((DefaultMutableTreeNode)this.anatomyTree.getSelectionPath().getLastPathComponent()).getUserObject();
        ACRNode aCRNode2 = (ACRNode)((DefaultMutableTreeNode)this.pathologyTree.getSelectionPath().getLastPathComponent()).getUserObject();
        if (aCRNode2 != null || aCRNode != null) {
            return Arrays.asList(aCRNode2 != null ? aCRNode2.getCode() : aCRNode.getCode());
        }
        return new ArrayList<IClinicalCode>(0);
    }

    @Override
    public void setSelectedCodes(List<IClinicalCode> list) {
        this.anatomyTree.getSelectionModel().removeTreeSelectionListener(this.treeSelectionListener);
        this.pathologyTree.getSelectionModel().removeTreeSelectionListener(this.treeSelectionListener);
        this.anatomyTree.clearSelection();
        this.pathologyTree.clearSelection();
        this.collapseTree(this.anatomyTree);
        this.collapseTree(this.pathologyTree);
        if (list != null && !list.isEmpty()) {
            ACRCode aCRCode;
            ACRNode aCRNode = this.scheme.findNodeForCode(list.get(0));
            ACRCode aCRCode2 = aCRCode = aCRNode != null ? aCRNode.getCode() : null;
            if (aCRCode != null) {
                ACRPathologyNode aCRPathologyNode;
                ACRNode aCRNode2;
                ACRCode aCRCode3;
                ACRCode aCRCode4 = aCRCode.getAnatomyCode();
                ACRCode aCRCode5 = aCRCode3 = aCRCode.isCompositeCode() ? aCRCode : null;
                if (aCRCode4 != null && (aCRNode2 = this.scheme.findNodeForCode(aCRCode4)) != null) {
                    this.initPathologyTree((ACRAnatomyNode)aCRNode2);
                    this.anatomyTree.setSelectionPath(new TreePath(aCRNode2.getAsNode().getPath()));
                }
                if (aCRCode3 != null && (aCRPathologyNode = this.findCurrentPathologyNode(aCRNode2 = this.scheme.findNodeForCode(aCRCode3))) != null) {
                    this.pathologyTree.setSelectionPath(new TreePath(aCRPathologyNode.getAsNode().getPath()));
                }
            }
        }
        this.anatomyTree.getSelectionModel().addTreeSelectionListener(this.treeSelectionListener);
        this.pathologyTree.getSelectionModel().addTreeSelectionListener(this.treeSelectionListener);
    }

    @Override
    public void addClinicalCodeSchemeUIListener(IClinicalCodeSchemeUIListener iClinicalCodeSchemeUIListener) {
        if (iClinicalCodeSchemeUIListener != null && !this.listener.contains(iClinicalCodeSchemeUIListener)) {
            this.listener.add(iClinicalCodeSchemeUIListener);
        }
    }

    @Override
    public void removeClinicalCodeSchemeUIListener(IClinicalCodeSchemeUIListener iClinicalCodeSchemeUIListener) {
        if (iClinicalCodeSchemeUIListener != null && this.listener.contains(iClinicalCodeSchemeUIListener)) {
            this.listener.remove(iClinicalCodeSchemeUIListener);
        }
    }

    private void createComponents() {
        this.view = new ACRCodeView();
        this.anatomyTree = this.createTree();
        this.pathologyTree = this.createTree();
        this.anatomyScp = this.createScrollPane(this.anatomyTree);
        this.pathologyScp = this.createScrollPane(this.pathologyTree);
        this.splitPane = new JSplitPane(1, true, this.anatomyScp, this.pathologyScp);
        this.splitPane.setResizeWeight(0.5);
    }

    protected JTree createTree() {
        JTree jTree = new JTree();
        jTree.setBorder(null);
        jTree.setExpandsSelectedPaths(true);
        jTree.getSelectionModel().setSelectionMode(1);
        return jTree;
    }

    private JScrollPane createScrollPane(Component component) {
        JScrollPane jScrollPane = new JScrollPane(component, 20, 30);
        jScrollPane.setBorder(null);
        jScrollPane.setOpaque(false);
        jScrollPane.getViewport().setBorder(null);
        jScrollPane.getViewport().setOpaque(false);
        jScrollPane.setPreferredSize(new Dimension(300, 300));
        return jScrollPane;
    }

    private void initComponents() {
        this.initAnatomyTree();
        this.initPathologyTree(this.getSelectedAnatomyNode());
    }

    private void installListeners() {
        this.anatomyTree.getSelectionModel().addTreeSelectionListener(this.treeSelectionListener);
        this.pathologyTree.getSelectionModel().addTreeSelectionListener(this.treeSelectionListener);
    }

    private void uninstallListeners() {
        this.anatomyTree.getSelectionModel().removeTreeSelectionListener(this.treeSelectionListener);
        this.pathologyTree.getSelectionModel().removeTreeSelectionListener(this.treeSelectionListener);
    }

    private void installLayout() {
        this.view.setLayout(new BorderLayout());
        this.view.add((Component)this.splitPane, "Center");
    }

    private void uninstallLayout() {
        this.view.removeAll();
    }

    protected void finalize() throws Throwable {
        this.listener.clear();
        this.uninstallListeners();
        this.uninstallLayout();
        super.finalize();
    }

    private void fireSelectionChanged(ACRNode aCRNode, ACRNode aCRNode2) {
        for (IClinicalCodeSchemeUIListener iClinicalCodeSchemeUIListener : this.listener) {
            if (aCRNode == null && aCRNode2 == null) {
                iClinicalCodeSchemeUIListener.selectionChanged(Arrays.asList(new IClinicalCode[0]));
                continue;
            }
            ACRCode aCRCode = aCRNode2 != null ? aCRNode2.getCode() : aCRNode.getCode();
            iClinicalCodeSchemeUIListener.selectionChanged(Arrays.asList(aCRCode));
        }
    }

    private void initAnatomyTree() {
        ACRAnatomyNode aCRAnatomyNode = (ACRAnatomyNode)this.scheme.getRootNode();
        ACRAnatomyNode aCRAnatomyNode2 = (ACRAnatomyNode)aCRAnatomyNode.getChildren()[0];
        this.anatomyTree.setModel(new DefaultTreeModel(aCRAnatomyNode.getAsNode()));
        this.anatomyTree.setSelectionPath(new TreePath(aCRAnatomyNode2.getAsNode().getPath()));
    }

    private void initPathologyTree(ACRAnatomyNode aCRAnatomyNode) {
        ACRPathologyNode aCRPathologyNode = ACRNodeFactory.createPathologyRoot(aCRAnatomyNode);
        ACRPathologyNode aCRPathologyNode2 = (ACRPathologyNode)aCRPathologyNode.getChildren()[0];
        this.pathologyTree.setModel(new DefaultTreeModel(aCRPathologyNode.getAsNode()));
        this.pathologyTree.setSelectionPath(new TreePath(aCRPathologyNode2.getAsNode().getPath()));
    }

    private ACRAnatomyNode getSelectedAnatomyNode() {
        TreePath treePath = this.anatomyTree.getSelectionPath();
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)(treePath != null ? treePath.getLastPathComponent() : null);
        return defaultMutableTreeNode != null ? (ACRAnatomyNode)defaultMutableTreeNode.getUserObject() : null;
    }

    private ACRPathologyNode getSelectedPathologyNode() {
        TreePath treePath = this.pathologyTree.getSelectionPath();
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)(treePath != null ? treePath.getLastPathComponent() : null);
        return defaultMutableTreeNode != null ? (ACRPathologyNode)defaultMutableTreeNode.getUserObject() : null;
    }

    private ACRPathologyNode findCurrentPathologyNode(ACRNode aCRNode) {
        Enumeration<TreeNode> enumeration = ((DefaultMutableTreeNode)this.pathologyTree.getModel().getRoot()).breadthFirstEnumeration();
        while (enumeration.hasMoreElements()) {
            ACRNode aCRNode2 = (ACRNode)((DefaultMutableTreeNode)enumeration.nextElement()).getUserObject();
            if (!aCRNode2.equals(aCRNode)) continue;
            return (ACRPathologyNode)aCRNode2;
        }
        return null;
    }

    public void collapseTree(JTree jTree) {
        int n = jTree.getRowCount() - 1;
        while (n >= 1) {
            jTree.collapseRow(n);
            --n;
        }
    }

    private class ACRCodeView
    extends JPanel {
        private ACRCodeView() {
        }

        @Override
        public void setEnabled(boolean bl) {
            super.setEnabled(bl);
            ACRClinicalCodeSchemeUI.this.anatomyTree.setEnabled(bl);
            ACRClinicalCodeSchemeUI.this.pathologyTree.setEnabled(bl);
        }
    }

    private class DefaultTreeSelectionListener
    implements TreeSelectionListener {
        private DefaultTreeSelectionListener() {
        }

        @Override
        public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
            if (treeSelectionEvent.getSource() == ACRClinicalCodeSchemeUI.this.anatomyTree.getSelectionModel()) {
                ACRClinicalCodeSchemeUI.this.uninstallListeners();
                ACRClinicalCodeSchemeUI.this.initPathologyTree(ACRClinicalCodeSchemeUI.this.getSelectedAnatomyNode());
                ACRClinicalCodeSchemeUI.this.installListeners();
            }
            ACRClinicalCodeSchemeUI.this.fireSelectionChanged(ACRClinicalCodeSchemeUI.this.getSelectedAnatomyNode(), ACRClinicalCodeSchemeUI.this.getSelectedPathologyNode());
        }
    }
}

