/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.security.permission.impl;

import com.agfa.pacs.core.FactorySelector;
import com.agfa.pacs.logging.ALogger;
import com.agfa.pacs.security.permission.IPermissionsProvider;
import java.util.List;

public abstract class PermissionsProviderFactory {
    private static PermissionsProviderFactory implementation;

    public static synchronized PermissionsProviderFactory getInstance() {
        if (implementation == null) {
            PermissionsProviderFactory.initialize();
        }
        return implementation;
    }

    public IPermissionsProvider getPermissionsProvider() {
        List<IPermissionsProvider> list = implementation.getPermissionsProvidersInt();
        if (list.size() == 0 || list.size() > 1) {
            ALogger.getLogger((String)"Permissions").error("Multiple or no PermissionProviders found.");
            return null;
        }
        return list.get(0);
    }

    protected abstract List<IPermissionsProvider> getPermissionsProvidersInt();

    private static synchronized void initialize() {
        ReflectiveOperationException reflectiveOperationException = null;
        try {
            Class<?> clazz = Class.forName(FactorySelector.createFactory((String)PermissionsProviderFactory.class.getName()));
            implementation = (PermissionsProviderFactory)clazz.newInstance();
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException reflectiveOperationException2) {
            reflectiveOperationException = reflectiveOperationException2;
        }
        if (reflectiveOperationException != null) {
            throw new RuntimeException("failed to create factory " + PermissionsProviderFactory.class.getName(), reflectiveOperationException);
        }
    }
}

