/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.base.data.action;

import com.agfa.pacs.base.data.action.IDataAction;
import com.agfa.pacs.core.FactorySelector;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;

public abstract class DataActionFactory {
    private static DataActionFactory implementation;

    public static synchronized DataActionFactory getInstance() {
        if (implementation == null) {
            DataActionFactory.initialize();
        }
        return implementation;
    }

    public Collection<IDataAction> getActions() {
        ArrayList<IDataAction> arrayList = new ArrayList<IDataAction>(implementation.getActionsInt());
        Collections.sort(arrayList, new ActionComp());
        return arrayList;
    }

    public Collection<String> getActionCodes() {
        return implementation.getActionCodesInt();
    }

    public IDataAction getActionForCode(String string) {
        return implementation.getActionForCodeInt(string);
    }

    protected abstract Collection<IDataAction> getActionsInt();

    protected abstract Collection<String> getActionCodesInt();

    protected abstract IDataAction getActionForCodeInt(String var1);

    private static synchronized void initialize() {
        ReflectiveOperationException reflectiveOperationException = null;
        try {
            Class<?> clazz = Class.forName(FactorySelector.createFactory((String)DataActionFactory.class.getName()));
            implementation = (DataActionFactory)clazz.newInstance();
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException reflectiveOperationException2) {
            reflectiveOperationException = reflectiveOperationException2;
        }
        if (reflectiveOperationException != null) {
            throw new RuntimeException("failed to create factory " + DataActionFactory.class.getName(), reflectiveOperationException);
        }
    }

    private static class ActionComp
    implements Comparator<IDataAction> {
        private ActionComp() {
        }

        @Override
        public int compare(IDataAction iDataAction, IDataAction iDataAction2) {
            return iDataAction.getPriority() - iDataAction2.getPriority();
        }
    }
}

