/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.base.lic;

import com.agfa.pacs.base.lic.ILicense;
import com.agfa.pacs.base.lic.impl.DummyLicense;
import com.agfa.pacs.base.lic.impl.LicenseImpl;
import com.agfa.pacs.base.lic.impl.LicenseUtilities;
import com.agfa.pacs.base.lic.impl.LocalLicenseChecker;
import com.agfa.pacs.base.lic.impl.MACReader;
import com.agfa.pacs.base.lic.xml.Customer;
import com.agfa.pacs.base.lic.xml.License;
import com.agfa.pacs.base.lic.xml.LicenseFileType;
import com.agfa.pacs.base.lic.xml.LicenseTicket;
import com.agfa.pacs.base.lic.xml.LicensesType;
import com.agfa.pacs.base.util.Product;
import com.agfa.pacs.config.ConfigurationProviderFactory;
import com.agfa.pacs.logging.ALogger;
import com.agfa.pacs.login.IURLProvider;
import com.agfa.pacs.login.URLProviderFactory;
import com.agfa.pacs.tools.StreamUtil;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import java.util.concurrent.ThreadLocalRandom;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.eclipse.core.runtime.Platform;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;

public class LicenseManager {
    private static final ALogger log = ALogger.getLogger(LicenseManager.class);
    private static final Set<String> DEFAULT_LICENSES = new HashSet<String>(Arrays.asList("WORKLIST", "MULTI_MONITOR", "UPS_REPORTING", "XDSI", "TEACHING_FILES", "SAVE_KO", "SAVE_SC", "SAVE_PR", "IMPORT", "DCMCDW_BURN", "DICOM_SEND", "DICOM_EXPORT", "LOCAL_BURN", "LOCAL_BURN", "IMAGE_EXPORT", "POWERPOINT_EXPORT", "MULTI_PATIENT_DISPLAY"));
    private static final String CHARSET = "UTF8";
    private static final String OFFLINE_LICENSE_FILE = ".offlineLic.xml";
    private static boolean isOffline = false;
    private static boolean uniqueHost = true;
    private static LicenseManager instance = null;
    private String serverBaseURL;
    private String role;
    private String ip;
    private String mac;
    private String sessionID;
    private Set<String> supportedIDs = Collections.emptySet();
    private String user;
    private HashMap<String, ILicense> licenses = new HashMap();

    public static void setUniqueHost(boolean bl) {
        uniqueHost = bl;
    }

    public static boolean isUniqueHost() {
        return uniqueHost;
    }

    public static synchronized LicenseManager getInstance() {
        if (instance == null) {
            instance = new LicenseManager();
        }
        return instance;
    }

    private LicenseManager() {
        this.ip = LicenseUtilities.determineMachine();
        this.mac = MACReader.getInstance().getMAC();
        this.user = URLProviderFactory.getProvider().getLoginInformation().getUserID();
        log.info("Current MAC Adress for Licensing:{}", (Object)this.mac);
        long l = ThreadLocalRandom.current().nextLong();
        this.sessionID = Long.toHexString(l);
        if (isOffline) {
            File file = LicenseManager.getOfflineLicenseFile();
            if (file.exists()) {
                this.initOffline(file);
            }
        } else if (!ConfigurationProviderFactory.getConfig().isSupportingRoles() || this.isLocalLicenseActivated() || Product.isInEmergencyMode()) {
            this.serverBaseURL = null;
            this.initLocal();
        } else {
            IURLProvider iURLProvider = URLProviderFactory.getProvider();
            this.role = iURLProvider.getLoginInformation().getRole();
            this.serverBaseURL = "Licensing/licensing";
            this.supportedIDs = LicenseUtilities.querySupported(this.serverBaseURL, this.mac, this.role);
            this.requestDefaultLicenses();
            if (this.sessionID != null) {
                LicenseUtilities.startPinging(this.serverBaseURL, this.sessionID);
            }
        }
    }

    private void requestDefaultLicenses() {
        HashSet<String> hashSet = new HashSet<String>(DEFAULT_LICENSES);
        hashSet.retainAll(this.supportedIDs);
        ILicense iLicense = this.licenses.get(ILicense.MAIN_PRODUCT_LICENSE_ID);
        if (iLicense == null) {
            return;
        }
        Customer customer = iLicense.getCustomer();
        for (String string : hashSet) {
            DummyLicense dummyLicense = new DummyLicense(string, customer);
            this.licenses.put(string, dummyLicense);
        }
    }

    public static boolean existsOfflineLicenseFile() {
        return LicenseManager.getOfflineLicenseFile().exists();
    }

    private static File getOfflineLicenseFile() {
        File file = new File(Platform.getConfigurationLocation().getURL().getFile(), "pacs");
        File file2 = new File(file, OFFLINE_LICENSE_FILE);
        return file2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void initOffline(File file) {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try {
                InputStream inputStream = Files.newInputStream(file.toPath(), new OpenOption[0]);
                try {
                    try (ObjectInputStream objectInputStream = new ObjectInputStream(inputStream);){
                        this.supportedIDs = new HashSet<String>();
                        boolean bl = false;
                        while (!bl) {
                            bl = this.readUntilEOF(objectInputStream);
                        }
                    }
                    if (inputStream == null) return;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    if (inputStream == null) throw throwable;
                    inputStream.close();
                    throw throwable;
                }
                inputStream.close();
                return;
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                } else {
                    if (throwable == throwable3) throw throwable;
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
        }
        catch (Exception exception) {
            log.error("Problem reading licenses", (Throwable)exception);
        }
    }

    private boolean readUntilEOF(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        try {
            Object object = objectInputStream.readObject();
            if (object instanceof ILicense) {
                ILicense iLicense = (ILicense)object;
                this.licenses.put(iLicense.getID(), iLicense);
                this.supportedIDs.add(iLicense.getID());
            }
            return false;
        }
        catch (EOFException eOFException) {
            return true;
        }
    }

    private boolean isLocalLicenseActivated() {
        return "true".equals(System.getProperty("preferLocalLicense"));
    }

    private void initLocal() {
        File file = new File("License.xml");
        if (!file.exists()) {
            log.error("No local license available");
            return;
        }
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (InputStream inputStream = Files.newInputStream(file.toPath(), new OpenOption[0]);){
                DocumentBuilder documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                InputStreamReader inputStreamReader = new InputStreamReader(inputStream, CHARSET);
                String string = StreamUtil.readStream((Reader)inputStreamReader);
                Document document = documentBuilder.parse(new InputSource(new StringReader(string)));
                LicenseFileType licenseFileType = new LicenseFileType(document.getDocumentElement());
                HashSet<String> hashSet = new HashSet<String>();
                Calendar calendar = Calendar.getInstance();
                if (LocalLicenseChecker.checkLicense(string, licenseFileType)) {
                    LicensesType licensesType = licenseFileType.getLicenses();
                    for (License license : licensesType.getLicense()) {
                        if (license.getDueDate() != null && license.getDueDate().toGregorianCalendar().before(calendar)) continue;
                        this.licenses.put(license.getId(), new LicenseImpl(licensesType.getIssuer(), license, null));
                        hashSet.add(license.getId());
                    }
                    this.supportedIDs = Collections.unmodifiableSet(hashSet);
                } else {
                    log.error("Found no valid license file");
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception exception) {
            log.error("Could not parse license file", (Throwable)exception);
        }
    }

    public synchronized void synchronizeLicenses(Set<String> set) {
        HashSet<String> hashSet = new HashSet<String>(this.licenses.keySet());
        for (String string : hashSet) {
            if (set.contains(string)) continue;
            this.releaseLicense(string);
        }
        for (String string : set) {
            if (this.licenses.containsKey(string)) continue;
            this.getLicense(string);
        }
    }

    public synchronized ILicense getLicense(String string) {
        ILicense iLicense = this.licenses.get(string);
        if (iLicense != null) {
            return iLicense;
        }
        LicenseTicket licenseTicket = LicenseUtilities.query(this.serverBaseURL, string, this.ip, this.mac, this.role, this.sessionID, this.user);
        if (licenseTicket == null) {
            log.debug("License could not be obtained for:" + string);
            return null;
        }
        if (!LicenseUtilities.checkLicense(licenseTicket)) {
            ALogger.getLogger(LicenseManager.class).error("Tampered ticket");
            return null;
        }
        if (!string.equals(licenseTicket.getLicense().getId())) {
            return null;
        }
        iLicense = new LicenseImpl(licenseTicket.getIssuer(), licenseTicket.getLicense(), licenseTicket.getTicket());
        this.licenses.put(string, iLicense);
        return iLicense;
    }

    private synchronized void releaseLicense(ILicense iLicense) {
        if (this.serverBaseURL == null || iLicense instanceof DummyLicense) {
            return;
        }
        this.licenses.remove(iLicense.getID());
        LicenseUtilities.unregister(this.serverBaseURL, ((LicenseImpl)iLicense).getTicket(), iLicense.getID());
    }

    public synchronized void releaseLicense(String string) {
        ILicense iLicense;
        if (!isOffline && (iLicense = this.licenses.get(string)) != null) {
            this.releaseLicense(iLicense);
        }
    }

    public synchronized void releaseAllLicenses() {
        File file = LicenseManager.getOfflineLicenseFile();
        if (!isOffline) {
            LinkedList<ILicense> linkedList = new LinkedList<ILicense>(this.licenses.values());
            for (ILicense iLicense : linkedList) {
                this.releaseLicense(iLicense);
            }
            if (file.exists()) {
                file.delete();
            }
        } else {
            LinkedList<ILicense> linkedList = new LinkedList<ILicense>(this.licenses.values());
            if (!file.exists()) {
                try {
                    Throwable throwable = null;
                    Object var4_5 = null;
                    try (ObjectOutputStream objectOutputStream = new ObjectOutputStream(Files.newOutputStream(file.toPath(), new OpenOption[0]));){
                        for (ILicense iLicense : linkedList) {
                            objectOutputStream.writeObject(iLicense);
                        }
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (Exception exception) {
                    log.error("Could not store licenses", (Throwable)exception);
                }
            }
        }
        this.licenses.clear();
    }

    public static void setOffline(boolean bl) {
        isOffline = bl;
    }

    public Iterable<String> getSupportedLicenseIDs() {
        return this.supportedIDs;
    }

    public boolean isLicenseIDSupported(String string) {
        if (this.supportedIDs == null) {
            return true;
        }
        return this.supportedIDs.contains(string);
    }

    public boolean isLicensePresent(String string) {
        if (this.supportedIDs == null) {
            return false;
        }
        return this.supportedIDs.contains(string);
    }
}

