/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.base.lic.impl;

import com.agfa.pacs.base.lic.impl.LicenseCheckException;
import com.agfa.pacs.base.lic.xml.License;
import com.agfa.pacs.base.lic.xml.LicenseFileType;
import com.agfa.pacs.logging.ALogger;
import java.io.ByteArrayInputStream;
import java.io.UnsupportedEncodingException;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Base64;

public class LicenseChecker {
    private static final ALogger log = ALogger.getLogger(LicenseChecker.class);
    private static final String SIGALG = "SHA1withDSA";
    private static final String ENCODING = "UTF8";
    private static final String ccc = "S/JrYUDsfKJ5dC8oFe1Oe313QvM4oEZ0eHVoRQBfdUBydmsgdGhtcjokWXpAY3hzLnRgZnY4FxUVHglEf15zdnglbHJjaCgZHh4GFEF2TmZ9cz1xen1xMRwWCVU4Cx8cDxgLFAILT2FLf252JWp1Y3M5BQURFl41PkF6RWBofSV/c3t8PAcdFRUDARsXXmBndkBfREJfTkFNQVpAQTRpfUpGWEdCWE9GSkJdRCpeDkFwQGFzczt6dmhyKSFBYU59fXM9cXh9eCYSFQYbEV9xQHZ2ayB0aW12LRkNGx4PT2hLZm52JWp0Y3QxDxMRTjYVGhwcHRMPDBVKYVh6dm0rdHBjYDwdHh8IWzUtRGJebnZ4JWx2Y2cyGRgVBgYZABlA+XHfRfJvUnZ8Wu49vlZ6cUvyaWpy7/9whg879G0bbFkpryLpXoKal41h3ydMgTpwuG5X9cY/WBk+LShXIZUnTfYoksq1m8RAjbvzIBy5/0v7bVwagggexxDpONDU8eGYfwt4V7Ihxdmsjt+za5ZFJ5y2wNNlYXqL+Ia7sG6tfEUvYzJj4VyIBYjeQxSnRJGCWXNx6KEmf7d5ZWjiED7xZVh7pMfi1/zSkPRjhShyi3L68WiCkc77puBNtr7MxSJGwyfRDOTBxYpBmuqMJyJ1TXzyDyQpOfDKryknkwFpbvH7xCFjAU2WPFNme8K/Z0z8s9aJSWYU9SQH/UCV08BgW8jWHeQezQF7gVFdF4GVHAp6VFO51J/A2Crg4d3zsZ8qnu9u5/sIIPAAJU0RcSJFjrQ5Qnbx6n5y+vAh7YTO/gnX+jOvBP5hhSU/xs6hwI/EeOq3gv04bNhKeifcGtSFFzwd7aipWRe8Y1hr9F1Xrd1UI/foc4BFhpWqltXtugVJd2IPbHSwn9K6lWUIwDbejUh1ev5AunOF1JBbqky9R1OCPbIwv9jtQjKfjtp1I1JtNw+amgeZGDH5wlh+dmlU9jO+UHFza35zVHBYWXJ6anQI/dmOUmSkSAIqkipoS2ucwCdqYQ7ippuKuPcRqmL3V0WEL476/V98";
    private static CertificateFactory cf = null;
    private static Signature sig = null;

    private static byte[] putLadder(byte[] byArray) {
        byte[] byArray2 = LicenseChecker.getLadder();
        int n = byArray2.length;
        int n2 = 0;
        while (n2 < byArray.length) {
            byArray[n2] = (byte)(byArray[n2] ^ byArray2[n2 % n]);
            ++n2;
        }
        return byArray;
    }

    private static byte[] getLadder() {
        byte[] byArray = new byte[]{116, 105, 97, 110, 105, 103, 119, 105};
        int n = 0;
        while (n < byArray.length) {
            byArray[n] = (byte)(byArray[n] + 7);
            ++n;
        }
        return byArray;
    }

    private static Signature prepareSignature() {
        try {
            if (cf == null) {
                cf = CertificateFactory.getInstance("X.509");
            }
            byte[] byArray = Base64.getDecoder().decode(ccc);
            byArray = LicenseChecker.putLadder(byArray);
            X509Certificate x509Certificate = (X509Certificate)cf.generateCertificate(new ByteArrayInputStream(byArray));
            PublicKey publicKey = x509Certificate.getPublicKey();
            Signature signature = Signature.getInstance(SIGALG);
            signature.initVerify(publicKey);
            return signature;
        }
        catch (Exception exception) {
            System.out.println("Could not create public key");
            return null;
        }
    }

    public static boolean checkLicense(String string, LicenseFileType licenseFileType) throws SignatureException, UnsupportedEncodingException {
        String string2 = licenseFileType.getSignature();
        if (string2.equals("CONVERTED_ELMS_LICENSE")) {
            for (License license : licenseFileType.getLicenses().getLicense()) {
                if (license.getId().startsWith("IMPAX_") || license.getId().startsWith("GTI_")) continue;
                throw new SignatureException("License has ELMS signature but ID does not have one of the expected prefixes IMPAX_ or GTI_");
            }
            log.info("Checked imported ELMS license signature");
            return true;
        }
        if (sig == null) {
            sig = LicenseChecker.prepareSignature();
        }
        if (sig != null) {
            sig.update(string.getBytes(ENCODING));
            return sig.verify(Base64.getDecoder().decode(string2));
        }
        return false;
    }

    public static String getDataForSignature(String string) throws LicenseCheckException {
        int n = string.indexOf("<licenses>");
        int n2 = string.indexOf("</licenses>");
        if (n < 0 || n2 < 0) {
            throw new LicenseCheckException();
        }
        String string2 = string.substring(n + 10, n2);
        string2 = "<Licenses>" + string2 + "</Licenses>";
        string2 = string2.replace("\t", "");
        string2 = string2.replace("\n", "");
        string2 = string2.replace("\r", "");
        return string2;
    }
}

