/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.base.lic.impl;

import com.agfa.pacs.base.lic.LicenseManager;
import com.agfa.pacs.base.lic.impl.LicenseCheckException;
import com.agfa.pacs.base.lic.impl.LicenseChecker;
import com.agfa.pacs.base.lic.xml.Customer;
import com.agfa.pacs.base.lic.xml.License;
import com.agfa.pacs.base.lic.xml.LicenseTicket;
import com.agfa.pacs.logging.ALogger;
import com.agfa.pacs.services.IHTTPClientService;
import com.agfa.pacs.tools.StreamUtil;
import com.agfa.pacs.tools.URLEncodeUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import java.security.SignatureException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

public class LicenseUtilities {
    private static final ALogger log = ALogger.getLogger(LicenseUtilities.class);
    public static final String SERVER_BASE_PATH = "Licensing/licensing";
    private static int networkErrorCounter = 0;

    private static boolean issuerEquals(Customer customer, Customer customer2) {
        if (!Objects.equals(customer.getName(), customer2.getName())) {
            return false;
        }
        if (!Objects.equals(customer.getLocation(), customer2.getLocation())) {
            return false;
        }
        return Objects.equals(customer.getCountry(), customer2.getCountry());
    }

    private static boolean licenseEquals(License license, License license2) {
        if (!license.getId().equals(license2.getId())) {
            return false;
        }
        return license.getLimitation().size() == license2.getLimitation().size();
    }

    public static boolean checkLicense(LicenseTicket licenseTicket) {
        if (!LicenseUtilities.issuerEquals(licenseTicket.getIssuer(), licenseTicket.getSource().getLicenses().getIssuer())) {
            return false;
        }
        boolean bl = false;
        for (License object : licenseTicket.getSource().getLicenses().getLicense()) {
            if (!LicenseUtilities.licenseEquals(object, licenseTicket.getLicense())) continue;
            bl = true;
            break;
        }
        if (!bl) {
            return false;
        }
        try {
            String signatureException = LicenseChecker.getDataForSignature(licenseTicket.getSourceString());
            return LicenseChecker.checkLicense(signatureException, licenseTicket.getSource());
        }
        catch (SignatureException licenseCheckException) {
            log.error("Signature error", (Throwable)licenseCheckException);
        }
        catch (LicenseCheckException licenseCheckException) {
            log.error("Signature error", (Throwable)licenseCheckException);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {}
        return false;
    }

    public static LicenseTicket query(String string, String string2, String string3, String string4, String string5, String string6, String string7) {
        InputStream inputStream;
        block7: {
            if (string == null) {
                return null;
            }
            if (networkErrorCounter >= 2) {
                return null;
            }
            StringBuilder stringBuilder = new StringBuilder(64);
            stringBuilder.append(string);
            stringBuilder.append("?action=request&product=");
            stringBuilder.append(string2);
            stringBuilder.append('&');
            stringBuilder.append("IP");
            stringBuilder.append('=');
            stringBuilder.append(string3);
            stringBuilder.append('&');
            stringBuilder.append("MAC");
            stringBuilder.append('=');
            stringBuilder.append(string4);
            if (string6 != null) {
                stringBuilder.append('&');
                stringBuilder.append("SESSION");
                stringBuilder.append('=');
                stringBuilder.append(string6);
            }
            stringBuilder.append('&');
            stringBuilder.append("PINGING");
            stringBuilder.append("=true");
            stringBuilder.append('&');
            stringBuilder.append("USER");
            stringBuilder.append('=');
            stringBuilder.append(URLEncodeUtil.encode((String)string7));
            if (string5 != null && string5.length() > 0) {
                string5 = URLEncodeUtil.encode((String)string5);
                stringBuilder.append('&');
                stringBuilder.append("ROLE");
                stringBuilder.append('=');
                stringBuilder.append(string5);
            }
            stringBuilder.append("&");
            stringBuilder.append("UNIQUE_HOST");
            stringBuilder.append("=");
            stringBuilder.append(Boolean.toString(LicenseManager.isUniqueHost()));
            try {
                inputStream = ((IHTTPClientService)IHTTPClientService.FACTORY.getInstance()).performGETasStream(stringBuilder.toString());
                if (inputStream != null) break block7;
                log.warn("No license found code(" + string2 + ")");
                return null;
            }
            catch (Exception exception) {
                log.error("License error", (Throwable)exception);
                ++networkErrorCounter;
                return null;
            }
        }
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream, StandardCharsets.UTF_8);
        String string8 = StreamUtil.readStream((Reader)inputStreamReader);
        LicenseTicket licenseTicket = new LicenseTicket();
        licenseTicket.setSourceString(string8);
        networkErrorCounter = 0;
        return licenseTicket;
    }

    public static void startPinging(String string, String string2) {
        final String string3 = String.valueOf(string) + "?action=ping&" + "SESSION" + "=" + string2;
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                String string;
                do {
                    try {
                        Thread.sleep(45000L);
                    }
                    catch (InterruptedException interruptedException) {}
                } while ((string = ((IHTTPClientService)IHTTPClientService.FACTORY.getInstance()).performGETasString(string3)) != null);
                log.warn("Could not ping.");
            }
        });
        thread.setDaemon(true);
        thread.setName("LicensePinging");
        thread.setPriority(1);
        thread.start();
    }

    public static void unregister(String string, String string2, String string3) {
        String string4 = String.valueOf(string) + "?action=unregister&ticket=" + string2;
        String string5 = ((IHTTPClientService)IHTTPClientService.FACTORY.getInstance()).performGETasString(string4);
        if (string5 == null) {
            log.warn("Could not unregister.");
            return;
        }
        log.debug("License unregistered:" + string3);
    }

    public static String determineMachine() {
        try {
            InetAddress inetAddress = InetAddress.getLocalHost();
            String string = inetAddress.getHostAddress();
            return string;
        }
        catch (UnknownHostException unknownHostException) {
            return "IMPAX WORKSTATION";
        }
    }

    public static String createSupportedLicensesQueryURL(String string, String string2, String string3) {
        StringBuilder stringBuilder = new StringBuilder(32);
        stringBuilder.append(string);
        stringBuilder.append("?action=supported&");
        stringBuilder.append("MAC");
        stringBuilder.append('=');
        stringBuilder.append(string2);
        if (string3 != null && string3.length() > 0) {
            string3 = URLEncodeUtil.encode((String)string3);
            stringBuilder.append('&');
            stringBuilder.append("ROLE");
            stringBuilder.append('=');
            stringBuilder.append(string3);
        }
        return stringBuilder.toString();
    }

    public static Set<String> querySupported(String string, String string2, String string3) {
        if (string == null) {
            return Collections.emptySet();
        }
        String string4 = LicenseUtilities.createSupportedLicensesQueryURL(string, string2, string3);
        InputStream inputStream = ((IHTTPClientService)IHTTPClientService.FACTORY.getInstance()).performGETasStream(string4);
        if (inputStream == null) {
            log.info("Query for supported IDs not available");
            return Collections.emptySet();
        }
        try {
            InputStreamReader inputStreamReader = new InputStreamReader(inputStream, StandardCharsets.UTF_8);
            String string5 = StreamUtil.readStream((Reader)inputStreamReader);
            if (string5.length() == 0) {
                return Collections.emptySet();
            }
            log.info("Supported Licenses:" + string5);
            HashSet<String> hashSet = new HashSet<String>();
            String[] stringArray = string5.split(";");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String string6 = stringArray[n2];
                hashSet.add(string6);
                ++n2;
            }
            return Collections.unmodifiableSet(hashSet);
        }
        catch (IOException iOException) {
            log.error("Could not parse result", (Throwable)iOException);
            return Collections.emptySet();
        }
    }
}

