/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.base.lic.impl;

import java.io.IOException;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class MACReader {
    public static MACReader getInstance() {
        return new MACReader();
    }

    public static void main(String[] stringArray) throws IOException {
        MACReader mACReader = MACReader.getInstance();
        byte[] byArray = MACReader.getInstance().readMAC();
        if (byArray == null) {
            System.out.println("Failed to read MAC");
            return;
        }
        System.out.println("MAC=" + MACReader.toString(byArray[0]) + ":" + MACReader.toString(byArray[1]) + ":" + MACReader.toString(byArray[2]) + ":" + MACReader.toString(byArray[3]) + ":" + MACReader.toString(byArray[4]) + ":" + MACReader.toString(byArray[5]));
        System.out.println("SHort mac:" + mACReader.getMAC());
    }

    private static String toString(byte by) {
        int n = by & 0xFF;
        return String.valueOf(n < 16 ? "0" : "") + Integer.toHexString(n);
    }

    public byte[] readMAC() {
        try {
            List<NetworkInterface> list = MACReader.getNetworkInterfaces("eth");
            if (list.isEmpty()) {
                list = MACReader.getNetworkInterfaces("wlan");
            }
            if (!list.isEmpty()) {
                return list.get(0).getHardwareAddress();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return null;
    }

    private static List<NetworkInterface> getNetworkInterfaces(String string) throws Exception {
        return Collections.list(NetworkInterface.getNetworkInterfaces()).stream().filter(networkInterface -> StringUtils.startsWithIgnoreCase((CharSequence)networkInterface.getName(), (CharSequence)string) && MACReader.hasMACAdress(networkInterface) && !MACReader.isVirtual(networkInterface)).collect(Collectors.toList());
    }

    private static boolean hasMACAdress(NetworkInterface networkInterface) {
        try {
            return networkInterface.getHardwareAddress() != null;
        }
        catch (SocketException socketException) {
            return false;
        }
    }

    private static boolean isVirtual(NetworkInterface networkInterface) {
        if (networkInterface == null) {
            return true;
        }
        return networkInterface.isVirtual() || StringUtils.containsIgnoreCase((CharSequence)networkInterface.getDisplayName(), (CharSequence)"cisco") || StringUtils.containsIgnoreCase((CharSequence)networkInterface.getDisplayName(), (CharSequence)"VirtualBox") || StringUtils.containsIgnoreCase((CharSequence)networkInterface.getDisplayName(), (CharSequence)"vmware") || StringUtils.containsIgnoreCase((CharSequence)networkInterface.getDisplayName(), (CharSequence)"wan miniport");
    }

    public String getMAC() {
        byte[] byArray = this.readMAC();
        if (byArray == null) {
            return "00-00-00-00-00-00";
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < byArray.length) {
            stringBuffer.append(MACReader.toString(byArray[n]));
            if (n < 5) {
                stringBuffer.append('-');
            }
            ++n;
        }
        return stringBuffer.toString().toUpperCase(Locale.ENGLISH);
    }
}

