/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.base.util;

import com.agfa.pacs.base.util.Dcm4cheUtils;
import com.agfa.pacs.data.shared.lw.IDataInfo;
import com.agfa.pacs.logging.ALogger;
import com.agfa.pacs.tools.CompareUtils;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Comparator;
import java.util.Date;
import java.util.GregorianCalendar;
import org.apache.commons.lang3.time.FastDateFormat;
import org.dcm4che3.data.Attributes;

public class DateTimeUtils {
    private static final ALogger log = ALogger.getLogger(DateTimeUtils.class);
    private static final FastDateFormat shortDate = FastDateFormat.getDateInstance((int)3);
    private static final FastDateFormat mediumDate = FastDateFormat.getDateInstance((int)2);
    private static final FastDateFormat longDate = FastDateFormat.getDateInstance((int)1);
    private static final FastDateFormat shortTime = FastDateFormat.getTimeInstance((int)3);
    private static final FastDateFormat mediumTime = FastDateFormat.getTimeInstance((int)2);
    private static final FastDateFormat mediumDateShortTime = FastDateFormat.getDateTimeInstance((int)2, (int)3);
    private static final FastDateFormat mediumDateMediumTime = FastDateFormat.getDateTimeInstance((int)2, (int)2);

    public static String date2ShortString(Date date) {
        return shortDate.format(date);
    }

    public static String date2LongString(Date date) {
        return longDate.format(date);
    }

    public static String date2String(Date date) {
        return mediumDate.format(date);
    }

    public static String time2String(Date date) {
        return shortTime.format(date);
    }

    public static String time2LongerString(Date date) {
        return mediumTime.format(date);
    }

    public static String dateTime2String(Date date) {
        return mediumDateShortTime.format(date);
    }

    public static String dateTime2LongerString(Date date) {
        return mediumDateMediumTime.format(date);
    }

    public static Date string2Date(String string) throws ParseException {
        return mediumDate.parse(string);
    }

    static Date string2DateTime(String string) throws ParseException {
        return mediumDateMediumTime.parse(string);
    }

    static Date stringShortFormat2Date(String string) throws ParseException {
        return shortDate.parse(string);
    }

    public static Date string2Time(String string) throws ParseException {
        return shortTime.parse(string);
    }

    static Date stringMediumFormat2Time(String string) throws ParseException {
        return mediumTime.parse(string);
    }

    private static void setCalendarTime(Calendar calendar, int n, int n2, int n3, int n4) {
        calendar.set(11, n);
        calendar.set(12, n2);
        calendar.set(13, n3);
        calendar.set(14, n4);
    }

    public static Date setDateTo01011970(Date date) {
        assert (date != null) : "How should set time when passed date is null?";
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(1, 1970);
        calendar.set(2, 1);
        calendar.set(5, 1);
        return calendar.getTime();
    }

    public static Date setTimeTo0000(Date date) {
        assert (date != null) : "How should set time when passed date is null?";
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        DateTimeUtils.setCalendarTime(calendar, 0, 0, 0, 0);
        return calendar.getTime();
    }

    public static Date addMinutes(Date date, int n) {
        assert (date != null) : "How should I add " + n + " minutes when date is null?";
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(12, n);
        return calendar.getTime();
    }

    public static Date addDays(Date date, int n) {
        assert (date != null) : "How should I add " + n + " days when date is null?";
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(5, n);
        return calendar.getTime();
    }

    public static Date addWeeks(Date date, int n) {
        assert (date != null) : "How should I add " + n + " weeks when date is null?";
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(3, n);
        return calendar.getTime();
    }

    public static Date getStudyDateTime(IDataInfo iDataInfo) {
        return DateTimeUtils.getStudyDateTime(iDataInfo.getAttributes());
    }

    public static Date getStudyDateTime(Attributes attributes) {
        try {
            return Dcm4cheUtils.getDateTime((long)2251937253163056L, (Attributes)attributes);
        }
        catch (Exception exception) {
            log.info("Could not parse date", (Throwable)exception);
            return null;
        }
    }

    public static Date older(Date date, Date date2) {
        assert (date != null && date2 != null) : "How to return the older one when one is null, or both are null?";
        return date.compareTo(date2) <= 0 ? date : date2;
    }

    public static Date setTimeFrom(Date date, Date date2) {
        assert (date != null && date2 != null) : "How should I work with dates when one is null, or both are null?";
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        Calendar calendar2 = Calendar.getInstance();
        calendar2.setTime(date2);
        calendar.set(11, calendar2.get(11));
        calendar.set(12, calendar2.get(12));
        calendar.set(13, calendar2.get(13));
        calendar.set(14, calendar2.get(14));
        return calendar.getTime();
    }

    public static boolean youngerByTimeOnly(Date date, Date date2) {
        assert (date != null && date2 != null) : "How should I compare dates when one is null, or both are null?";
        return DateTimeUtils.setDateTo01011970(date).compareTo(DateTimeUtils.setDateTo01011970(date2)) > 0;
    }

    public static Date toDateTime(Date date, Date date2) {
        if (date == null) {
            return null;
        }
        if (date2 == null) {
            return date;
        }
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.setTime(date);
        GregorianCalendar gregorianCalendar2 = new GregorianCalendar();
        gregorianCalendar2.setTime(date2);
        gregorianCalendar2.set(1, gregorianCalendar.get(1));
        gregorianCalendar2.set(2, gregorianCalendar.get(2));
        gregorianCalendar2.set(5, gregorianCalendar.get(5));
        return gregorianCalendar2.getTime();
    }

    public static boolean youngerByDateOnly(Date date, Date date2) {
        assert (date != null && date2 != null) : "How should I compare dates when one is null, or both are null?";
        return DateTimeUtils.setTimeTo0000(date).compareTo(DateTimeUtils.setTimeTo0000(date2)) > 0;
    }

    public static Date now() {
        return new Date();
    }

    public static Comparator<IDataInfo> getStudyComparator() {
        return new StudiesComparator();
    }

    private static class StudiesComparator
    implements Comparator<IDataInfo> {
        private StudiesComparator() {
        }

        @Override
        public int compare(IDataInfo iDataInfo, IDataInfo iDataInfo2) {
            Date date = DateTimeUtils.getStudyDateTime(iDataInfo);
            Date date2 = DateTimeUtils.getStudyDateTime(iDataInfo2);
            return CompareUtils.compareAdvanced((Comparable)date2, (Comparable)date);
        }
    }
}

