/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.base.util;

import at.jta.Regor;
import com.agfa.pacs.logging.ALogger;
import java.io.File;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DesktopUtils {
    public static String getUserDesktop() {
        String string = System.getProperty("os.name");
        if (string.startsWith("Windows")) {
            String string2 = DesktopUtils.getWindowsDesktopPath();
            if (string2 != null && !string2.isEmpty()) {
                return string2;
            }
            String string3 = System.getenv("userprofile");
            if (string3 == null) {
                string3 = System.getProperty("user.home");
            }
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(string3);
            stringBuffer.append(File.separatorChar);
            stringBuffer.append("Desktop");
            return stringBuffer.toString();
        }
        return System.getProperty("user.home");
    }

    private static String getWindowsDesktopPath() {
        try {
            Regor regor = new Regor();
            int n = regor.openKey(-2147483647, "Software\\Microsoft\\Windows\\CurrentVersion\\Explorer\\Shell Folders");
            byte[] byArray = regor.readValue(n, "Desktop");
            regor.closeKey(n);
            return DesktopUtils.resolveWindowsEnvironmentVariables(new String(byArray).trim());
        }
        catch (Exception exception) {
            ALogger.getLogger(DesktopUtils.class).error(null, (Throwable)exception);
            return null;
        }
    }

    private static String resolveWindowsEnvironmentVariables(String string) {
        Matcher matcher = Pattern.compile("%[a-zA-Z]*%").matcher(string);
        StringBuffer stringBuffer = new StringBuffer();
        while (matcher.find()) {
            String string2 = matcher.group();
            if (string2 == null) continue;
            try {
                String string3 = string2.substring(1, string2.length() - 1);
                String string4 = System.getenv(string3).replaceAll("\\\\", "\\\\\\\\");
                matcher.appendReplacement(stringBuffer, string4);
            }
            catch (Exception exception) {
                stringBuffer.append(string2);
            }
        }
        matcher.appendTail(stringBuffer);
        return stringBuffer.toString();
    }
}

