/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.base.util;

import com.agfa.pacs.base.util.DateTimeUtils;
import com.agfa.pacs.base.util.Dcm4cheUtils;
import com.agfa.pacs.base.util.DicomModalityComparator;
import com.agfa.pacs.base.util.PersonNameUtilities;
import com.agfa.pacs.data.dicom.DicomPropertiesOwner;
import com.agfa.pacs.data.dicom.comm.DicomCFindConst;
import com.agfa.pacs.data.shared.code.Code;
import com.agfa.pacs.data.shared.code.CodeDictionary;
import com.agfa.pacs.data.shared.dicom.IDicomNode;
import com.agfa.pacs.data.shared.dicom.UIDType;
import com.agfa.pacs.data.shared.dicom.UIDUtilities;
import com.agfa.pacs.data.shared.lw.DataInfoUtilities;
import com.agfa.pacs.data.shared.lw.IDataInfo;
import com.agfa.pacs.data.shared.lw.IObjectInfo;
import com.agfa.pacs.data.shared.lw.ISeriesInfo;
import com.agfa.pacs.data.shared.lw.IStudyInfo;
import com.agfa.pacs.data.shared.node.DataInfoNodeProviderFactory;
import com.agfa.pacs.data.shared.node.IDataInfoNode;
import com.agfa.pacs.data.shared.node.IDataInfoNodeProvider;
import com.agfa.pacs.logging.ALogger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.ElementDictionary;
import org.dcm4che3.data.PersonName;
import org.dcm4che3.data.VR;
import org.dcm4che3.util.TagUtils;

public class DicomUtils {
    private static final ALogger log = ALogger.getLogger(DicomUtils.class);
    private static final HashMap<Integer, int[]> nestedDicomTagMap = new HashMap();

    static {
        int[][] nArray = DicomCFindConst.SERIES_NESTED_TAGS;
        int n = DicomCFindConst.SERIES_NESTED_TAGS.length;
        int n2 = 0;
        while (n2 < n) {
            int[] nArray2 = nArray[n2];
            int n3 = nArray2[nArray2.length - 1];
            nestedDicomTagMap.put(n3, nArray2);
            ++n2;
        }
        int[] nArray3 = new int[3];
        nArray3[0] = 4194933;
        nArray3[2] = 3280947;
        nestedDicomTagMap.put(3280947, nArray3);
        int[] nArray4 = new int[3];
        nArray4[0] = 4194933;
        nArray4[2] = 3280946;
        nestedDicomTagMap.put(3280946, nArray4);
    }

    public static int[] getFullTagPath(int n) {
        if (nestedDicomTagMap.containsKey(n)) {
            return nestedDicomTagMap.get(n);
        }
        return null;
    }

    public static boolean isSecondaryCapture(String string) {
        return UIDUtilities.isType((String)string, (UIDType)UIDType.SecondaryCapture);
    }

    public static boolean isSession(IObjectInfo iObjectInfo) {
        if (UIDUtilities.isType((String)iObjectInfo.getSOPClassUID(), (UIDType)UIDType.KeyObject)) {
            Code code = Code.create((Attributes)iObjectInfo.getAttributes(), (int)4235331);
            return code != null && CodeDictionary.TianiKeyObjectSelectionDocumentTitle.Session.getCodeValue().equals(code.getCodeValue());
        }
        return false;
    }

    public static boolean isVideoData(String string) {
        return UIDUtilities.isType((String)string, (UIDType)UIDType.Video);
    }

    public static String getString(Attributes attributes, int n) {
        Object object = DicomUtils.getObject(attributes, n);
        if (object == null) {
            return null;
        }
        if (object instanceof String) {
            return (String)object;
        }
        if (object instanceof Date) {
            VR vR = ElementDictionary.vrOf((int)n, null);
            if (vR == VR.DA) {
                return DateTimeUtils.date2String((Date)object);
            }
            if (VR.DT == vR) {
                return DateTimeUtils.dateTime2String((Date)object);
            }
            return DateTimeUtils.time2String((Date)object);
        }
        return object.toString();
    }

    private static Object getObject(Attributes attributes, int n, VR vR) {
        if (!attributes.containsValue(n)) {
            return null;
        }
        if (vR == VR.LO || vR == VR.SH || vR == VR.ST) {
            return attributes.getString(n);
        }
        if (vR == VR.CS) {
            if (n == 524385) {
                return DicomUtils.getModalitiesInStudiesAsString(attributes.getStrings(n), false, false);
            }
            return attributes.getString(n);
        }
        if (vR == VR.PN) {
            try {
                PersonName personName = new PersonName(attributes.getString(n), true);
                return PersonNameUtilities.personNameToHRReverse((PersonName)personName);
            }
            catch (Exception exception) {
                return attributes.getString(n);
            }
        }
        if (vR == VR.DA || vR == VR.DT || vR == VR.TM) {
            return Dcm4cheUtils.getDate((int)n, (Attributes)attributes);
        }
        if (vR == VR.SQ) {
            List list = Code.createList((List)attributes.getSequence(n));
            StringBuilder stringBuilder = new StringBuilder();
            for (Code code : list) {
                stringBuilder.append(code.getCodeMeaning()).append(',');
            }
            if (stringBuilder.length() > 0) {
                stringBuilder.deleteCharAt(stringBuilder.length() - 1);
            }
            return stringBuilder.toString();
        }
        if (vR == VR.DS || vR == VR.FL || vR == VR.FD) {
            return attributes.getDouble(n, 0.0);
        }
        if (vR == VR.IS || vR == VR.SL || vR == VR.SS || vR == VR.US || vR == VR.UL) {
            return attributes.getInt(n, 0);
        }
        if (vR == VR.LT || vR == VR.UT || vR == VR.UI || vR == VR.AE || vR == VR.AS) {
            return attributes.getString(n);
        }
        log.warn("Unknown vr:" + vR + " in tag" + n);
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Object getObject(Attributes attributes, int n) {
        Attributes attributes2;
        block6: {
            if (n < 0) {
                return null;
            }
            if (attributes == null) {
                return null;
            }
            if (n == 4390932) {
                return attributes.getString("dcm4che/archive", n);
            }
            int[] nArray = nestedDicomTagMap.get(n);
            try {
                if (nArray == null) return DicomUtils.getObject(attributes, n, ElementDictionary.vrOf((int)n, null));
                attributes2 = Dcm4cheUtils.getNestedDataset((int[])nArray, (Attributes)attributes, (boolean)false);
                if (attributes2 != null) break block6;
                return null;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                log.warn("Could not parse tag " + TagUtils.toString((int)n));
                return null;
            }
        }
        return DicomUtils.getObject(attributes2, n, ElementDictionary.vrOf((int)n, null));
    }

    public static Object getObject(Attributes attributes, int[] nArray) {
        if (nArray == null || nArray.length == 0) {
            return null;
        }
        Attributes attributes2 = Dcm4cheUtils.getNestedDataset((int[])nArray, (Attributes)attributes, (boolean)false);
        if (attributes2 == null) {
            return null;
        }
        return DicomUtils.getObject(attributes2, nArray[nArray.length - 1], ElementDictionary.vrOf((int)nArray[nArray.length - 1], null));
    }

    public static IDataInfoNode createDataInfoNode(String string, IDicomNode iDicomNode) throws Exception {
        IDataInfoNodeProvider iDataInfoNodeProvider = DataInfoNodeProviderFactory.getInstance().getDataNodeProvider("AGFADICOMWADO");
        if (iDataInfoNodeProvider != null) {
            DicomPropertiesOwner dicomPropertiesOwner = new DicomPropertiesOwner(iDicomNode);
            Properties properties = dicomPropertiesOwner.properties();
            properties.put("relationalQuery", Boolean.TRUE.toString());
            properties.put("wadoURI", "http://" + iDicomNode.getHost() + ":8080/wado");
            return iDataInfoNodeProvider.createDataNode(string, properties);
        }
        return null;
    }

    private static String getModalitiesInStudiesAsString(String[] stringArray, boolean bl, boolean bl2) {
        if (stringArray == null || stringArray.length == 0) {
            return null;
        }
        Arrays.sort(stringArray, new DicomModalityComparator());
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl3 = false;
        String[] stringArray2 = stringArray;
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            block8: {
                String string;
                block10: {
                    block9: {
                        string = stringArray2[n2];
                        if (string == null) break block8;
                        if (!string.equals("KO")) break block9;
                        bl3 = true;
                        if (!bl) break block10;
                        break block8;
                    }
                    if (string.equals("PR") ? bl : (string.equals("SR") || string.equals("PDF")) && bl2) break block8;
                }
                stringBuilder.append(string).append(',');
            }
            ++n2;
        }
        if (stringBuilder.length() > 0) {
            stringBuilder.deleteCharAt(stringBuilder.length() - 1);
        } else if (stringBuilder.length() == 0 && bl3) {
            stringBuilder.append("KO");
        }
        return stringBuilder.toString();
    }

    public static String[] getModalitiesInStudy(IStudyInfo iStudyInfo, boolean bl) {
        List list;
        String[] stringArray = iStudyInfo.getAttributes().getStrings(524385);
        if (stringArray == null && bl && (list = iStudyInfo.getSeries()) != null && !list.isEmpty()) {
            ArrayList<String> arrayList = new ArrayList<String>();
            for (ISeriesInfo iSeriesInfo : list) {
                String string = iSeriesInfo.getAttributes().getString(524384, null);
                if (arrayList.contains(string)) continue;
                arrayList.add(string);
            }
            stringArray = arrayList.toArray(new String[arrayList.size()]);
        }
        return stringArray;
    }

    public static String getModalitiesInStudiesAsString(IStudyInfo iStudyInfo, boolean bl, boolean bl2, boolean bl3) {
        String[] stringArray = DicomUtils.getModalitiesInStudy(iStudyInfo, bl3);
        return DicomUtils.getModalitiesInStudiesAsString(stringArray, bl, bl2);
    }

    public static String getModalitiesInStudiesAsString(Attributes attributes, boolean bl, boolean bl2) {
        String[] stringArray = attributes.getStrings(524385);
        return DicomUtils.getModalitiesInStudiesAsString(stringArray, bl, bl2);
    }

    public static Collection<String> getExaminedParts(IStudyInfo iStudyInfo) {
        List list = DataInfoUtilities.getLevel((IDataInfo)iStudyInfo, ISeriesInfo.class);
        HashSet<String> hashSet = new HashSet<String>();
        for (IDataInfo iDataInfo : list) {
            String string = iDataInfo.getAttributes().getString(1572885, null);
            if (string == null || string.isEmpty()) continue;
            hashSet.add(string.toUpperCase(Locale.getDefault()));
        }
        return hashSet;
    }

    public static PersonName getPersonNameFromFirstSeries(IDataInfo iDataInfo, int n) {
        String string;
        List list = DataInfoUtilities.getLevel((IDataInfo)iDataInfo, ISeriesInfo.class);
        if (list != null && !list.isEmpty() && (string = ((ISeriesInfo)list.get(0)).getAttributes().getString(n)) != null) {
            return new PersonName(string);
        }
        return null;
    }

    public static String getStringFromFirstSeries(IDataInfo iDataInfo, int n) {
        List list = DataInfoUtilities.getLevel((IDataInfo)iDataInfo, ISeriesInfo.class);
        ISeriesInfo iSeriesInfo2 = null;
        for (ISeriesInfo iSeriesInfo2 : list) {
            String string = iSeriesInfo2.getString(524384);
            if (string == null || string.equalsIgnoreCase("PDF") || string.equals("SR") || string.equals("KO") || string.equals("PR")) continue;
            return (String)DicomUtils.getObject(iSeriesInfo2.getAttributes(), n);
        }
        return null;
    }
}

