/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.base.util;

import com.agfa.pacs.base.util.IFileServiceData;
import com.agfa.pacs.base.util.Product;
import com.agfa.pacs.config.ConfigurationProviderFactory;
import com.agfa.pacs.services.IHTTPClientService;
import com.agfa.pacs.services.IHTTPPostData;
import com.agfa.pacs.tools.StreamUtil;
import com.agfa.pacs.tools.URLEncodeUtil;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;

public class FileServiceUtil {
    public static final String SET_ASIDE_SCOPE = "set-aside";
    public static final String CODING_SYSTEMS_SCOPE = "coding-systems";
    private static final String SPACE_STRING = " ";
    private static final String HTTP_SPACE_PLACEHOLDER = "%20";
    public static final String PARAMETER_ACTION = "action";
    private final String scope;
    private boolean serviceable = true;

    public FileServiceUtil(String string) {
        this.scope = string;
        if (Product.isInOfflineModus() || Product.isInEmergencyMode()) {
            this.serviceable = false;
        }
    }

    public boolean isServiceable() {
        return !Product.isInOfflineModus() && !Product.isInEmergencyMode() && !Product.isCDViewer() && ConfigurationProviderFactory.getConfig().isSupportingRoles();
    }

    public boolean isDataAvailable(String string, String string2) throws Exception {
        InputStream inputStream = this.makeHttpGETRequest(this.createParameterString(Actions.GET_COUNT, string, string2));
        if (inputStream == null) {
            return false;
        }
        byte[] byArray = StreamUtil.readStreamSimple((InputStream)inputStream);
        if (byArray != null && byArray.length > 0) {
            return Integer.parseInt(new String(byArray)) > 0;
        }
        throw new Exception("Checking " + this.scope + " data availability failed!");
    }

    public Collection<String> getFileNames(String string, String string2) throws Exception {
        if (!this.serviceable) {
            return Collections.emptyList();
        }
        InputStream inputStream = this.makeHttpGETRequest(this.createParameterString(Actions.GET_NAMES, string, string2));
        if (inputStream == null) {
            return Collections.emptyList();
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        DataInputStream dataInputStream = new DataInputStream(inputStream);
        try {
            boolean bl = false;
            while (!bl) {
                try {
                    arrayList.add(dataInputStream.readUTF());
                }
                catch (EOFException eOFException) {
                    bl = true;
                }
            }
        }
        finally {
            StreamUtil.flushRead((InputStream)inputStream);
            dataInputStream.close();
        }
        return arrayList;
    }

    public InputStream getDataStream(String string, String string2) throws Exception {
        DataInputStream dataInputStream = new DataInputStream(this.getResponseStream(string, string2));
        dataInputStream.readUTF();
        return dataInputStream;
    }

    public Date getLastModifiedHead(String string, String string2) {
        return ((IHTTPClientService)IHTTPClientService.FACTORY.getInstance()).getLastModifiedFromHEAD(FileServiceUtil.buildURL(this.createParameterString(Actions.GET, string, string2)));
    }

    protected InputStream getResponseStream(String string, String string2) throws Exception {
        return this.makeHttpGETRequest(this.createParameterString(Actions.GET, string, string2));
    }

    public void saveData(IFileServiceData iFileServiceData, boolean bl, boolean bl2) throws Exception {
        StringBuilder stringBuilder = new StringBuilder(50);
        FileServiceUtil.appendParameterString(stringBuilder, Actions.SAVE, this.scope, iFileServiceData.getUserId(), null);
        stringBuilder.append("&override=");
        stringBuilder.append(bl);
        stringBuilder.append("&exclusive=");
        stringBuilder.append(bl2);
        Throwable throwable = null;
        Object var6_7 = null;
        try (InputStream inputStream = this.makeHttpPOSTRequest(stringBuilder.toString(), iFileServiceData);){
            if (inputStream == null) {
                throw new Exception("Saving " + this.scope + " data failed!");
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public void deleteData(String string) throws Exception {
        this.deleteData(string, ".*");
    }

    public void deleteData(String string, String string2) throws Exception {
        Throwable throwable = null;
        Object var4_4 = null;
        try {
            InputStream inputStream = this.makeHttpGETRequest(this.createParameterString(Actions.DELETE, string, string2));
            if (inputStream != null) {
                inputStream.close();
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static String getFileServiceUrl() {
        return "lta/file";
    }

    public static String createQueryURL(Actions actions, String string, String string2, String string3) {
        return FileServiceUtil.buildURL(FileServiceUtil.createGETRequestParameters(actions, string, string2, string3));
    }

    private String createParameterString(Actions actions, String string, String string2) {
        return FileServiceUtil.createGETRequestParameters(actions, this.scope, string, string2);
    }

    private static String createGETRequestParameters(Actions actions, String string, String string2, String string3) {
        StringBuilder stringBuilder = new StringBuilder();
        FileServiceUtil.appendParameterString(stringBuilder, actions, string, string2, string3);
        return stringBuilder.toString();
    }

    private static void appendParameterString(StringBuilder stringBuilder, Actions actions, String string, String string2, String string3) {
        stringBuilder.append(PARAMETER_ACTION);
        stringBuilder.append('=');
        stringBuilder.append((Object)actions);
        if (string != null) {
            stringBuilder.append("&scope=");
            stringBuilder.append(string);
        }
        if (string2 != null) {
            stringBuilder.append("&user-id=");
            stringBuilder.append(string2);
        }
        if (string3 != null) {
            stringBuilder.append("&pattern=");
            stringBuilder.append(URLEncodeUtil.encode((String)string3));
        }
    }

    private InputStream makeHttpGETRequest(String string) throws Exception {
        return ((IHTTPClientService)IHTTPClientService.FACTORY.getInstance()).performGETasStream(FileServiceUtil.buildURL(string));
    }

    private InputStream makeHttpPOSTRequest(String string, IFileServiceData iFileServiceData) {
        return ((IHTTPClientService)IHTTPClientService.FACTORY.getInstance()).performPOSTasStream(FileServiceUtil.buildURL(string), (IHTTPPostData)iFileServiceData);
    }

    private static String buildURL(String string) {
        return String.valueOf(FileServiceUtil.getFileServiceUrl()) + "?" + string.replaceAll(SPACE_STRING, HTTP_SPACE_PLACEHOLDER);
    }

    public static enum Actions {
        GET("get"),
        GET_COUNT("get-count"),
        GET_NAMES("get-names"),
        EXIST("exist"),
        DELETE("delete"),
        SAVE("save"),
        GET_TRUSTED("getTrusted"),
        GET_PRIVATE("getPrivate"),
        GET_GLOBAL_PRIVATE("getGlobalPrivate");

        private final String action;

        private Actions(String string2) {
            this.action = string2;
        }

        public String toString() {
            return this.action;
        }
    }
}

